/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.threatIntel.action;

import java.io.IOException;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.securityanalytics.threatIntel.model.SATIFSourceConfigDto;

public class SAGetTIFSourceConfigResponse
extends ActionResponse
implements ToXContentObject {
    private final String id;
    private final Long version;
    private final RestStatus status;
    private final SATIFSourceConfigDto saTifSourceConfigDto;

    public SAGetTIFSourceConfigResponse(String id, Long version, RestStatus status, SATIFSourceConfigDto saTifSourceConfigDto) {
        this.id = id;
        this.version = version;
        this.status = status;
        this.saTifSourceConfigDto = saTifSourceConfigDto;
    }

    public SAGetTIFSourceConfigResponse(StreamInput sin) throws IOException {
        this(sin.readString(), sin.readLong(), (RestStatus)sin.readEnum(RestStatus.class), sin.readBoolean() ? SATIFSourceConfigDto.readFrom(sin) : null);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.id);
        out.writeLong(this.version.longValue());
        out.writeEnum((Enum)this.status);
        if (this.saTifSourceConfigDto != null) {
            out.writeBoolean(true);
            this.saTifSourceConfigDto.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject().field("_id", this.id).field("_version", this.version);
        builder.startObject("source_config").field("name", this.saTifSourceConfigDto.getName()).field("format", this.saTifSourceConfigDto.getFormat()).field("type", (Object)this.saTifSourceConfigDto.getType()).field("ioc_types", this.saTifSourceConfigDto.getIocTypes()).field("description", this.saTifSourceConfigDto.getDescription()).field("created_by_user", (ToXContent)this.saTifSourceConfigDto.getCreatedByUser()).field("created_at", (Object)this.saTifSourceConfigDto.getCreatedAt()).field("source", (Object)this.saTifSourceConfigDto.getSource()).field("enabled", this.saTifSourceConfigDto.isEnabled()).field("enabled_time", (Object)this.saTifSourceConfigDto.getEnabledTime()).field("last_update_time", (Object)this.saTifSourceConfigDto.getLastUpdateTime()).field("schedule", (ToXContent)this.saTifSourceConfigDto.getSchedule()).field("state", (Object)this.saTifSourceConfigDto.getState()).field("refresh_type", (Object)this.saTifSourceConfigDto.getRefreshType()).field("last_refreshed_user", (ToXContent)this.saTifSourceConfigDto.getLastRefreshedUser()).field("last_refreshed_time", (Object)this.saTifSourceConfigDto.getLastRefreshedTime());
        builder.endObject();
        return builder.endObject();
    }

    public String getId() {
        return this.id;
    }

    public Long getVersion() {
        return this.version;
    }

    public RestStatus getStatus() {
        return this.status;
    }

    public SATIFSourceConfigDto getSaTifSourceConfigDto() {
        return this.saTifSourceConfigDto;
    }
}

