/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.securityanalytics.resthandler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.client.node.NodeClient;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.securityanalytics.action.AckCorrelationAlertsAction;
import org.opensearch.securityanalytics.action.AckCorrelationAlertsRequest;

public class RestAcknowledgeCorrelationAlertsAction
extends BaseRestHandler {
    public String getName() {
        return "ack_correlation_alerts_action";
    }

    public List<RestHandler.Route> routes() {
        return Collections.singletonList(new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.getDefault(), "%s/_acknowledge/correlationAlerts", "/_plugins/_security_analytics")));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient nodeClient) throws IOException {
        List<String> alertIds = this.getAlertIds(request.contentParser());
        AckCorrelationAlertsRequest CorrelationAckAlertsRequest = new AckCorrelationAlertsRequest(alertIds);
        return channel -> nodeClient.execute((ActionType)AckCorrelationAlertsAction.INSTANCE, (ActionRequest)CorrelationAckAlertsRequest, (ActionListener)new RestToXContentListener(channel));
    }

    private List<String> getAlertIds(XContentParser xcp) throws IOException {
        ArrayList<String> ids = new ArrayList<String>();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
        while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = xcp.currentName();
            xcp.nextToken();
            if (!fieldName.equals("alertIds")) continue;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                ids.add(xcp.text());
            }
        }
        return ids;
    }
}

