/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.ssl.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.opensearch.common.settings.Settings;

public final class SSLConfigConstants {
    public static final String SECURITY_SSL_HTTP_ENABLE_OPENSSL_IF_AVAILABLE = "plugins.security.ssl.http.enable_openssl_if_available";
    public static final String SECURITY_SSL_HTTP_ENABLED = "plugins.security.ssl.http.enabled";
    public static final boolean SECURITY_SSL_HTTP_ENABLED_DEFAULT = false;
    public static final String SECURITY_SSL_HTTP_CLIENTAUTH_MODE = "plugins.security.ssl.http.clientauth_mode";
    public static final String SECURITY_SSL_HTTP_KEYSTORE_ALIAS = "plugins.security.ssl.http.keystore_alias";
    public static final String SECURITY_SSL_HTTP_KEYSTORE_FILEPATH = "plugins.security.ssl.http.keystore_filepath";
    public static final String SECURITY_SSL_HTTP_PEMKEY_FILEPATH = "plugins.security.ssl.http.pemkey_filepath";
    public static final String SECURITY_SSL_HTTP_PEMCERT_FILEPATH = "plugins.security.ssl.http.pemcert_filepath";
    public static final String SECURITY_SSL_HTTP_PEMTRUSTEDCAS_FILEPATH = "plugins.security.ssl.http.pemtrustedcas_filepath";
    public static final String SECURITY_SSL_HTTP_KEYSTORE_TYPE = "plugins.security.ssl.http.keystore_type";
    public static final String SECURITY_SSL_HTTP_TRUSTSTORE_ALIAS = "plugins.security.ssl.http.truststore_alias";
    public static final String SECURITY_SSL_HTTP_TRUSTSTORE_FILEPATH = "plugins.security.ssl.http.truststore_filepath";
    public static final String SECURITY_SSL_HTTP_TRUSTSTORE_TYPE = "plugins.security.ssl.http.truststore_type";
    public static final String SECURITY_SSL_TRANSPORT_ENABLE_OPENSSL_IF_AVAILABLE = "plugins.security.ssl.transport.enable_openssl_if_available";
    public static final String SECURITY_SSL_TRANSPORT_ENABLED = "plugins.security.ssl.transport.enabled";
    public static final boolean SECURITY_SSL_TRANSPORT_ENABLED_DEFAULT = true;
    public static final String SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION = "plugins.security.ssl.transport.enforce_hostname_verification";
    public static final String SECURITY_SSL_TRANSPORT_ENFORCE_HOSTNAME_VERIFICATION_RESOLVE_HOST_NAME = "plugins.security.ssl.transport.resolve_hostname";
    public static final String SECURITY_SSL_TRANSPORT_KEYSTORE_ALIAS = "plugins.security.ssl.transport.keystore_alias";
    public static final String SECURITY_SSL_TRANSPORT_SERVER_KEYSTORE_ALIAS = "plugins.security.ssl.transport.server.keystore_alias";
    public static final String SECURITY_SSL_TRANSPORT_CLIENT_KEYSTORE_ALIAS = "plugins.security.ssl.transport.client.keystore_alias";
    public static final String SECURITY_SSL_TRANSPORT_KEYSTORE_FILEPATH = "plugins.security.ssl.transport.keystore_filepath";
    public static final String SECURITY_SSL_TRANSPORT_PEMKEY_FILEPATH = "plugins.security.ssl.transport.pemkey_filepath";
    public static final String SECURITY_SSL_TRANSPORT_PEMCERT_FILEPATH = "plugins.security.ssl.transport.pemcert_filepath";
    public static final String SECURITY_SSL_TRANSPORT_PEMTRUSTEDCAS_FILEPATH = "plugins.security.ssl.transport.pemtrustedcas_filepath";
    public static final String SECURITY_SSL_TRANSPORT_EXTENDED_KEY_USAGE_ENABLED = "plugins.security.ssl.transport.extended_key_usage_enabled";
    public static final boolean SECURITY_SSL_TRANSPORT_EXTENDED_KEY_USAGE_ENABLED_DEFAULT = false;
    public static final String SECURITY_SSL_TRANSPORT_SERVER_PEMKEY_FILEPATH = "plugins.security.ssl.transport.server.pemkey_filepath";
    public static final String SECURITY_SSL_TRANSPORT_SERVER_PEMCERT_FILEPATH = "plugins.security.ssl.transport.server.pemcert_filepath";
    public static final String SECURITY_SSL_TRANSPORT_SERVER_PEMTRUSTEDCAS_FILEPATH = "plugins.security.ssl.transport.server.pemtrustedcas_filepath";
    public static final String SECURITY_SSL_TRANSPORT_CLIENT_PEMKEY_FILEPATH = "plugins.security.ssl.transport.client.pemkey_filepath";
    public static final String SECURITY_SSL_TRANSPORT_CLIENT_PEMCERT_FILEPATH = "plugins.security.ssl.transport.client.pemcert_filepath";
    public static final String SECURITY_SSL_TRANSPORT_CLIENT_PEMTRUSTEDCAS_FILEPATH = "plugins.security.ssl.transport.client.pemtrustedcas_filepath";
    public static final String SECURITY_SSL_TRANSPORT_KEYSTORE_TYPE = "plugins.security.ssl.transport.keystore_type";
    public static final String SECURITY_SSL_TRANSPORT_TRUSTSTORE_ALIAS = "plugins.security.ssl.transport.truststore_alias";
    public static final String SECURITY_SSL_TRANSPORT_SERVER_TRUSTSTORE_ALIAS = "plugins.security.ssl.transport.server.truststore_alias";
    public static final String SECURITY_SSL_TRANSPORT_CLIENT_TRUSTSTORE_ALIAS = "plugins.security.ssl.transport.client.truststore_alias";
    public static final String SECURITY_SSL_TRANSPORT_TRUSTSTORE_FILEPATH = "plugins.security.ssl.transport.truststore_filepath";
    public static final String SECURITY_SSL_TRANSPORT_TRUSTSTORE_TYPE = "plugins.security.ssl.transport.truststore_type";
    public static final String SECURITY_SSL_TRANSPORT_ENABLED_CIPHERS = "plugins.security.ssl.transport.enabled_ciphers";
    public static final String SECURITY_SSL_TRANSPORT_ENABLED_PROTOCOLS = "plugins.security.ssl.transport.enabled_protocols";
    public static final String SECURITY_SSL_HTTP_ENABLED_CIPHERS = "plugins.security.ssl.http.enabled_ciphers";
    public static final String SECURITY_SSL_HTTP_ENABLED_PROTOCOLS = "plugins.security.ssl.http.enabled_protocols";
    public static final String SECURITY_SSL_CLIENT_EXTERNAL_CONTEXT_ID = "plugins.security.ssl.client.external_context_id";
    public static final String SECURITY_SSL_TRANSPORT_PRINCIPAL_EXTRACTOR_CLASS = "plugins.security.ssl.transport.principal_extractor_class";
    public static final String SSECURITY_SSL_HTTP_CRL_FILE = "plugins.security.ssl.http.crl.file_path";
    public static final String SECURITY_SSL_HTTP_CRL_VALIDATE = "plugins.security.ssl.http.crl.validate";
    public static final String SECURITY_SSL_HTTP_CRL_PREFER_CRLFILE_OVER_OCSP = "plugins.security.ssl.http.crl.prefer_crlfile_over_ocsp";
    public static final String SECURITY_SSL_HTTP_CRL_CHECK_ONLY_END_ENTITIES = "plugins.security.ssl.http.crl.check_only_end_entities";
    public static final String SECURITY_SSL_HTTP_CRL_DISABLE_OCSP = "plugins.security.ssl.http.crl.disable_ocsp";
    public static final String SECURITY_SSL_HTTP_CRL_DISABLE_CRLDP = "plugins.security.ssl.http.crl.disable_crldp";
    public static final String SECURITY_SSL_HTTP_CRL_VALIDATION_DATE = "plugins.security.ssl.http.crl.validation_date";
    public static final String SECURITY_SSL_ALLOW_CLIENT_INITIATED_RENEGOTIATION = "plugins.security.ssl.allow_client_initiated_renegotiation";
    public static final String DEFAULT_STORE_PASSWORD = "changeit";
    public static final String JDK_TLS_REJECT_CLIENT_INITIATED_RENEGOTIATION = "jdk.tls.rejectClientInitiatedRenegotiation";
    private static final String[] _SECURE_SSL_PROTOCOLS = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1"};
    private static final String[] _SECURE_SSL_CIPHERS = new String[]{"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_128_GCM_SHA256", "TLS_DHE_DSS_WITH_AES_256_GCM_SHA384", "TLS_DHE_RSA_WITH_AES_256_GCM_SHA384", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA256", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA256", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "TLS_DHE_RSA_WITH_CHACHA20_POLY1305_SHA256", "SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256", "SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256", "SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384", "SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384", "SSL_DHE_RSA_WITH_AES_128_GCM_SHA256", "SSL_DHE_DSS_WITH_AES_128_GCM_SHA256", "SSL_DHE_DSS_WITH_AES_256_GCM_SHA384", "SSL_DHE_RSA_WITH_AES_256_GCM_SHA384", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256", "SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA", "SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384", "SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384", "SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA", "SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA256", "SSL_DHE_RSA_WITH_AES_128_CBC_SHA", "SSL_DHE_DSS_WITH_AES_128_CBC_SHA256", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA256", "SSL_DHE_DSS_WITH_AES_256_CBC_SHA", "SSL_DHE_RSA_WITH_AES_256_CBC_SHA"};

    public static String[] getSecureSSLProtocols(Settings settings, boolean http) {
        List configuredProtocols = null;
        if (settings != null) {
            configuredProtocols = http ? settings.getAsList(SECURITY_SSL_HTTP_ENABLED_PROTOCOLS, Collections.emptyList()) : settings.getAsList(SECURITY_SSL_TRANSPORT_ENABLED_PROTOCOLS, Collections.emptyList());
        }
        if (configuredProtocols != null && configuredProtocols.size() > 0) {
            return configuredProtocols.toArray(new String[0]);
        }
        return (String[])_SECURE_SSL_PROTOCOLS.clone();
    }

    public static List<String> getSecureSSLCiphers(Settings settings, boolean http) {
        List configuredCiphers = null;
        if (settings != null) {
            configuredCiphers = http ? settings.getAsList(SECURITY_SSL_HTTP_ENABLED_CIPHERS, Collections.emptyList()) : settings.getAsList(SECURITY_SSL_TRANSPORT_ENABLED_CIPHERS, Collections.emptyList());
        }
        if (configuredCiphers != null && configuredCiphers.size() > 0) {
            return configuredCiphers;
        }
        return Collections.unmodifiableList(Arrays.asList(_SECURE_SSL_CIPHERS));
    }

    private SSLConfigConstants() {
    }
}

