/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.query.planner.physical.node.scroll;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentType;
import org.opensearch.core.common.Strings;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.legacy.domain.Where;
import org.opensearch.sql.legacy.exception.SqlParseException;
import org.opensearch.sql.legacy.query.join.TableInJoinRequestBuilder;
import org.opensearch.sql.legacy.query.maker.QueryMaker;
import org.opensearch.sql.legacy.query.planner.core.ExecuteParams;
import org.opensearch.sql.legacy.query.planner.core.PlanNode;
import org.opensearch.sql.legacy.query.planner.physical.Row;
import org.opensearch.sql.legacy.query.planner.physical.estimation.Cost;
import org.opensearch.sql.legacy.query.planner.physical.node.BatchPhysicalOperator;
import org.opensearch.sql.legacy.query.planner.physical.node.scroll.SearchHitRow;
import org.opensearch.sql.legacy.query.planner.resource.ResourceManager;

public class Scroll
extends BatchPhysicalOperator<SearchHit> {
    private final TableInJoinRequestBuilder request;
    private final int pageSize;
    private Client client;
    private SearchResponse scrollResponse;
    private Integer timeout;
    private ResourceManager resourceMgr;

    public Scroll(TableInJoinRequestBuilder request, int pageSize) {
        this.request = request;
        this.pageSize = pageSize;
    }

    @Override
    public PlanNode[] children() {
        return new PlanNode[0];
    }

    @Override
    public Cost estimate() {
        return new Cost();
    }

    @Override
    public void open(ExecuteParams params) throws Exception {
        super.open(params);
        this.client = (Client)params.get(ExecuteParams.ExecuteParamType.CLIENT);
        this.timeout = (Integer)params.get(ExecuteParams.ExecuteParamType.TIMEOUT);
        this.resourceMgr = (ResourceManager)params.get(ExecuteParams.ExecuteParamType.RESOURCE_MANAGER);
        Object filter = params.get(ExecuteParams.ExecuteParamType.EXTRA_QUERY_FILTER);
        if (filter instanceof BoolQueryBuilder) {
            this.request.getRequestBuilder().setQuery(this.generateNewQueryWithExtraFilter((BoolQueryBuilder)filter));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received extra query filter, re-build query: {}", (Object)Strings.toString((MediaType)XContentType.JSON, (ToXContent)((SearchRequest)this.request.getRequestBuilder().request()).source(), (boolean)true, (boolean)true));
            }
        }
    }

    @Override
    public void close() {
        if (this.scrollResponse != null) {
            LOG.debug("Closing all scroll resources");
            ClearScrollResponse clearScrollResponse = (ClearScrollResponse)this.client.prepareClearScroll().addScrollId(this.scrollResponse.getScrollId()).get();
            if (!clearScrollResponse.isSucceeded()) {
                LOG.warn("Failed to close scroll: {}", (Object)clearScrollResponse.status());
            }
            this.scrollResponse = null;
        } else {
            LOG.debug("Scroll already be closed");
        }
    }

    @Override
    protected Collection<Row<SearchHit>> prefetch() {
        Objects.requireNonNull(this.client, "Client connection is not ready");
        Objects.requireNonNull(this.resourceMgr, "ResourceManager is not set");
        Objects.requireNonNull(this.timeout, "Time out is not set");
        if (this.scrollResponse == null) {
            this.loadFirstBatch();
            this.updateMetaResult();
        } else {
            this.loadNextBatchByScrollId();
        }
        return this.wrapRowForCurrentBatch();
    }

    private QueryBuilder generateNewQueryWithExtraFilter(BoolQueryBuilder filter) throws SqlParseException {
        BoolQueryBuilder newQuery;
        Where where = this.request.getOriginalSelect().getWhere();
        if (where != null) {
            newQuery = QueryMaker.explain(where, false);
            newQuery.must((QueryBuilder)filter);
        } else {
            newQuery = filter;
        }
        return newQuery;
    }

    private void loadFirstBatch() {
        this.scrollResponse = (SearchResponse)this.request.getRequestBuilder().addSort("_doc", SortOrder.ASC).setSize(this.pageSize).setScroll(TimeValue.timeValueSeconds((long)this.timeout.intValue())).get();
    }

    private void updateMetaResult() {
        this.resourceMgr.getMetaResult().addTotalNumOfShards(this.scrollResponse.getTotalShards());
        this.resourceMgr.getMetaResult().addSuccessfulShards(this.scrollResponse.getSuccessfulShards());
        this.resourceMgr.getMetaResult().addFailedShards(this.scrollResponse.getFailedShards());
        this.resourceMgr.getMetaResult().updateTimeOut(this.scrollResponse.isTimedOut());
    }

    private void loadNextBatchByScrollId() {
        this.scrollResponse = (SearchResponse)this.client.prepareSearchScroll(this.scrollResponse.getScrollId()).setScroll(TimeValue.timeValueSeconds((long)this.timeout.intValue())).get();
    }

    private Collection<Row<SearchHit>> wrapRowForCurrentBatch() {
        SearchHit[] hits = this.scrollResponse.getHits().getHits();
        Row[] rows = new Row[hits.length];
        for (int i = 0; i < hits.length; ++i) {
            rows[i] = new SearchHitRow(hits[i], this.request.getAlias());
        }
        return Arrays.asList(rows);
    }

    public String toString() {
        return "Scroll [ " + this.describeTable() + ", pageSize=" + this.pageSize + " ]";
    }

    private String describeTable() {
        return this.request.getOriginalSelect().getFrom().get(0).getIndex() + " as " + this.request.getAlias();
    }

    public String getRequest() {
        return Strings.toString((MediaType)XContentType.JSON, (ToXContent)((SearchRequest)this.request.getRequestBuilder().request()).source());
    }
}

