/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.expression.core.operator;

import java.util.List;
import java.util.function.Function;
import org.opensearch.sql.legacy.expression.core.operator.ScalarOperation;
import org.opensearch.sql.legacy.expression.core.operator.ScalarOperator;
import org.opensearch.sql.legacy.expression.model.ExprValue;
import org.opensearch.sql.legacy.expression.model.ExprValueFactory;
import org.opensearch.sql.legacy.expression.model.ExprValueUtils;

public class DoubleUnaryScalarOperator
implements ScalarOperator {
    private final ScalarOperation op;
    private final Function<Double, Double> doubleFunc;

    @Override
    public ExprValue apply(List<ExprValue> exprValues) {
        ExprValue exprValue = exprValues.get(0);
        switch (exprValue.kind()) {
            case DOUBLE_VALUE: 
            case INTEGER_VALUE: 
            case LONG_VALUE: 
            case FLOAT_VALUE: {
                return ExprValueFactory.from(this.doubleFunc.apply(ExprValueUtils.getDoubleValue(exprValue)));
            }
        }
        throw new RuntimeException(String.format("unexpected operation type: %s(%s)", new Object[]{this.op.name(), exprValue.kind()}));
    }

    @Override
    public String name() {
        return this.op.name();
    }

    public DoubleUnaryScalarOperator(ScalarOperation op, Function<Double, Double> doubleFunc) {
        this.op = op;
        this.doubleFunc = doubleFunc;
    }
}

