/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.join;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchRequestBuilder;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.common.io.stream.BytesStreamOutput;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;
import org.opensearch.search.sort.SortOrder;
import org.opensearch.sql.legacy.domain.Select;
import org.opensearch.sql.legacy.executor.join.ElasticJoinExecutor;
import org.opensearch.sql.legacy.executor.join.MetaSearchResult;
import org.opensearch.sql.legacy.query.join.BackOffRetryStrategy;

public class ElasticUtils {
    public static SearchResponse scrollOneTimeWithHits(Client client, SearchRequestBuilder requestBuilder, Select originalSelect, int resultSize) {
        SearchRequestBuilder scrollRequest = requestBuilder.setScroll(new TimeValue(60000L)).setSize(resultSize);
        boolean ordered = originalSelect.isOrderdSelect();
        if (!ordered) {
            scrollRequest.addSort("_doc", SortOrder.ASC);
        }
        SearchResponse responseWithHits = (SearchResponse)scrollRequest.get();
        return responseWithHits;
    }

    public static String hitsAsStringResult(SearchHits results, MetaSearchResult metaResults) throws IOException {
        if (results == null) {
            return null;
        }
        Object[] searchHits = new Object[Optional.ofNullable(results.getTotalHits()).map(th -> th.value).orElse(0L).intValue()];
        int i = 0;
        for (SearchHit hit : results) {
            HashMap<String, Object> value = new HashMap<String, Object>();
            value.put("_id", hit.getId());
            value.put("_score", Float.valueOf(hit.getScore()));
            value.put("_source", hit.getSourceAsMap());
            searchHits[i] = value;
            ++i;
        }
        HashMap<String, Object> hits = new HashMap<String, Object>();
        hits.put("total", ImmutableMap.of((Object)"value", (Object)Optional.ofNullable(results.getTotalHits()).map(th -> th.value).orElse(0L), (Object)"relation", (Object)((Serializable)Optional.ofNullable(results.getTotalHits()).map(th -> th.relation).orElse(TotalHits.Relation.EQUAL_TO))));
        hits.put("max_score", Float.valueOf(results.getMaxScore()));
        hits.put("hits", searchHits);
        XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint();
        builder.startObject();
        builder.field("took", metaResults.getTookImMilli());
        builder.field("timed_out", metaResults.isTimedOut());
        builder.field("_shards", (Map)ImmutableMap.of((Object)"total", (Object)metaResults.getTotalNumOfShards(), (Object)"successful", (Object)metaResults.getSuccessfulShards(), (Object)"failed", (Object)metaResults.getFailedShards()));
        builder.field("hits", hits);
        builder.endObject();
        return BytesReference.bytes((XContentBuilder)builder).utf8ToString();
    }

    public static XContentBuilder hitsAsStringResultZeroCopy(List<SearchHit> results, MetaSearchResult metaResults, ElasticJoinExecutor executor) throws IOException {
        BytesStreamOutput outputStream = new BytesStreamOutput();
        XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)outputStream).prettyPrint();
        builder.startObject();
        builder.field("took", metaResults.getTookImMilli());
        builder.field("timed_out", metaResults.isTimedOut());
        builder.field("_shards", (Map)ImmutableMap.of((Object)"total", (Object)metaResults.getTotalNumOfShards(), (Object)"successful", (Object)metaResults.getSuccessfulShards(), (Object)"failed", (Object)metaResults.getFailedShards()));
        ElasticUtils.toXContent(builder, ToXContent.EMPTY_PARAMS, results, executor);
        builder.endObject();
        if (!BackOffRetryStrategy.isHealthy(2 * outputStream.size(), executor)) {
            throw new IllegalStateException("Memory could be insufficient when sendResponse().");
        }
        return builder;
    }

    private static void toXContent(XContentBuilder builder, ToXContent.Params params, List<SearchHit> hits, ElasticJoinExecutor executor) throws IOException {
        builder.startObject("hits");
        builder.field("total", (Map)ImmutableMap.of((Object)"value", (Object)hits.size(), (Object)"relation", (Object)TotalHits.Relation.EQUAL_TO));
        builder.field("max_score", 1.0f);
        builder.field("hits");
        builder.startArray();
        for (int i = 0; i < hits.size(); ++i) {
            if (i % 10000 == 0 && !BackOffRetryStrategy.isHealthy()) {
                throw new IllegalStateException("Memory circuit break when generating json builder");
            }
            ElasticUtils.toXContent(builder, params, hits.get(i));
        }
        builder.endArray();
        builder.endObject();
    }

    private static void toXContent(XContentBuilder builder, ToXContent.Params params, SearchHit hit) throws IOException {
        builder.startObject();
        if (hit.getId() != null) {
            builder.field("_id", hit.getId());
        }
        if (Float.isNaN(hit.getScore())) {
            builder.nullField("_score");
        } else {
            builder.field("_score", hit.getScore());
        }
        builder.field("_source", hit.getSourceAsMap());
        builder.endObject();
    }
}

