/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.alerting.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.ClusterMetricsInput;
import org.opensearch.commons.alerting.model.CronSchedule;
import org.opensearch.commons.alerting.model.DataSources;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Input;
import org.opensearch.commons.alerting.model.NoOpTrigger;
import org.opensearch.commons.alerting.model.QueryLevelTrigger;
import org.opensearch.commons.alerting.model.Schedule;
import org.opensearch.commons.alerting.model.ScheduledJob;
import org.opensearch.commons.alerting.model.SearchInput;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.model.remote.monitors.RemoteMonitorTrigger;
import org.opensearch.commons.alerting.settings.SupportedClusterMetricsSettings;
import org.opensearch.commons.alerting.util.IndexUtils;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.authuser.User;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b/\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\b\u0018\u0000 _2\u00020\u0001:\u0002_`B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u00a5\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0006\u0012\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017\u0012\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\b\b\u0002\u0010\u001e\u001a\u00020\u001f\u0012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010!J\u0012\u0010=\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001cJ\t\u0010>\u001a\u00020\u0006H\u00c6\u0003J\t\u0010?\u001a\u00020\u0015H\u00c6\u0003J\u000f\u0010@\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u00c6\u0003J\u000f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017H\u00c6\u0003J\u0015\u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001cH\u00c6\u0003J\t\u0010C\u001a\u00020\u001fH\u00c6\u0003J\u000b\u0010D\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010E\u001a\u00020\bH\u00c6\u0003J\t\u0010F\u001a\u00020\u0006H\u00c6\u0003J\t\u0010G\u001a\u00020\u000bH\u00c6\u0003J\t\u0010H\u001a\u00020\rH\u00c6\u0003J\t\u0010I\u001a\u00020\u000fH\u00c6\u0003J\u000b\u0010J\u001a\u0004\u0018\u00010\u000fH\u00c6\u0003J\t\u0010K\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u0013H\u00c6\u0003J\u00bd\u0001\u0010M\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00062\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00172\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001c2\b\b\u0002\u0010\u001e\u001a\u00020\u001f2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u0006H\u00c6\u0001J \u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\u000bH\u0002J\u0013\u0010T\u001a\u00020\u000b2\b\u0010U\u001a\u0004\u0018\u00010\u001dH\u00d6\u0003J\u0018\u0010V\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\t\u0010W\u001a\u00020\u0015H\u00d6\u0001J\t\u0010X\u001a\u00020\u0006H\u00d6\u0001J\u0018\u0010Y\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020RH\u0016J\u0016\u0010Z\u001a\u00020O2\u0006\u0010P\u001a\u00020O2\u0006\u0010Q\u001a\u00020RJ\u0010\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020^H\u0016R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010'R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010)R\u0014\u0010\t\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010)R\u0013\u0010 \u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010)R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010+R\u0014\u00105\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010)R\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006a"}, d2={"Lorg/opensearch/commons/alerting/model/Monitor;", "Lorg/opensearch/commons/alerting/model/ScheduledJob;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "id", "", "version", "", "name", "enabled", "", "schedule", "Lorg/opensearch/commons/alerting/model/Schedule;", "lastUpdateTime", "Ljava/time/Instant;", "enabledTime", "monitorType", "user", "Lorg/opensearch/commons/authuser/User;", "schemaVersion", "", "inputs", "", "Lorg/opensearch/commons/alerting/model/Input;", "triggers", "Lorg/opensearch/commons/alerting/model/Trigger;", "uiMetadata", "", "", "dataSources", "Lorg/opensearch/commons/alerting/model/DataSources;", "owner", "(Ljava/lang/String;JLjava/lang/String;ZLorg/opensearch/commons/alerting/model/Schedule;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Lorg/opensearch/commons/authuser/User;ILjava/util/List;Ljava/util/List;Ljava/util/Map;Lorg/opensearch/commons/alerting/model/DataSources;Ljava/lang/String;)V", "getDataSources", "()Lorg/opensearch/commons/alerting/model/DataSources;", "getEnabled", "()Z", "getEnabledTime", "()Ljava/time/Instant;", "getId", "()Ljava/lang/String;", "getInputs", "()Ljava/util/List;", "getLastUpdateTime", "getMonitorType", "getName", "getOwner", "getSchedule", "()Lorg/opensearch/commons/alerting/model/Schedule;", "getSchemaVersion", "()I", "getTriggers", "type", "getType", "getUiMetadata", "()Ljava/util/Map;", "getUser", "()Lorg/opensearch/commons/authuser/User;", "getVersion", "()J", "asTemplateArg", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "createXContentBuilder", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "secure", "equals", "other", "fromDocument", "hashCode", "toString", "toXContent", "toXContentWithUser", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "Companion", "MonitorType", "common-utils"})
@SourceDebugExtension(value={"SMAP\nMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Monitor.kt\norg/opensearch/commons/alerting/model/Monitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,357:1\n1855#2:358\n1856#2:360\n1855#2,2:361\n1855#2,2:367\n1855#2,2:369\n1#3:359\n37#4,2:363\n37#4,2:365\n*S KotlinDebug\n*F\n+ 1 Monitor.kt\norg/opensearch/commons/alerting/model/Monitor\n*L\n53#1:358\n53#1:360\n78#1:361,2\n189#1:367,2\n201#1:369,2\n157#1:363,2\n158#1:365,2\n*E\n"})
public final class Monitor
implements ScheduledJob {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long version;
    @NotNull
    private final String name;
    private final boolean enabled;
    @NotNull
    private final Schedule schedule;
    @NotNull
    private final Instant lastUpdateTime;
    @Nullable
    private final Instant enabledTime;
    @NotNull
    private final String monitorType;
    @Nullable
    private final User user;
    private final int schemaVersion;
    @NotNull
    private final List<Input> inputs;
    @NotNull
    private final List<Trigger> triggers;
    @NotNull
    private final Map<String, Object> uiMetadata;
    @NotNull
    private final DataSources dataSources;
    @Nullable
    private final String owner;
    @NotNull
    private final String type;
    @NotNull
    public static final String MONITOR_TYPE = "monitor";
    @NotNull
    public static final String TYPE_FIELD = "type";
    @NotNull
    public static final String MONITOR_TYPE_FIELD = "monitor_type";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String NAME_FIELD = "name";
    @NotNull
    public static final String USER_FIELD = "user";
    @NotNull
    public static final String ENABLED_FIELD = "enabled";
    @NotNull
    public static final String SCHEDULE_FIELD = "schedule";
    @NotNull
    public static final String TRIGGERS_FIELD = "triggers";
    @NotNull
    public static final String NO_ID = "";
    public static final long NO_VERSION = 1L;
    @NotNull
    public static final String INPUTS_FIELD = "inputs";
    @NotNull
    public static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    @NotNull
    public static final String UI_METADATA_FIELD = "ui_metadata";
    @NotNull
    public static final String DATA_SOURCES_FIELD = "data_sources";
    @NotNull
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    @NotNull
    public static final String OWNER_FIELD = "owner";
    private static final Pattern MONITOR_TYPE_PATTERN = Pattern.compile("[a-zA-Z0-9_]{5,25}");
    @NotNull
    private static final NamedXContentRegistry.Entry XCONTENT_REGISTRY = new NamedXContentRegistry.Entry(ScheduledJob.class, new ParseField("monitor", new String[0]), Monitor::XCONTENT_REGISTRY$lambda$13);

    public Monitor(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @NotNull String monitorType, @Nullable User user, int schemaVersion, @NotNull List<? extends Input> inputs, @NotNull List<? extends Trigger> triggers, @NotNull Map<String, ? extends Object> uiMetadata, @NotNull DataSources dataSources, @Nullable String owner) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter((Object)schedule, (String)SCHEDULE_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)monitorType, (String)"monitorType");
        Intrinsics.checkNotNullParameter(inputs, (String)INPUTS_FIELD);
        Intrinsics.checkNotNullParameter(triggers, (String)TRIGGERS_FIELD);
        Intrinsics.checkNotNullParameter(uiMetadata, (String)"uiMetadata");
        Intrinsics.checkNotNullParameter((Object)dataSources, (String)"dataSources");
        this.id = id;
        this.version = version;
        this.name = name;
        this.enabled = enabled;
        this.schedule = schedule;
        this.lastUpdateTime = lastUpdateTime;
        this.enabledTime = enabledTime;
        this.monitorType = monitorType;
        this.user = user;
        this.schemaVersion = schemaVersion;
        this.inputs = inputs;
        this.triggers = triggers;
        this.uiMetadata = uiMetadata;
        this.dataSources = dataSources;
        this.owner = owner;
        this.type = MONITOR_TYPE;
        Set triggerIds = new LinkedHashSet();
        Iterable $this$forEach$iv = this.triggers;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            Trigger trigger = (Trigger)element$iv;
            boolean bl = false;
            if (!(!(trigger instanceof NoOpTrigger))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!triggerIds.add(trigger.getId())) {
                boolean $i$a$-require-Monitor$1$62 = false;
                String $i$a$-require-Monitor$1$62 = "Duplicate trigger id: " + trigger.getId() + ". Trigger ids must be unique.";
                throw new IllegalArgumentException($i$a$-require-Monitor$1$62.toString());
            }
            String string = this.monitorType;
            if (Intrinsics.areEqual((Object)string, (Object)MonitorType.QUERY_LEVEL_MONITOR.getValue())) {
                if (trigger instanceof QueryLevelTrigger) continue;
                boolean $i$a$-require-Monitor$1$72 = false;
                String $i$a$-require-Monitor$1$72 = "Incompatible trigger [" + trigger.getId() + "] for monitor type [" + this.monitorType + "]";
                throw new IllegalArgumentException($i$a$-require-Monitor$1$72.toString());
            }
            if (Intrinsics.areEqual((Object)string, (Object)MonitorType.BUCKET_LEVEL_MONITOR.getValue())) {
                if (trigger instanceof BucketLevelTrigger) continue;
                boolean $i$a$-require-Monitor$1$82 = false;
                String $i$a$-require-Monitor$1$82 = "Incompatible trigger [" + trigger.getId() + "] for monitor type [" + this.monitorType + "]";
                throw new IllegalArgumentException($i$a$-require-Monitor$1$82.toString());
            }
            if (Intrinsics.areEqual((Object)string, (Object)MonitorType.CLUSTER_METRICS_MONITOR.getValue())) {
                if (trigger instanceof QueryLevelTrigger) continue;
                boolean $i$a$-require-Monitor$1$92 = false;
                String $i$a$-require-Monitor$1$92 = "Incompatible trigger [" + trigger.getId() + "] for monitor type [" + this.monitorType + "]";
                throw new IllegalArgumentException($i$a$-require-Monitor$1$92.toString());
            }
            if (!Intrinsics.areEqual((Object)string, (Object)MonitorType.DOC_LEVEL_MONITOR.getValue()) || trigger instanceof DocumentLevelTrigger) continue;
            boolean bl2 = false;
            String string2 = "Incompatible trigger [" + trigger.getId() + "] for monitor type [" + this.monitorType + "]";
            throw new IllegalArgumentException(string2.toString());
        }
        if (this.getEnabled()) {
            if (this.getEnabledTime() == null) {
                String $i$f$forEach2 = "Required value was null.";
                throw new IllegalArgumentException($i$f$forEach2.toString());
            }
        } else if (!(this.getEnabledTime() == null)) {
            String $i$f$forEach2 = "Failed requirement.";
            throw new IllegalArgumentException($i$f$forEach2.toString());
        }
        if (!(this.inputs.size() <= 1)) {
            boolean $i$a$-require-Monitor$42 = false;
            String $i$a$-require-Monitor$42 = "Monitors can only have 1 search input.";
            throw new IllegalArgumentException($i$a$-require-Monitor$42.toString());
        }
        if (!(this.triggers.size() <= 10)) {
            boolean $i$a$-require-Monitor$52 = false;
            String $i$a$-require-Monitor$52 = "Monitors can only support up to 10 triggers.";
            throw new IllegalArgumentException($i$a$-require-Monitor$52.toString());
        }
        if (IndexUtilsKt.isBucketLevelMonitor(this)) {
            $this$forEach$iv = this.inputs;
            $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                Input input = (Input)element$iv;
                boolean bl = false;
                if (!(input instanceof SearchInput)) {
                    boolean $i$a$-require-Monitor$4$32 = false;
                    String $i$a$-require-Monitor$4$32 = "Unsupported input [" + input + "] for Monitor";
                    throw new IllegalArgumentException($i$a$-require-Monitor$4$32.toString());
                }
                if (((SearchInput)input).getQuery().aggregations() != null && !((SearchInput)input).getQuery().aggregations().getAggregatorFactories().isEmpty()) continue;
                boolean bl3 = false;
                String string = "At least one aggregation is required for the input [" + input + "]";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ Monitor(String string, long l, String string2, boolean bl, Schedule schedule, Instant instant, Instant instant2, String string3, User user, int n, List list, List list2, Map map, DataSources dataSources, String string4, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = NO_ID;
        }
        if ((n2 & 2) != 0) {
            l = 1L;
        }
        if ((n2 & 0x200) != 0) {
            n = 0;
        }
        if ((n2 & 0x2000) != 0) {
            dataSources = new DataSources(null, null, null, null, null, null, null, null, null, null, 1023, null);
        }
        if ((n2 & 0x4000) != 0) {
            string4 = "alerting";
        }
        this(string, l, string2, bl, schedule, instant, instant2, string3, user, n, list, list2, map, dataSources, string4);
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    @NotNull
    public Schedule getSchedule() {
        return this.schedule;
    }

    @Override
    @NotNull
    public Instant getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    @Nullable
    public Instant getEnabledTime() {
        return this.enabledTime;
    }

    @NotNull
    public final String getMonitorType() {
        return this.monitorType;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    public final int getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final List<Input> getInputs() {
        return this.inputs;
    }

    @NotNull
    public final List<Trigger> getTriggers() {
        return this.triggers;
    }

    @NotNull
    public final Map<String, Object> getUiMetadata() {
        return this.uiMetadata;
    }

    @NotNull
    public final DataSources getDataSources() {
        return this.dataSources;
    }

    @Nullable
    public final String getOwner() {
        return this.owner;
    }

    @Override
    @NotNull
    public String getType() {
        return this.type;
    }

    public Monitor(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sin.readString()");
        long l = sin.readLong();
        String string2 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sin.readString()");
        boolean bl = sin.readBoolean();
        Schedule schedule = Schedule.Companion.readFrom(sin);
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"sin.readInstant()");
        Instant instant2 = sin.readOptionalInstant();
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"sin.readString()");
        User user = sin.readBoolean() ? new User(sin) : null;
        int n = sin.readInt();
        List list = sin.readList(Input.Companion::readFrom);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"sin.readList((Input)::readFrom)");
        List list2 = sin.readList(Trigger.Companion::readFrom);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"sin.readList((Trigger)::readFrom)");
        this(string, l, string2, bl, schedule, instant, instant2, string3, user, n, list, list2, Companion.suppressWarning(sin.readMap()), sin.readBoolean() ? new DataSources(sin) : new DataSources(null, null, null, null, null, null, null, null, null, null, 1023, null), sin.readOptionalString());
    }

    @NotNull
    public final Map<String, Object> asTemplateArg() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"_id", (Object)this.getId()), TuplesKt.to((Object)"_version", (Object)this.getVersion()), TuplesKt.to((Object)NAME_FIELD, (Object)this.getName()), TuplesKt.to((Object)ENABLED_FIELD, (Object)this.getEnabled())};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final XContentBuilder toXContentWithUser(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, false);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.createXContentBuilder(builder, params, true);
    }

    private final XContentBuilder createXContentBuilder(XContentBuilder builder, ToXContent.Params params, boolean secure) {
        builder.startObject();
        if (params.paramAsBoolean("with_type", false)) {
            builder.startObject(this.getType());
        }
        builder.field(TYPE_FIELD, this.getType()).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(NAME_FIELD, this.getName()).field(MONITOR_TYPE_FIELD, this.monitorType);
        if (!secure) {
            IndexUtilsKt.optionalUserField(builder, USER_FIELD, this.user);
        }
        XContentBuilder xContentBuilder = builder.field(ENABLED_FIELD, this.getEnabled());
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"builder.field(ENABLED_FIELD, enabled)");
        Collection $this$toTypedArray$iv = this.inputs;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        XContentBuilder xContentBuilder2 = IndexUtilsKt.optionalTimeField(xContentBuilder, ENABLED_TIME_FIELD, this.getEnabledTime()).field(SCHEDULE_FIELD, (ToXContent)this.getSchedule()).field(INPUTS_FIELD, (Object)thisCollection$iv.toArray(new Input[0]));
        $this$toTypedArray$iv = this.triggers;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        XContentBuilder xContentBuilder3 = xContentBuilder2.field(TRIGGERS_FIELD, (Object)thisCollection$iv.toArray(new Trigger[0]));
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder3, (String)"builder.field(ENABLED_FI\u2026 triggers.toTypedArray())");
        IndexUtilsKt.optionalTimeField(xContentBuilder3, LAST_UPDATE_TIME_FIELD, this.getLastUpdateTime());
        if (!this.uiMetadata.isEmpty()) {
            builder.field(UI_METADATA_FIELD, this.uiMetadata);
        }
        builder.field(DATA_SOURCES_FIELD, (ToXContent)this.dataSources);
        builder.field(OWNER_FIELD, this.owner);
        if (params.paramAsBoolean("with_type", false)) {
            builder.endObject();
        }
        XContentBuilder xContentBuilder4 = builder.endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder4, (String)"builder.endObject()");
        return xContentBuilder4;
    }

    @Override
    @NotNull
    public Monitor fromDocument(@NotNull String id, long version) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return Monitor.copy$default(this, id, version, null, false, null, null, null, null, null, 0, null, null, null, null, null, 32764, null);
    }

    public void writeTo(@NotNull StreamOutput out) throws IOException {
        BaseModel it;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeString(this.getId());
        out.writeLong(this.getVersion());
        out.writeString(this.getName());
        out.writeBoolean(this.getEnabled());
        if (this.getSchedule() instanceof CronSchedule) {
            out.writeEnum((Enum)Schedule.TYPE.CRON);
        } else {
            out.writeEnum((Enum)Schedule.TYPE.INTERVAL);
        }
        this.getSchedule().writeTo(out);
        out.writeInstant(this.getLastUpdateTime());
        out.writeOptionalInstant(this.getEnabledTime());
        out.writeString(this.monitorType);
        out.writeBoolean(this.user != null);
        User user = this.user;
        if (user != null) {
            user.writeTo(out);
        }
        out.writeInt(this.schemaVersion);
        out.writeVInt(this.inputs.size());
        Iterable $this$forEach$iv = this.inputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Input)element$iv;
            boolean bl = false;
            if (it instanceof SearchInput) {
                out.writeEnum((Enum)Input.Type.SEARCH_INPUT);
            } else if (it instanceof DocLevelMonitorInput) {
                out.writeEnum((Enum)Input.Type.DOCUMENT_LEVEL_INPUT);
            } else {
                out.writeEnum((Enum)Input.Type.REMOTE_DOC_LEVEL_MONITOR_INPUT);
            }
            it.writeTo(out);
        }
        out.writeVInt(this.triggers.size());
        $this$forEach$iv = this.triggers;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Trigger)element$iv;
            boolean bl = false;
            BaseModel baseModel = it;
            if (baseModel instanceof BucketLevelTrigger) {
                out.writeEnum((Enum)Trigger.Type.BUCKET_LEVEL_TRIGGER);
            } else if (baseModel instanceof DocumentLevelTrigger) {
                out.writeEnum((Enum)Trigger.Type.DOCUMENT_LEVEL_TRIGGER);
            } else if (baseModel instanceof RemoteMonitorTrigger) {
                out.writeEnum((Enum)Trigger.Type.REMOTE_MONITOR_TRIGGER);
            } else {
                out.writeEnum((Enum)Trigger.Type.QUERY_LEVEL_TRIGGER);
            }
            it.writeTo(out);
        }
        out.writeMap(this.uiMetadata);
        out.writeBoolean(this.dataSources != null);
        this.dataSources.writeTo(out);
        out.writeOptionalString(this.owner);
    }

    @Override
    @NotNull
    public XContentBuilder toXContentWithType(@NotNull XContentBuilder builder) {
        return ScheduledJob.DefaultImpls.toXContentWithType(this, builder);
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.version;
    }

    @NotNull
    public final String component3() {
        return this.name;
    }

    public final boolean component4() {
        return this.enabled;
    }

    @NotNull
    public final Schedule component5() {
        return this.schedule;
    }

    @NotNull
    public final Instant component6() {
        return this.lastUpdateTime;
    }

    @Nullable
    public final Instant component7() {
        return this.enabledTime;
    }

    @NotNull
    public final String component8() {
        return this.monitorType;
    }

    @Nullable
    public final User component9() {
        return this.user;
    }

    public final int component10() {
        return this.schemaVersion;
    }

    @NotNull
    public final List<Input> component11() {
        return this.inputs;
    }

    @NotNull
    public final List<Trigger> component12() {
        return this.triggers;
    }

    @NotNull
    public final Map<String, Object> component13() {
        return this.uiMetadata;
    }

    @NotNull
    public final DataSources component14() {
        return this.dataSources;
    }

    @Nullable
    public final String component15() {
        return this.owner;
    }

    @NotNull
    public final Monitor copy(@NotNull String id, long version, @NotNull String name, boolean enabled, @NotNull Schedule schedule, @NotNull Instant lastUpdateTime, @Nullable Instant enabledTime, @NotNull String monitorType, @Nullable User user, int schemaVersion, @NotNull List<? extends Input> inputs, @NotNull List<? extends Trigger> triggers, @NotNull Map<String, ? extends Object> uiMetadata, @NotNull DataSources dataSources, @Nullable String owner) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)name, (String)NAME_FIELD);
        Intrinsics.checkNotNullParameter((Object)schedule, (String)SCHEDULE_FIELD);
        Intrinsics.checkNotNullParameter((Object)lastUpdateTime, (String)"lastUpdateTime");
        Intrinsics.checkNotNullParameter((Object)monitorType, (String)"monitorType");
        Intrinsics.checkNotNullParameter(inputs, (String)INPUTS_FIELD);
        Intrinsics.checkNotNullParameter(triggers, (String)TRIGGERS_FIELD);
        Intrinsics.checkNotNullParameter(uiMetadata, (String)"uiMetadata");
        Intrinsics.checkNotNullParameter((Object)dataSources, (String)"dataSources");
        return new Monitor(id, version, name, enabled, schedule, lastUpdateTime, enabledTime, monitorType, user, schemaVersion, inputs, triggers, uiMetadata, dataSources, owner);
    }

    public static /* synthetic */ Monitor copy$default(Monitor monitor, String string, long l, String string2, boolean bl, Schedule schedule, Instant instant, Instant instant2, String string3, User user, int n, List list, List list2, Map map, DataSources dataSources, String string4, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = monitor.id;
        }
        if ((n2 & 2) != 0) {
            l = monitor.version;
        }
        if ((n2 & 4) != 0) {
            string2 = monitor.name;
        }
        if ((n2 & 8) != 0) {
            bl = monitor.enabled;
        }
        if ((n2 & 0x10) != 0) {
            schedule = monitor.schedule;
        }
        if ((n2 & 0x20) != 0) {
            instant = monitor.lastUpdateTime;
        }
        if ((n2 & 0x40) != 0) {
            instant2 = monitor.enabledTime;
        }
        if ((n2 & 0x80) != 0) {
            string3 = monitor.monitorType;
        }
        if ((n2 & 0x100) != 0) {
            user = monitor.user;
        }
        if ((n2 & 0x200) != 0) {
            n = monitor.schemaVersion;
        }
        if ((n2 & 0x400) != 0) {
            list = monitor.inputs;
        }
        if ((n2 & 0x800) != 0) {
            list2 = monitor.triggers;
        }
        if ((n2 & 0x1000) != 0) {
            map = monitor.uiMetadata;
        }
        if ((n2 & 0x2000) != 0) {
            dataSources = monitor.dataSources;
        }
        if ((n2 & 0x4000) != 0) {
            string4 = monitor.owner;
        }
        return monitor.copy(string, l, string2, bl, schedule, instant, instant2, string3, user, n, list, list2, map, dataSources, string4);
    }

    @NotNull
    public String toString() {
        return "Monitor(id=" + this.id + ", version=" + this.version + ", name=" + this.name + ", enabled=" + this.enabled + ", schedule=" + this.schedule + ", lastUpdateTime=" + this.lastUpdateTime + ", enabledTime=" + this.enabledTime + ", monitorType=" + this.monitorType + ", user=" + this.user + ", schemaVersion=" + this.schemaVersion + ", inputs=" + this.inputs + ", triggers=" + this.triggers + ", uiMetadata=" + this.uiMetadata + ", dataSources=" + this.dataSources + ", owner=" + this.owner + ")";
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = result * 31 + Long.hashCode(this.version);
        result = result * 31 + this.name.hashCode();
        int n = this.enabled ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result = result * 31 + n;
        result = result * 31 + this.schedule.hashCode();
        result = result * 31 + this.lastUpdateTime.hashCode();
        result = result * 31 + (this.enabledTime == null ? 0 : this.enabledTime.hashCode());
        result = result * 31 + this.monitorType.hashCode();
        result = result * 31 + (this.user == null ? 0 : this.user.hashCode());
        result = result * 31 + Integer.hashCode(this.schemaVersion);
        result = result * 31 + ((Object)this.inputs).hashCode();
        result = result * 31 + ((Object)this.triggers).hashCode();
        result = result * 31 + ((Object)this.uiMetadata).hashCode();
        result = result * 31 + this.dataSources.hashCode();
        result = result * 31 + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Monitor)) {
            return false;
        }
        Monitor monitor = (Monitor)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)monitor.id)) {
            return false;
        }
        if (this.version != monitor.version) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)monitor.name)) {
            return false;
        }
        if (this.enabled != monitor.enabled) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.schedule, (Object)monitor.schedule)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdateTime, (Object)monitor.lastUpdateTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.enabledTime, (Object)monitor.enabledTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.monitorType, (Object)monitor.monitorType)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.user, (Object)monitor.user)) {
            return false;
        }
        if (this.schemaVersion != monitor.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inputs, monitor.inputs)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.triggers, monitor.triggers)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.uiMetadata, monitor.uiMetadata)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.dataSources, (Object)monitor.dataSources)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.owner, (Object)monitor.owner);
    }

    private static final Monitor XCONTENT_REGISTRY$lambda$13(XContentParser it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return org.opensearch.commons.alerting.model.Monitor$Companion.parse$default(Companion, it, null, 0L, 6, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Monitor parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
        return Companion.parse(xcp, id, version);
    }

    @JvmStatic
    @Nullable
    public static final Monitor readFrom(@NotNull StreamInput sin) throws IOException {
        return Companion.readFrom(sin);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Monitor parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Monitor parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010#\u001a\u00020\u00042\b\b\u0002\u0010$\u001a\u00020\u0013H\u0007J\u0012\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010&\u001a\u00020'H\u0007J,\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010)2\u0018\u0010*\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lorg/opensearch/commons/alerting/model/Monitor$Companion;", "", "()V", "DATA_SOURCES_FIELD", "", "ENABLED_FIELD", "ENABLED_TIME_FIELD", "INPUTS_FIELD", "LAST_UPDATE_TIME_FIELD", "MONITOR_TYPE", "MONITOR_TYPE_FIELD", "MONITOR_TYPE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getMONITOR_TYPE_PATTERN", "()Ljava/util/regex/Pattern;", "NAME_FIELD", "NO_ID", "NO_VERSION", "", "OWNER_FIELD", "SCHEDULE_FIELD", "SCHEMA_VERSION_FIELD", "TRIGGERS_FIELD", "TYPE_FIELD", "UI_METADATA_FIELD", "USER_FIELD", "XCONTENT_REGISTRY", "Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "getXCONTENT_REGISTRY", "()Lorg/opensearch/core/xcontent/NamedXContentRegistry$Entry;", "parse", "Lorg/opensearch/commons/alerting/model/Monitor;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "version", "readFrom", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "suppressWarning", "", "map", "common-utils"})
    @SourceDebugExtension(value={"SMAP\nMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Monitor.kt\norg/opensearch/commons/alerting/model/Monitor$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,357:1\n1#2:358\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final Pattern getMONITOR_TYPE_PATTERN() {
            return MONITOR_TYPE_PATTERN;
        }

        @NotNull
        public final NamedXContentRegistry.Entry getXCONTENT_REGISTRY() {
            return XCONTENT_REGISTRY;
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Monitor parse(@NotNull XContentParser xcp, @NotNull String id, long version) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            String name = null;
            String monitorType = MonitorType.QUERY_LEVEL_MONITOR.toString();
            User user = null;
            Schedule schedule = null;
            Instant lastUpdateTime = null;
            Instant enabledTime = null;
            Map uiMetadata = MapsKt.emptyMap();
            boolean enabled = true;
            int schemaVersion = 0;
            List triggers = new ArrayList();
            List inputs = new ArrayList();
            DataSources dataSources = new DataSources(null, null, null, null, null, null, null, null, null, null, 1023, null);
            String owner = "alerting";
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            block30: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                block56: {
                    String fieldName = xcp.currentName();
                    xcp.nextToken();
                    String string = fieldName;
                    if (string == null) break block56;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1219796725: {
                            if (string.equals(Monitor.ENABLED_TIME_FIELD)) {
                                n = 1;
                            }
                            break;
                        }
                        case 106164915: {
                            if (string.equals(Monitor.OWNER_FIELD)) {
                                n = 2;
                            }
                            break;
                        }
                        case -1183866391: {
                            if (string.equals(Monitor.INPUTS_FIELD)) {
                                n = 3;
                            }
                            break;
                        }
                        case 1503093179: {
                            if (string.equals(Monitor.TRIGGERS_FIELD)) {
                                n = 4;
                            }
                            break;
                        }
                        case 691520634: {
                            if (string.equals(Monitor.UI_METADATA_FIELD)) {
                                n = 5;
                            }
                            break;
                        }
                        case -1609594047: {
                            if (string.equals(Monitor.ENABLED_FIELD)) {
                                n = 6;
                            }
                            break;
                        }
                        case 1598941219: {
                            if (string.equals(Monitor.DATA_SOURCES_FIELD)) {
                                n = 7;
                            }
                            break;
                        }
                        case 1684719674: {
                            if (string.equals(Monitor.SCHEMA_VERSION_FIELD)) {
                                n = 8;
                            }
                            break;
                        }
                        case -697920873: {
                            if (string.equals(Monitor.SCHEDULE_FIELD)) {
                                n = 9;
                            }
                            break;
                        }
                        case 2020321370: {
                            if (string.equals(Monitor.LAST_UPDATE_TIME_FIELD)) {
                                n = 10;
                            }
                            break;
                        }
                        case 3373707: {
                            if (string.equals(Monitor.NAME_FIELD)) {
                                n = 11;
                            }
                            break;
                        }
                        case 1732432639: {
                            if (string.equals(Monitor.MONITOR_TYPE_FIELD)) {
                                n = 12;
                            }
                            break;
                        }
                        case 3599307: {
                            if (string.equals(Monitor.USER_FIELD)) {
                                n = 13;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 8: {
                            schemaVersion = xcp.intValue();
                            continue block30;
                        }
                        case 11: {
                            name = xcp.text();
                            continue block30;
                        }
                        case 12: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.text(), (String)"xcp.text()");
                            Matcher matcher = this.getMONITOR_TYPE_PATTERN().matcher(monitorType);
                            boolean find = matcher.matches();
                            if (find) continue block30;
                            throw new IllegalStateException("Monitor type should follow pattern " + this.getMONITOR_TYPE_PATTERN().pattern());
                        }
                        case 13: {
                            user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse(xcp);
                            continue block30;
                        }
                        case 6: {
                            enabled = xcp.booleanValue();
                            continue block30;
                        }
                        case 9: {
                            schedule = Schedule.Companion.parse(xcp);
                            continue block30;
                        }
                        case 3: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                Input input = Input.Companion.parse(xcp);
                                if (input instanceof ClusterMetricsInput) {
                                    SupportedClusterMetricsSettings supportedClusterMetricsSettings = IndexUtils.Companion.getSupportedClusterMetricsSettings();
                                    if (supportedClusterMetricsSettings != null) {
                                        supportedClusterMetricsSettings.validateApiType((ClusterMetricsInput)input);
                                    }
                                }
                                inputs.add(input);
                            }
                            continue block30;
                        }
                        case 4: {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                            while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                                triggers.add(Trigger.Companion.parse(xcp));
                            }
                            continue block30;
                        }
                        case 1: {
                            enabledTime = IndexUtilsKt.instant(xcp);
                            continue block30;
                        }
                        case 10: {
                            lastUpdateTime = IndexUtilsKt.instant(xcp);
                            continue block30;
                        }
                        case 5: {
                            Intrinsics.checkNotNullExpressionValue((Object)xcp.map(), (String)"xcp.map()");
                            continue block30;
                        }
                        case 7: {
                            dataSources = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? new DataSources(null, null, null, null, null, null, null, null, null, null, 1023, null) : DataSources.Companion.parse(xcp);
                            continue block30;
                        }
                        case 2: {
                            String string2;
                            if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) {
                                string2 = owner;
                            } else {
                                String string3 = xcp.text();
                                string2 = string3;
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"xcp.text()");
                            }
                            owner = string2;
                            continue block30;
                        }
                    }
                }
                xcp.skipChildren();
            }
            if (enabled && enabledTime == null) {
                enabledTime = Instant.now();
            } else if (!enabled) {
                enabledTime = null;
            }
            String string = id;
            long l = version;
            String string4 = name;
            if (string4 == null) {
                long l2 = l;
                String string5 = string;
                boolean $i$a$-requireNotNull-Monitor$Companion$parse$32 = false;
                String string6 = "Monitor name is null";
                String string7 = string5;
                long l3 = l2;
                String $i$a$-requireNotNull-Monitor$Companion$parse$32 = string6;
                throw new IllegalArgumentException($i$a$-requireNotNull-Monitor$Companion$parse$32.toString());
            }
            boolean bl = enabled;
            Schedule schedule2 = schedule;
            if (schedule2 == null) {
                boolean bl2 = bl;
                String string8 = string4;
                long l4 = l;
                String string9 = string;
                boolean bl3 = false;
                String string10 = "Monitor schedule is null";
                String string11 = string9;
                long l5 = l4;
                String string12 = string8;
                boolean bl4 = bl2;
                String string13 = string10;
                throw new IllegalArgumentException(string13.toString());
            }
            Instant instant = lastUpdateTime;
            if (instant == null) {
                instant = Instant.now();
            }
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"lastUpdateTime ?: Instant.now()");
            String string14 = owner;
            DataSources dataSources2 = dataSources;
            Map map = uiMetadata;
            List list = CollectionsKt.toList((Iterable)triggers);
            List list2 = CollectionsKt.toList((Iterable)inputs);
            int n = schemaVersion;
            User user2 = user;
            String string15 = monitorType;
            Instant instant2 = enabledTime;
            Instant instant3 = instant;
            Schedule schedule3 = schedule2;
            boolean bl5 = bl;
            String string16 = string4;
            long l6 = l;
            String string17 = string;
            return new Monitor(string17, l6, string16, bl5, schedule3, instant3, instant2, string15, user2, n, list2, list, map, dataSources2, string14);
        }

        public static /* synthetic */ Monitor parse$default(Companion companion, XContentParser xContentParser, String string, long l, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = Monitor.NO_ID;
            }
            if ((n & 4) != 0) {
                l = 1L;
            }
            return companion.parse(xContentParser, string, l);
        }

        @JvmStatic
        @Nullable
        public final Monitor readFrom(@NotNull StreamInput sin) throws IOException {
            Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
            return new Monitor(sin);
        }

        @NotNull
        public final Map<String, Object> suppressWarning(@Nullable Map<String, Object> map) {
            Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.String, kotlin.Any>");
            return TypeIntrinsics.asMutableMap(map);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Monitor parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.commons.alerting.model.Monitor$Companion.parse$default(this, xcp, id, 0L, 4, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Monitor parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.commons.alerting.model.Monitor$Companion.parse$default(this, xcp, null, 0L, 6, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lorg/opensearch/commons/alerting/model/Monitor$MonitorType;", "", "value", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "toString", "QUERY_LEVEL_MONITOR", "BUCKET_LEVEL_MONITOR", "CLUSTER_METRICS_MONITOR", "DOC_LEVEL_MONITOR", "common-utils"})
    public static final class MonitorType
    extends Enum<MonitorType> {
        @NotNull
        private final String value;
        public static final /* enum */ MonitorType QUERY_LEVEL_MONITOR = new MonitorType("query_level_monitor");
        public static final /* enum */ MonitorType BUCKET_LEVEL_MONITOR = new MonitorType("bucket_level_monitor");
        public static final /* enum */ MonitorType CLUSTER_METRICS_MONITOR = new MonitorType("cluster_metrics_monitor");
        public static final /* enum */ MonitorType DOC_LEVEL_MONITOR = new MonitorType("doc_level_monitor");
        private static final /* synthetic */ MonitorType[] $VALUES;

        private MonitorType(String value) {
            this.value = value;
        }

        @NotNull
        public final String getValue() {
            return this.value;
        }

        @NotNull
        public String toString() {
            return this.value;
        }

        public static MonitorType[] values() {
            return (MonitorType[])$VALUES.clone();
        }

        public static MonitorType valueOf(String value) {
            return Enum.valueOf(MonitorType.class, value);
        }

        static {
            $VALUES = monitorTypeArray = new MonitorType[]{MonitorType.QUERY_LEVEL_MONITOR, MonitorType.BUCKET_LEVEL_MONITOR, MonitorType.CLUSTER_METRICS_MONITOR, MonitorType.DOC_LEVEL_MONITOR};
        }
    }
}

