/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.common;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.flowframework.exception.FlowFrameworkException;

public enum WorkflowResources {
    CREATE_CONNECTOR("create_connector", "connector_id", "delete_connector"),
    REGISTER_REMOTE_MODEL("register_remote_model", "model_id", "delete_model"),
    REGISTER_LOCAL_MODEL("register_local_custom_model", "model_id", "delete_model"),
    REGISTER_LOCAL_SPARSE_ENCODING_MODEL("register_local_sparse_encoding_model", "model_id", "delete_model"),
    REGISTER_LOCAL_PRETRAINED_MODEL("register_local_pretrained_model", "model_id", "delete_model"),
    REGISTER_MODEL_GROUP("register_model_group", "model_group_id", "noop"),
    DEPLOY_MODEL("deploy_model", "model_id", "undeploy_model"),
    CREATE_INGEST_PIPELINE("create_ingest_pipeline", "pipeline_id", "delete_ingest_pipeline"),
    CREATE_SEARCH_PIPELINE("create_search_pipeline", "pipeline_id", "delete_search_pipeline"),
    CREATE_INDEX("create_index", "index_name", "delete_index"),
    REINDEX("reindex", "index_name", "noop"),
    REGISTER_AGENT("register_agent", "agent_id", "delete_agent");

    public static final String CONNECTOR_ID = "connector_id";
    public static final String MODEL_ID = "model_id";
    public static final String MODEL_GROUP_ID = "model_group_id";
    public static final String PIPELINE_ID = "pipeline_id";
    public static final String INDEX_NAME = "index_name";
    public static final String AGENT_ID = "agent_id";
    private final String workflowStep;
    private final String resourceCreated;
    private final String deprovisionStep;
    private static final Logger logger;
    private static final Set<String> allResources;

    private WorkflowResources(String workflowStep, String resourceCreated, String deprovisionStep) {
        this.workflowStep = workflowStep;
        this.resourceCreated = resourceCreated;
        this.deprovisionStep = deprovisionStep;
    }

    public String getWorkflowStep() {
        return this.workflowStep;
    }

    public String getResourceCreated() {
        return this.resourceCreated;
    }

    public String getDeprovisionStep() {
        return this.deprovisionStep;
    }

    public static String getResourceByWorkflowStep(String workflowStep) throws FlowFrameworkException {
        if (workflowStep != null && !workflowStep.isEmpty()) {
            for (WorkflowResources mapping : WorkflowResources.values()) {
                if (!workflowStep.equals(mapping.getWorkflowStep()) && !workflowStep.equals(mapping.getDeprovisionStep())) continue;
                return mapping.getResourceCreated();
            }
        }
        logger.error("Unable to find resource type for step: {}", (Object)workflowStep);
        throw new FlowFrameworkException("Unable to find resource type for step: " + workflowStep, RestStatus.BAD_REQUEST);
    }

    public static String getDeprovisionStepByWorkflowStep(String workflowStep) throws FlowFrameworkException {
        if (workflowStep != null && !workflowStep.isEmpty()) {
            for (WorkflowResources mapping : WorkflowResources.values()) {
                if (!mapping.getWorkflowStep().equals(workflowStep)) continue;
                return mapping.getDeprovisionStep();
            }
        }
        logger.error("Unable to find deprovision step for step: {}", (Object)workflowStep);
        throw new FlowFrameworkException("Unable to find deprovision step for step: " + workflowStep, RestStatus.BAD_REQUEST);
    }

    public static Set<String> getAllResourcesCreated() {
        return allResources;
    }

    static {
        logger = LogManager.getLogger(WorkflowResources.class);
        allResources = Stream.of(WorkflowResources.values()).map(WorkflowResources::getResourceCreated).collect(Collectors.toSet());
    }
}

