/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.model;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.ml.common.model.Guardrail;
import org.opensearch.ml.common.model.LocalRegexGuardrail;
import org.opensearch.ml.common.model.ModelGuardrail;

public class Guardrails
implements ToXContentObject {
    public static final String TYPE_FIELD = "type";
    public static final String INPUT_GUARDRAIL_FIELD = "input_guardrail";
    public static final String OUTPUT_GUARDRAIL_FIELD = "output_guardrail";
    public static final Set<String> types = Set.of("local_regex", "model");
    private String type;
    private Guardrail inputGuardrail;
    private Guardrail outputGuardrail;

    public Guardrails(String type, Guardrail inputGuardrail, Guardrail outputGuardrail) {
        this.type = type;
        this.inputGuardrail = inputGuardrail;
        this.outputGuardrail = outputGuardrail;
    }

    public Guardrails(StreamInput input) throws IOException {
        this.type = input.readString();
        if (input.readBoolean()) {
            switch (this.type) {
                case "local_regex": {
                    this.inputGuardrail = new LocalRegexGuardrail(input);
                    break;
                }
                case "model": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported guardrails type: %s", this.type));
                }
            }
        }
        if (input.readBoolean()) {
            switch (this.type) {
                case "local_regex": {
                    this.outputGuardrail = new LocalRegexGuardrail(input);
                    break;
                }
                case "model": {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Unsupported guardrails type: %s", this.type));
                }
            }
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.type);
        if (this.inputGuardrail != null) {
            out.writeBoolean(true);
            this.inputGuardrail.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (this.outputGuardrail != null) {
            out.writeBoolean(true);
            this.outputGuardrail.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.type != null) {
            builder.field(TYPE_FIELD, this.type);
        }
        if (this.inputGuardrail != null) {
            builder.field(INPUT_GUARDRAIL_FIELD, (ToXContent)this.inputGuardrail);
        }
        if (this.outputGuardrail != null) {
            builder.field(OUTPUT_GUARDRAIL_FIELD, (ToXContent)this.outputGuardrail);
        }
        builder.endObject();
        return builder;
    }

    public static Guardrails parse(XContentParser parser) throws IOException {
        String type = null;
        Map inputGuardrailMap = null;
        Map outputGuardrailMap = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        block10: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "type": {
                    type = parser.text();
                    continue block10;
                }
                case "input_guardrail": {
                    inputGuardrailMap = parser.map();
                    continue block10;
                }
                case "output_guardrail": {
                    outputGuardrailMap = parser.map();
                    continue block10;
                }
            }
            parser.skipChildren();
        }
        if (!Guardrails.validateType(type).booleanValue()) {
            throw new IllegalArgumentException("The type of guardrails is required, can not be null.");
        }
        return Guardrails.builder().type(type).inputGuardrail(Guardrails.createGuardrail(type, inputGuardrailMap)).outputGuardrail(Guardrails.createGuardrail(type, outputGuardrailMap)).build();
    }

    private static Boolean validateType(String type) {
        if (types.contains(type)) {
            return true;
        }
        return false;
    }

    private static Guardrail createGuardrail(String type, Map<String, Object> params) {
        if (params == null || params.isEmpty()) {
            return null;
        }
        switch (type) {
            case "local_regex": {
                return new LocalRegexGuardrail(params);
            }
            case "model": {
                return new ModelGuardrail(params);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported guardrails type: %s", type));
    }

    @Generated
    public static GuardrailsBuilder builder() {
        return new GuardrailsBuilder();
    }

    @Generated
    public GuardrailsBuilder toBuilder() {
        return new GuardrailsBuilder().type(this.type).inputGuardrail(this.inputGuardrail).outputGuardrail(this.outputGuardrail);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Guardrails)) {
            return false;
        }
        Guardrails other = (Guardrails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Guardrail this$inputGuardrail = this.getInputGuardrail();
        Guardrail other$inputGuardrail = other.getInputGuardrail();
        if (this$inputGuardrail == null ? other$inputGuardrail != null : !this$inputGuardrail.equals(other$inputGuardrail)) {
            return false;
        }
        Guardrail this$outputGuardrail = this.getOutputGuardrail();
        Guardrail other$outputGuardrail = other.getOutputGuardrail();
        return !(this$outputGuardrail == null ? other$outputGuardrail != null : !this$outputGuardrail.equals(other$outputGuardrail));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Guardrails;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Guardrail $inputGuardrail = this.getInputGuardrail();
        result = result * 59 + ($inputGuardrail == null ? 43 : $inputGuardrail.hashCode());
        Guardrail $outputGuardrail = this.getOutputGuardrail();
        result = result * 59 + ($outputGuardrail == null ? 43 : $outputGuardrail.hashCode());
        return result;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Guardrail getInputGuardrail() {
        return this.inputGuardrail;
    }

    @Generated
    public Guardrail getOutputGuardrail() {
        return this.outputGuardrail;
    }

    @Generated
    public static class GuardrailsBuilder {
        @Generated
        private String type;
        @Generated
        private Guardrail inputGuardrail;
        @Generated
        private Guardrail outputGuardrail;

        @Generated
        GuardrailsBuilder() {
        }

        @Generated
        public GuardrailsBuilder type(String type) {
            this.type = type;
            return this;
        }

        @Generated
        public GuardrailsBuilder inputGuardrail(Guardrail inputGuardrail) {
            this.inputGuardrail = inputGuardrail;
            return this;
        }

        @Generated
        public GuardrailsBuilder outputGuardrail(Guardrail outputGuardrail) {
            this.outputGuardrail = outputGuardrail;
            return this;
        }

        @Generated
        public Guardrails build() {
            return new Guardrails(this.type, this.inputGuardrail, this.outputGuardrail);
        }

        @Generated
        public String toString() {
            return "Guardrails.GuardrailsBuilder(type=" + this.type + ", inputGuardrail=" + String.valueOf(this.inputGuardrail) + ", outputGuardrail=" + String.valueOf(this.outputGuardrail) + ")";
        }
    }
}

