/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.search.comparators;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.sandbox.document.HalfFloatPoint;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.NumericComparator;

public class HalfFloatComparator
extends NumericComparator<Float> {
    private final float[] values;
    protected float topValue;
    protected float bottom;

    public HalfFloatComparator(int numHits, String field, Float missingValue, boolean reverse, Pruning pruning) {
        super(field, (Number)Float.valueOf(missingValue != null ? missingValue.floatValue() : 0.0f), reverse, pruning, 2);
        this.values = new float[numHits];
    }

    public int compare(int slot1, int slot2) {
        return Float.compare(this.values[slot1], this.values[slot2]);
    }

    public void setTopValue(Float value) {
        super.setTopValue((Number)value);
        this.topValue = value.floatValue();
    }

    public Float value(int slot) {
        return Float.valueOf(this.values[slot]);
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new HalfFloatLeafComparator(context);
    }

    public class HalfFloatLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public HalfFloatLeafComparator(LeafReaderContext context) throws IOException {
            super((NumericComparator)HalfFloatComparator.this, context);
        }

        private float getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return Float.intBitsToFloat((int)this.docValues.longValue());
            }
            return ((Float)HalfFloatComparator.this.missingValue).floatValue();
        }

        public void setBottom(int slot) throws IOException {
            HalfFloatComparator.this.bottom = HalfFloatComparator.this.values[slot];
            super.setBottom(slot);
        }

        public int compareBottom(int doc) throws IOException {
            return Float.compare(HalfFloatComparator.this.bottom, this.getValueForDoc(doc));
        }

        public int compareTop(int doc) throws IOException {
            return Float.compare(HalfFloatComparator.this.topValue, this.getValueForDoc(doc));
        }

        public void copy(int slot, int doc) throws IOException {
            HalfFloatComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        protected int compareMissingValueWithBottomValue() {
            return Float.compare(((Float)HalfFloatComparator.this.missingValue).floatValue(), HalfFloatComparator.this.bottom);
        }

        protected int compareMissingValueWithTopValue() {
            return Float.compare(((Float)HalfFloatComparator.this.missingValue).floatValue(), HalfFloatComparator.this.topValue);
        }

        protected void encodeBottom(byte[] packedValue) {
            HalfFloatPoint.encodeDimension((float)HalfFloatComparator.this.bottom, (byte[])packedValue, (int)0);
        }

        protected void encodeTop(byte[] packedValue) {
            HalfFloatPoint.encodeDimension((float)HalfFloatComparator.this.topValue, (byte[])packedValue, (int)0);
        }
    }
}

