/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.gateway.remote;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.util.Strings;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.routing.remote.RemoteRoutingTableService;
import org.opensearch.cluster.service.ClusterApplierService;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.blobstore.BlobMetadata;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.concurrent.AbstractAsyncTask;
import org.opensearch.core.action.ActionListener;
import org.opensearch.gateway.remote.ClusterMetadataManifest;
import org.opensearch.gateway.remote.RemoteClusterStateService;
import org.opensearch.gateway.remote.RemoteClusterStateUtils;
import org.opensearch.gateway.remote.RemoteManifestManager;
import org.opensearch.gateway.remote.RemotePersistenceStats;
import org.opensearch.gateway.remote.model.RemoteGlobalMetadata;
import org.opensearch.index.translog.transfer.BlobStoreTransferService;
import org.opensearch.threadpool.ThreadPool;

public class RemoteClusterStateCleanupManager
implements Closeable {
    public static final int RETAINED_MANIFESTS = 10;
    public static final int SKIP_CLEANUP_STATE_CHANGES = 10;
    public static final TimeValue CLUSTER_STATE_CLEANUP_INTERVAL_DEFAULT = TimeValue.timeValueMinutes((long)5L);
    public static final TimeValue CLUSTER_STATE_CLEANUP_INTERVAL_MINIMUM = TimeValue.MINUS_ONE;
    public static final Setting<TimeValue> REMOTE_CLUSTER_STATE_CLEANUP_INTERVAL_SETTING = Setting.timeSetting("cluster.remote_store.state.cleanup_interval", CLUSTER_STATE_CLEANUP_INTERVAL_DEFAULT, CLUSTER_STATE_CLEANUP_INTERVAL_MINIMUM, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private static final Logger logger = LogManager.getLogger(RemoteClusterStateCleanupManager.class);
    private final RemoteClusterStateService remoteClusterStateService;
    private final RemotePersistenceStats remoteStateStats;
    private BlobStoreTransferService blobStoreTransferService;
    private TimeValue staleFileCleanupInterval;
    private final AtomicBoolean deleteStaleMetadataRunning = new AtomicBoolean(false);
    private volatile AsyncStaleFileDeletion staleFileDeletionTask;
    private long lastCleanupAttemptStateVersion;
    private final ThreadPool threadpool;
    private final ClusterApplierService clusterApplierService;
    private RemoteManifestManager remoteManifestManager;
    private final RemoteRoutingTableService remoteRoutingTableService;

    public RemoteClusterStateCleanupManager(RemoteClusterStateService remoteClusterStateService, ClusterService clusterService, RemoteRoutingTableService remoteRoutingTableService) {
        this.remoteClusterStateService = remoteClusterStateService;
        this.remoteStateStats = remoteClusterStateService.getStats();
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        this.clusterApplierService = clusterService.getClusterApplierService();
        this.staleFileCleanupInterval = clusterSettings.get(REMOTE_CLUSTER_STATE_CLEANUP_INTERVAL_SETTING);
        this.threadpool = remoteClusterStateService.getThreadpool();
        this.lastCleanupAttemptStateVersion = 0L;
        clusterSettings.addSettingsUpdateConsumer(REMOTE_CLUSTER_STATE_CLEANUP_INTERVAL_SETTING, this::updateCleanupInterval);
        this.remoteRoutingTableService = remoteRoutingTableService;
    }

    void start() {
        this.staleFileDeletionTask = new AsyncStaleFileDeletion(this);
        this.remoteManifestManager = this.remoteClusterStateService.getRemoteManifestManager();
    }

    @Override
    public void close() throws IOException {
        if (this.staleFileDeletionTask != null) {
            this.staleFileDeletionTask.close();
        }
    }

    private BlobStoreTransferService getBlobStoreTransferService() {
        if (this.blobStoreTransferService == null) {
            this.blobStoreTransferService = new BlobStoreTransferService(this.remoteClusterStateService.getBlobStore(), this.threadpool);
        }
        return this.blobStoreTransferService;
    }

    private void updateCleanupInterval(TimeValue updatedInterval) {
        this.staleFileCleanupInterval = updatedInterval;
        logger.info("updated remote state cleanup interval to {}", (Object)updatedInterval);
        if (this.staleFileDeletionTask != null && !this.staleFileDeletionTask.getInterval().equals((Object)updatedInterval)) {
            this.staleFileDeletionTask.setInterval(updatedInterval);
        }
    }

    void cleanUpStaleFiles() {
        ClusterState currentAppliedState = this.clusterApplierService.state();
        if (currentAppliedState.nodes().isLocalNodeElectedClusterManager()) {
            long cleanUpAttemptStateVersion = currentAppliedState.version();
            assert (Strings.isNotEmpty((CharSequence)currentAppliedState.getClusterName().value())) : "cluster name is not set";
            assert (Strings.isNotEmpty((CharSequence)currentAppliedState.metadata().clusterUUID())) : "cluster uuid is not set";
            if (cleanUpAttemptStateVersion - this.lastCleanupAttemptStateVersion > 10L) {
                logger.info("Cleaning up stale remote state files for cluster [{}] with uuid [{}]. Last clean was done before {} updates", (Object)currentAppliedState.getClusterName().value(), (Object)currentAppliedState.metadata().clusterUUID(), (Object)(cleanUpAttemptStateVersion - this.lastCleanupAttemptStateVersion));
                this.deleteStaleClusterMetadata(currentAppliedState.getClusterName().value(), currentAppliedState.metadata().clusterUUID(), 10);
                this.lastCleanupAttemptStateVersion = cleanUpAttemptStateVersion;
            } else {
                logger.debug("Skipping cleanup of stale remote state files for cluster [{}] with uuid [{}]. Last clean was done before {} updates, which is less than threshold {}", (Object)currentAppliedState.getClusterName().value(), (Object)currentAppliedState.metadata().clusterUUID(), (Object)(cleanUpAttemptStateVersion - this.lastCleanupAttemptStateVersion), (Object)10);
            }
        } else {
            logger.debug("Skipping cleanup task as local node is not elected Cluster Manager");
        }
    }

    private void addStaleGlobalMetadataPath(String fileName, Set<String> filesToKeep, Set<String> staleGlobalMetadataPaths) {
        if (!filesToKeep.contains(fileName)) {
            String[] splitPath = fileName.split("/");
            staleGlobalMetadataPaths.add(new BlobPath().add("global-metadata").buildAsString() + RemoteGlobalMetadata.GLOBAL_METADATA_FORMAT.blobName(splitPath[splitPath.length - 1]));
        }
    }

    void deleteClusterMetadata(String clusterName, String clusterUUID, List<BlobMetadata> activeManifestBlobMetadata, List<BlobMetadata> staleManifestBlobMetadata) {
        try {
            HashSet filesToKeep = new HashSet();
            HashSet staleManifestPaths = new HashSet();
            HashSet staleIndexMetadataPaths = new HashSet();
            HashSet staleGlobalMetadataPaths = new HashSet();
            HashSet staleEphemeralAttributePaths = new HashSet();
            HashSet staleIndexRoutingPaths = new HashSet();
            HashSet staleIndexRoutingDiffPaths = new HashSet();
            activeManifestBlobMetadata.forEach(blobMetadata -> {
                ClusterMetadataManifest clusterMetadataManifest = this.remoteManifestManager.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, blobMetadata.name());
                clusterMetadataManifest.getIndices().forEach(uploadedIndexMetadata -> filesToKeep.add(RemoteClusterStateUtils.getFormattedIndexFileName(uploadedIndexMetadata.getUploadedFilename())));
                if (clusterMetadataManifest.getCodecVersion() == 1) {
                    filesToKeep.add(clusterMetadataManifest.getGlobalMetadataFileName());
                } else if (clusterMetadataManifest.getCodecVersion() >= 2) {
                    filesToKeep.add(clusterMetadataManifest.getCoordinationMetadata().getUploadedFilename());
                    filesToKeep.add(clusterMetadataManifest.getSettingsMetadata().getUploadedFilename());
                    filesToKeep.add(clusterMetadataManifest.getTemplatesMetadata().getUploadedFilename());
                    clusterMetadataManifest.getCustomMetadataMap().values().forEach(attribute -> filesToKeep.add(attribute.getUploadedFilename()));
                }
                if (clusterMetadataManifest.getTransientSettingsMetadata() != null) {
                    filesToKeep.add(clusterMetadataManifest.getTransientSettingsMetadata().getUploadedFilename());
                }
                if (clusterMetadataManifest.getHashesOfConsistentSettings() != null) {
                    filesToKeep.add(clusterMetadataManifest.getHashesOfConsistentSettings().getUploadedFilename());
                }
                if (clusterMetadataManifest.getDiscoveryNodesMetadata() != null) {
                    filesToKeep.add(clusterMetadataManifest.getDiscoveryNodesMetadata().getUploadedFilename());
                }
                if (clusterMetadataManifest.getClusterBlocksMetadata() != null) {
                    filesToKeep.add(clusterMetadataManifest.getClusterBlocksMetadata().getUploadedFilename());
                }
                if (clusterMetadataManifest.getClusterStateCustomMap() != null) {
                    clusterMetadataManifest.getClusterStateCustomMap().values().forEach(attribute -> filesToKeep.add(attribute.getUploadedFilename()));
                }
                if (clusterMetadataManifest.getIndicesRouting() != null) {
                    clusterMetadataManifest.getIndicesRouting().forEach(uploadedIndicesRouting -> filesToKeep.add(uploadedIndicesRouting.getUploadedFilename()));
                }
                if (clusterMetadataManifest.getDiffManifest() != null && clusterMetadataManifest.getDiffManifest().getIndicesRoutingDiffPath() != null) {
                    filesToKeep.add(clusterMetadataManifest.getDiffManifest().getIndicesRoutingDiffPath());
                }
            });
            staleManifestBlobMetadata.forEach(blobMetadata -> {
                ClusterMetadataManifest clusterMetadataManifest = this.remoteManifestManager.fetchRemoteClusterMetadataManifest(clusterName, clusterUUID, blobMetadata.name());
                staleManifestPaths.add(this.remoteManifestManager.getManifestFolderPath(clusterName, clusterUUID).buildAsString() + blobMetadata.name());
                if (clusterMetadataManifest.getCodecVersion() == 1) {
                    this.addStaleGlobalMetadataPath(clusterMetadataManifest.getGlobalMetadataFileName(), filesToKeep, staleGlobalMetadataPaths);
                } else if (clusterMetadataManifest.getCodecVersion() >= 2) {
                    if (!filesToKeep.contains(clusterMetadataManifest.getCoordinationMetadata().getUploadedFilename())) {
                        staleGlobalMetadataPaths.add(clusterMetadataManifest.getCoordinationMetadata().getUploadedFilename());
                    }
                    if (!filesToKeep.contains(clusterMetadataManifest.getSettingsMetadata().getUploadedFilename())) {
                        staleGlobalMetadataPaths.add(clusterMetadataManifest.getSettingsMetadata().getUploadedFilename());
                    }
                    if (!filesToKeep.contains(clusterMetadataManifest.getTemplatesMetadata().getUploadedFilename())) {
                        staleGlobalMetadataPaths.add(clusterMetadataManifest.getTemplatesMetadata().getUploadedFilename());
                    }
                    clusterMetadataManifest.getCustomMetadataMap().values().stream().map(ClusterMetadataManifest.UploadedMetadataAttribute::getUploadedFilename).filter(file -> !filesToKeep.contains(file)).forEach(staleGlobalMetadataPaths::add);
                }
                if (clusterMetadataManifest.getIndicesRouting() != null) {
                    clusterMetadataManifest.getIndicesRouting().forEach(uploadedIndicesRouting -> {
                        if (!filesToKeep.contains(uploadedIndicesRouting.getUploadedFilename())) {
                            staleIndexRoutingPaths.add(uploadedIndicesRouting.getUploadedFilename());
                            logger.debug(() -> new ParameterizedMessage("Indices routing paths in stale manifest: {}", (Object)uploadedIndicesRouting.getUploadedFilename()));
                        }
                    });
                }
                if (clusterMetadataManifest.getDiffManifest() != null && clusterMetadataManifest.getDiffManifest().getIndicesRoutingDiffPath() != null && !filesToKeep.contains(clusterMetadataManifest.getDiffManifest().getIndicesRoutingDiffPath())) {
                    staleIndexRoutingDiffPaths.add(clusterMetadataManifest.getDiffManifest().getIndicesRoutingDiffPath());
                    logger.debug(() -> new ParameterizedMessage("Indices routing diff paths in stale manifest: {}", (Object)clusterMetadataManifest.getDiffManifest().getIndicesRoutingDiffPath()));
                }
                clusterMetadataManifest.getIndices().forEach(uploadedIndexMetadata -> {
                    String fileName = RemoteClusterStateUtils.getFormattedIndexFileName(uploadedIndexMetadata.getUploadedFilename());
                    if (!filesToKeep.contains(fileName)) {
                        staleIndexMetadataPaths.add(fileName);
                    }
                });
                if (clusterMetadataManifest.getClusterBlocksMetadata() != null && !filesToKeep.contains(clusterMetadataManifest.getClusterBlocksMetadata().getUploadedFilename())) {
                    staleEphemeralAttributePaths.add(clusterMetadataManifest.getClusterBlocksMetadata().getUploadedFilename());
                }
                if (clusterMetadataManifest.getDiscoveryNodesMetadata() != null && !filesToKeep.contains(clusterMetadataManifest.getDiscoveryNodesMetadata().getUploadedFilename())) {
                    staleEphemeralAttributePaths.add(clusterMetadataManifest.getDiscoveryNodesMetadata().getUploadedFilename());
                }
                if (clusterMetadataManifest.getTransientSettingsMetadata() != null && !filesToKeep.contains(clusterMetadataManifest.getTransientSettingsMetadata().getUploadedFilename())) {
                    staleEphemeralAttributePaths.add(clusterMetadataManifest.getTransientSettingsMetadata().getUploadedFilename());
                }
                if (clusterMetadataManifest.getHashesOfConsistentSettings() != null && !filesToKeep.contains(clusterMetadataManifest.getHashesOfConsistentSettings().getUploadedFilename())) {
                    staleEphemeralAttributePaths.add(clusterMetadataManifest.getHashesOfConsistentSettings().getUploadedFilename());
                }
                if (clusterMetadataManifest.getClusterStateCustomMap() != null) {
                    clusterMetadataManifest.getCustomMetadataMap().values().stream().filter(u -> !filesToKeep.contains(u.getUploadedFilename())).forEach(attribute -> staleEphemeralAttributePaths.add(attribute.getUploadedFilename()));
                }
            });
            if (staleManifestPaths.isEmpty()) {
                logger.debug("No stale Remote Cluster Metadata files found");
                return;
            }
            this.deleteStalePaths(new ArrayList<String>(staleGlobalMetadataPaths));
            this.deleteStalePaths(new ArrayList<String>(staleIndexMetadataPaths));
            this.deleteStalePaths(new ArrayList<String>(staleEphemeralAttributePaths));
            this.deleteStalePaths(new ArrayList<String>(staleManifestPaths));
            try {
                this.remoteRoutingTableService.deleteStaleIndexRoutingPaths(new ArrayList<String>(staleIndexRoutingPaths));
            }
            catch (IOException e) {
                logger.error(() -> new ParameterizedMessage("Error while deleting stale index routing files {}", (Object)staleIndexRoutingPaths), (Throwable)e);
                this.remoteStateStats.indexRoutingFilesCleanupAttemptFailed();
            }
            try {
                this.remoteRoutingTableService.deleteStaleIndexRoutingDiffPaths(new ArrayList<String>(staleIndexRoutingDiffPaths));
            }
            catch (IOException e) {
                logger.error(() -> new ParameterizedMessage("Error while deleting stale index routing diff files {}", (Object)staleIndexRoutingDiffPaths), (Throwable)e);
                this.remoteStateStats.indicesRoutingDiffFileCleanupAttemptFailed();
            }
        }
        catch (IllegalStateException e) {
            logger.error("Error while fetching Remote Cluster Metadata manifests", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Error while deleting stale Remote Cluster Metadata files", (Throwable)e);
            this.remoteStateStats.cleanUpAttemptFailed();
        }
        catch (Exception e) {
            logger.error("Unexpected error while deleting stale Remote Cluster Metadata files", (Throwable)e);
            this.remoteStateStats.cleanUpAttemptFailed();
        }
    }

    void deleteStaleClusterMetadata(final String clusterName, final String clusterUUID, final int manifestsToRetain) {
        if (!this.deleteStaleMetadataRunning.compareAndSet(false, true)) {
            logger.info("Delete stale cluster metadata task is already in progress.");
            return;
        }
        try {
            this.getBlobStoreTransferService().listAllInSortedOrderAsync("remote_purge", this.remoteManifestManager.getManifestFolderPath(clusterName, clusterUUID), "manifest", Integer.MAX_VALUE, new ActionListener<List<BlobMetadata>>(){

                public void onResponse(List<BlobMetadata> blobMetadata) {
                    if (blobMetadata.size() > manifestsToRetain) {
                        RemoteClusterStateCleanupManager.this.deleteClusterMetadata(clusterName, clusterUUID, blobMetadata.subList(0, manifestsToRetain), blobMetadata.subList(manifestsToRetain, blobMetadata.size()));
                    }
                    RemoteClusterStateCleanupManager.this.deleteStaleMetadataRunning.set(false);
                }

                public void onFailure(Exception e) {
                    logger.error((Message)new ParameterizedMessage("Exception occurred while deleting Remote Cluster Metadata for clusterUUIDs {}", (Object)clusterUUID));
                    RemoteClusterStateCleanupManager.this.deleteStaleMetadataRunning.set(false);
                }
            });
        }
        catch (Exception e) {
            this.deleteStaleMetadataRunning.set(false);
            throw e;
        }
    }

    void deleteStaleUUIDsClusterMetadata(String clusterName, List<String> clusterUUIDs) {
        clusterUUIDs.forEach(clusterUUID -> this.getBlobStoreTransferService().deleteAsync("remote_purge", RemoteClusterStateUtils.getClusterMetadataBasePath(this.remoteClusterStateService.getBlobStoreRepository(), clusterName, clusterUUID), new ActionListener<Void>(){

            public void onResponse(Void unused) {
                logger.info("Deleted all remote cluster metadata for cluster UUID - {}", (Object)clusterUUID);
            }

            public void onFailure(Exception e) {
                logger.error((Message)new ParameterizedMessage("Exception occurred while deleting all remote cluster metadata for cluster UUID {}", (Object)clusterUUID), (Throwable)e);
                RemoteClusterStateCleanupManager.this.remoteStateStats.cleanUpAttemptFailed();
            }
        }));
    }

    void deleteStalePaths(List<String> stalePaths) throws IOException {
        logger.debug(String.format(Locale.ROOT, "Deleting stale files from remote - %s", stalePaths));
        this.getBlobStoreTransferService().deleteBlobs(BlobPath.cleanPath(), stalePaths);
    }

    public void deleteStaleClusterUUIDs(ClusterState clusterState, ClusterMetadataManifest committedManifest) {
        this.threadpool.executor("remote_purge").execute(() -> {
            HashSet<String> allClustersUUIDsInRemote;
            String clusterName = clusterState.getClusterName().value();
            logger.debug("Deleting stale cluster UUIDs data from remote [{}]", (Object)clusterName);
            try {
                allClustersUUIDsInRemote = new HashSet<String>(this.remoteClusterStateService.getAllClusterUUIDs(clusterState.getClusterName().value()));
            }
            catch (IOException e) {
                logger.info(String.format(Locale.ROOT, "Error while fetching all cluster UUIDs for [%s]", clusterName));
                return;
            }
            allClustersUUIDsInRemote.remove(committedManifest.getClusterUUID());
            allClustersUUIDsInRemote.remove(committedManifest.getPreviousClusterUUID());
            this.deleteStaleUUIDsClusterMetadata(clusterName, new ArrayList<String>(allClustersUUIDsInRemote));
        });
    }

    public TimeValue getStaleFileCleanupInterval() {
        return this.staleFileCleanupInterval;
    }

    AsyncStaleFileDeletion getStaleFileDeletionTask() {
        return this.staleFileDeletionTask;
    }

    RemotePersistenceStats getStats() {
        return this.remoteStateStats;
    }

    static final class AsyncStaleFileDeletion
    extends AbstractAsyncTask {
        private final RemoteClusterStateCleanupManager remoteClusterStateCleanupManager;

        AsyncStaleFileDeletion(RemoteClusterStateCleanupManager remoteClusterStateCleanupManager) {
            super(logger, remoteClusterStateCleanupManager.threadpool, remoteClusterStateCleanupManager.getStaleFileCleanupInterval(), true);
            this.remoteClusterStateCleanupManager = remoteClusterStateCleanupManager;
            this.rescheduleIfNecessary();
        }

        @Override
        protected boolean mustReschedule() {
            return true;
        }

        @Override
        protected void runInternal() {
            this.remoteClusterStateCleanupManager.cleanUpStaleFiles();
        }

        @Override
        protected String getThreadPool() {
            return "remote_purge";
        }
    }
}

