/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.opensearch.cluster.AbstractDiffable;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.ParseField;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ConstructingObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@ExperimentalApi
public class Context
extends AbstractDiffable<ComposableIndexTemplate>
implements ToXContentObject {
    private static final ParseField NAME = new ParseField("name", new String[0]);
    private static final ParseField VERSION = new ParseField("version", new String[0]);
    private static final ParseField PARAMS = new ParseField("params", new String[0]);
    public static final String LATEST_VERSION = "_latest";
    private String name;
    private String version = "_latest";
    private Map<String, Object> params;
    public static final ConstructingObjectParser<Context, Void> PARSER = new ConstructingObjectParser("index_template", false, a -> new Context((String)a[0], (String)a[1], (Map)a[2]));

    public Context(String name) {
        this(name, LATEST_VERSION, Map.of());
    }

    public Context(String name, String version, Map<String, Object> params) {
        this.name = name;
        if (version != null) {
            this.version = version;
        }
        this.params = params;
    }

    public Context(StreamInput in) throws IOException {
        this.name = in.readString();
        this.version = in.readOptionalString();
        this.params = in.readMap();
    }

    public String name() {
        return this.name;
    }

    public void name(String name) {
        this.name = name;
    }

    public String version() {
        return this.version;
    }

    public void version(String version) {
        this.version = version;
    }

    public Map<String, Object> params() {
        return this.params;
    }

    public void params(Map<String, Object> params) {
        this.params = params;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.version);
        out.writeMap(this.params);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME.getPreferredName(), this.name);
        builder.field("version", this.version);
        if (params != null) {
            builder.field("params", this.params);
        }
        builder.endObject();
        return builder;
    }

    public static Context fromXContent(XContentParser parser) {
        return (Context)PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Context context = (Context)o;
        return Objects.equals(this.name, context.name) && Objects.equals(this.version, context.version) && Objects.equals(this.params, context.params);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.version, this.params);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), NAME);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), VERSION);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), PARAMS);
    }
}

