/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BcdUtil;
import org.traccar.helper.BitUtil;
import org.traccar.helper.BufferUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NiotProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_RESPONSE = 33;
    public static final int MSG_POSITION_DATA = 128;

    public NiotProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int type, int checksum) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeShort(22616);
            response.writeByte(33);
            response.writeShort(5);
            response.writeByte(checksum);
            response.writeByte(type);
            response.writeByte(0);
            response.writeByte(Checksum.xor(response.nioBuffer(2, response.writerIndex())));
            response.writeByte(13);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.skipBytes(2);
        short type = buf.readUnsignedByte();
        buf.readUnsignedShort();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        this.sendResponse(channel, remoteAddress, type, buf.getByte(buf.writerIndex() - 2));
        if (type == 128) {
            Position position = new Position(this.getProtocolName());
            DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
            if (deviceSession == null) {
                return null;
            }
            position.setDeviceId(deviceSession.getDeviceId());
            DateBuilder dateBuilder = new DateBuilder().setYear(BcdUtil.readInteger(buf, 2)).setMonth(BcdUtil.readInteger(buf, 2)).setDay(BcdUtil.readInteger(buf, 2)).setHour(BcdUtil.readInteger(buf, 2)).setMinute(BcdUtil.readInteger(buf, 2)).setSecond(BcdUtil.readInteger(buf, 2));
            position.setTime(dateBuilder.getDate());
            position.setLatitude((double)BufferUtil.readSignedMagnitudeInt(buf) / 1800000.0);
            position.setLongitude((double)BufferUtil.readSignedMagnitudeInt(buf) / 1800000.0);
            BcdUtil.readInteger(buf, 4);
            position.setCourse(BcdUtil.readInteger(buf, 4));
            short statusX = buf.readUnsignedByte();
            position.setValid(BitUtil.check(statusX, 7));
            switch (BitUtil.between(statusX, 3, 5)) {
                case 2: {
                    position.set("alarm", "powerCut");
                    break;
                }
                case 1: {
                    position.set("alarm", "lowPower");
                }
            }
            position.set("odometer", buf.readUnsignedInt());
            short statusA = buf.readUnsignedByte();
            position.set("ignition", !BitUtil.check(statusA, 7));
            if (!BitUtil.check(statusA, 6)) {
                position.set("alarm", "overspeed");
            }
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            position.set("sat", buf.readUnsignedByte());
            position.set("battery", (double)buf.readUnsignedByte() * 0.1);
            position.set("power", (double)buf.readUnsignedShort() * 0.1);
            buf.readUnsignedByte();
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            buf.readUnsignedByte();
            block8: while (buf.readableBytes() > 4) {
                int extendedLength = buf.readUnsignedShort();
                int extendedType = buf.readUnsignedShort();
                switch (extendedType) {
                    case 1: {
                        position.set("iccid", buf.readCharSequence(20, StandardCharsets.US_ASCII).toString());
                        continue block8;
                    }
                    case 2: {
                        short statusD = buf.readUnsignedByte();
                        position.set("alarm", BitUtil.check(statusD, 5) ? "removing" : null);
                        position.set("alarm", BitUtil.check(statusD, 4) ? "tampering" : null);
                        buf.readUnsignedByte();
                        buf.readUnsignedByte();
                        continue block8;
                    }
                }
                buf.skipBytes(extendedLength - 2);
            }
            return position;
        }
        return null;
    }
}

