"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _constants = require("../utils/constants");
var _MDSEnabledClientService = require("./MDSEnabledClientService");
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class FindingsService extends _MDSEnabledClientService.MDSEnabledClientService {
  constructor(...args) {
    super(...args);
    /**
     * Calls backend GET Findings API.
     */
    _defineProperty(this, "getFindings", async (context, request, response) => {
      try {
        const params = {
          ...request.query
        };
        const client = this.getClient(request, context);
        // Delete the dataSourceId since this query param is not supported by the finding API
        delete params['dataSourceId'];
        const getFindingsResponse = await client(_constants.CLIENT_DETECTOR_METHODS.GET_FINDINGS, params);
        getFindingsResponse.findings.forEach(finding => {
          const types = [];
          if (!finding.queries.every(query => query.id.startsWith('threat_intel_'))) {
            types.push('Detection rules');
          }
          if (finding.queries.some(query => query.id.startsWith('threat_intel_'))) {
            types.push('Threat intelligence');
            finding['ruleSeverity'] = 'high';
          }
          finding['detectionType'] = types.join(', ');
        });
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFindingsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FindingsService - getFindings:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
    _defineProperty(this, "getThreatIntelFindings", async (context, request, response) => {
      try {
        const params = {
          ...request.query
        };
        const client = this.getClient(request, context);
        // Delete the dataSourceId since this query param is not supported by the finding API
        delete params['dataSourceId'];
        const getFindingsResponse = await client(_constants.CLIENT_THREAT_INTEL_METHODS.GET_THREAT_INTEL_FINDINGS, params);
        return response.custom({
          statusCode: 200,
          body: {
            ok: true,
            response: getFindingsResponse
          }
        });
      } catch (error) {
        console.error('Security Analytics - FindingsService - getThreatIntelFindings:', error);
        return response.custom({
          statusCode: 200,
          body: {
            ok: false,
            error: error.message
          }
        });
      }
    });
  }
}
exports.default = FindingsService;
module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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