"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateModelSearchQuery = void 0;
var _query = require("./query");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const generateModelSearchQuery = ({
  states,
  nameOrId,
  extraQuery
}) => ({
  bool: {
    must: [...(states ? [(0, _query.generateTermQuery)('model_state', states)] : []), ...(nameOrId ? [{
      bool: {
        should: [{
          wildcard: {
            'name.keyword': {
              value: `*${nameOrId}*`,
              case_insensitive: true
            }
          }
        }, (0, _query.generateTermQuery)('_id', nameOrId)]
      }
    }] : []), ...(extraQuery ? [extraQuery] : [])],
    must_not: {
      exists: {
        field: 'chunk_number'
      }
    }
  }
});
exports.generateModelSearchQuery = generateModelSearchQuery;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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