"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getMustQuery = getMustQuery;
exports.getSearchString = getSearchString;
exports.transformManagedIndexMetaData = transformManagedIndexMetaData;
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

function transformManagedIndexMetaData(metaData) {
  if (!metaData) return null;
  // If this is not a managed index or we are still initializing we still return the
  // plugins.index_state_management.policy_id setting, but nothing else from the explain API
  if (!metaData.index) return null;
  return {
    index: metaData.index,
    // We know indexUuid and policyName exist if index exists
    indexUuid: metaData.index_uuid,
    policyId: metaData.policy_id,
    policySeqNo: metaData.policy_seq_no,
    policyPrimaryTerm: metaData.policy_primary_term,
    policyCompleted: metaData.policy_completed,
    rolledOver: metaData.rolled_over,
    transitionTo: metaData.transition_to,
    state: metaData.state ? {
      name: metaData.state.name,
      startTime: metaData.state.start_time
    } : undefined,
    action: metaData.action ? {
      name: metaData.action.name,
      startTime: metaData.action.start_time,
      index: metaData.action.index,
      failed: metaData.action.failed,
      consumedRetries: metaData.action.consumed_retries
    } : undefined,
    retryInfo: metaData.retry_info ? {
      failed: metaData.retry_info.failed,
      consumedRetries: metaData.retry_info.consumed_retries
    } : undefined,
    info: metaData.info
  };
}
function getMustQuery(field, search) {
  const str = search.trim();
  if (search.trim()) {
    return {
      query_string: {
        default_field: field,
        default_operator: "AND",
        query: str ? `*${str.split(" ").join("* *")}*` : "*"
      }
    };
  }
  return {
    match_all: {}
  };
}
function getSearchString(terms, indices, dataStreams, showDataStreams = true) {
  // Terms are searched with a wildcard around them.
  const searchTerms = terms ? `*${_lodash.default.castArray(terms).join("*,*")}*` : "";

  // Indices and data streams are searched with wildcards around them.
  const searchIndices = indices ? `*${_lodash.default.castArray(indices).join("*,*")}*` : "";
  const searchDataStreams = dataStreams ? `*${_lodash.default.castArray(dataStreams).join("*,*")}*` : "";

  // The overall search string is a combination of terms, indices, and data streams.
  // If the search string is blank, then '*' is used to match everything.
  const resolved = [searchTerms, searchIndices, searchDataStreams].filter(value => value !== "").join(",") || "*";
  // We don't want to fetch managed datastream indices if there are not selected by caller.
  return showDataStreams ? resolved : resolved + " -.ds*";
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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