"use strict";

var _react = _interopRequireDefault(require("react"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// https://github.com/elastic/eui/issues/2530
jest.mock('@elastic/eui/lib/components/icon', () => ({
  EuiIcon: () => /*#__PURE__*/_react.default.createElement("div", null, "EuiIconMock"),
  __esModule: true,
  IconPropType: require('@elastic/eui/lib/components/icon/icon').IconPropType,
  ICON_TYPES: require('@elastic/eui/lib/components/icon/icon').TYPES,
  ICON_SIZES: require('@elastic/eui/lib/components/icon/icon').SIZES,
  ICON_COLORS: require('@elastic/eui/lib/components/icon/icon').COLORS
}));
jest.mock('@elastic/eui/lib/components/form/form_row/make_id', () => () => 'some_make_id');
jest.mock('@elastic/eui/lib/services/accessibility', () => ({
  htmlIdGenerator: () => () => 'generated-id',
  cascadingMenuKeys: require('@elastic/eui/lib/services/accessibility/cascading_menu_keys'),
  comboBoxKeys: require('@elastic/eui/lib/services/accessibility/combo_box_keys'),
  accessibleClickKeys: require('@elastic/eui/lib/services/accessibility/accessible_click_keys')
}));

// https://github.com/facebook/jest/issues/5785
// https://github.com/facebook/jest/pull/5267#issuecomment-356605468
beforeEach(() => {
  jest.spyOn(console, 'error');
  console.error.mockImplementation(() => {});
});
afterEach(() => {
  console.error.mockRestore();
});
window.URL.createObjectURL = function () {};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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