"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAgent = void 0;
var _constants = require("../utils/constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const getAgent = async (id, client) => {
  try {
    var _response$body$ml_con, _response$body$config, _response$body$ml_con2;
    const path = `${_constants.ML_COMMONS_BASE_API}/config/${id}`;
    const response = await client.request({
      method: 'GET',
      path
    });
    if (!response || !((_response$body$ml_con = response.body.ml_configuration) !== null && _response$body$ml_con !== void 0 && _response$body$ml_con.agent_id || (_response$body$config = response.body.configuration) !== null && _response$body$config !== void 0 && _response$body$config.agent_id)) {
      throw new Error(`cannot get agent ${id} by calling the api: ${path}`);
    }
    return ((_response$body$ml_con2 = response.body.ml_configuration) === null || _response$body$ml_con2 === void 0 ? void 0 : _response$body$ml_con2.agent_id) || response.body.configuration.agent_id;
  } catch (error) {
    var _error$meta;
    const errorMessage = JSON.stringify((_error$meta = error.meta) === null || _error$meta === void 0 ? void 0 : _error$meta.body) || error;
    throw new Error(`get agent ${id} failed, reason: ${errorMessage}`);
  }
};
exports.getAgent = getAgent;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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