/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import org.mariadb.jdbc.internal.MariaDbType;
import org.mariadb.jdbc.internal.packet.dao.ColumnInformation;

public class MariaDbParameterMetaData
implements ParameterMetaData {
    private final ColumnInformation[] parametersInformation;

    public MariaDbParameterMetaData(ColumnInformation[] parametersInformation) {
        this.parametersInformation = parametersInformation;
    }

    @Override
    public int getParameterCount() throws SQLException {
        return this.parametersInformation.length;
    }

    private ColumnInformation getParameterInformation(int param) throws SQLException {
        if (param >= 1 && param <= this.parametersInformation.length) {
            return this.parametersInformation[param - 1];
        }
        throw new SQLException("Parameter metadata out of range : param was " + param + " and must be 1 <= param <=" + this.parametersInformation.length, "22003");
    }

    @Override
    public int isNullable(int param) throws SQLException {
        if (this.getParameterInformation(param).isNotNull()) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean isSigned(int param) throws SQLException {
        return this.getParameterInformation(param).isSigned();
    }

    @Override
    public int getPrecision(int param) throws SQLException {
        long length = this.getParameterInformation(param).getLength();
        return length > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)length;
    }

    @Override
    public int getScale(int param) throws SQLException {
        if (MariaDbType.isNumeric(this.getParameterInformation(param).getType())) {
            return this.getParameterInformation(param).getDecimals();
        }
        return 0;
    }

    @Override
    public int getParameterType(int param) throws SQLException {
        return this.getParameterInformation(param).getType().getSqlType();
    }

    @Override
    public String getParameterTypeName(int param) throws SQLException {
        return this.getParameterInformation(param).getType().getTypeName();
    }

    @Override
    public String getParameterClassName(int param) throws SQLException {
        return this.getParameterInformation(param).getType().getClassName();
    }

    @Override
    public int getParameterMode(int param) throws SQLException {
        return 1;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

