/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.univariatestats;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

public class UnivariateStatsMetaFunction
implements Cloneable {
    public static final String XML_TAG = "univariate_stats";
    private String m_sourceFieldName;
    private boolean m_n = true;
    private boolean m_mean = true;
    private boolean m_stdDev = true;
    private boolean m_min = true;
    private boolean m_max = true;
    private boolean m_median = true;
    private double m_arbitraryPercentile = -1.0;
    private boolean m_interpolatePercentile = true;

    public UnivariateStatsMetaFunction(String sourceFieldName, boolean n, boolean mean, boolean stdDev, boolean min, boolean max, boolean median, double arbPercentile, boolean interpolate) {
        this.m_sourceFieldName = sourceFieldName;
        this.m_n = n;
        this.m_mean = mean;
        this.m_stdDev = stdDev;
        this.m_min = min;
        this.m_max = max;
        this.m_median = median;
        this.m_arbitraryPercentile = arbPercentile;
        this.m_interpolatePercentile = interpolate;
    }

    public UnivariateStatsMetaFunction(Node uniNode) {
        this.m_sourceFieldName = XMLHandler.getTagValue((Node)uniNode, (String)"source_field_name");
        String temp = XMLHandler.getTagValue((Node)uniNode, (String)"N");
        if (temp.equalsIgnoreCase("N")) {
            this.m_n = false;
        }
        if ((temp = XMLHandler.getTagValue((Node)uniNode, (String)"mean")).equalsIgnoreCase("N")) {
            this.m_mean = false;
        }
        if ((temp = XMLHandler.getTagValue((Node)uniNode, (String)"stdDev")).equalsIgnoreCase("N")) {
            this.m_stdDev = false;
        }
        if ((temp = XMLHandler.getTagValue((Node)uniNode, (String)"min")).equalsIgnoreCase("N")) {
            this.m_min = false;
        }
        if ((temp = XMLHandler.getTagValue((Node)uniNode, (String)"max")).equalsIgnoreCase("N")) {
            this.m_max = false;
        }
        if ((temp = XMLHandler.getTagValue((Node)uniNode, (String)"median")).equalsIgnoreCase("N")) {
            this.m_median = false;
        }
        temp = XMLHandler.getTagValue((Node)uniNode, (String)"percentile");
        try {
            this.m_arbitraryPercentile = Double.parseDouble(temp);
        }
        catch (Exception ex) {
            this.m_arbitraryPercentile = -1.0;
        }
        temp = XMLHandler.getTagValue((Node)uniNode, (String)"interpolate");
        if (temp.equalsIgnoreCase("N")) {
            this.m_interpolatePercentile = false;
        }
    }

    public UnivariateStatsMetaFunction(Repository rep, long id_step, int nr) throws KettleException {
        this.m_sourceFieldName = rep.getStepAttributeString(id_step, nr, "source_field_name");
        this.m_n = rep.getStepAttributeBoolean(id_step, nr, "N");
        this.m_mean = rep.getStepAttributeBoolean(id_step, nr, "mean");
        this.m_stdDev = rep.getStepAttributeBoolean(id_step, nr, "stdDev");
        this.m_min = rep.getStepAttributeBoolean(id_step, nr, "min");
        this.m_max = rep.getStepAttributeBoolean(id_step, nr, "max");
        this.m_median = rep.getStepAttributeBoolean(id_step, nr, "median");
        String temp = rep.getStepAttributeString(id_step, nr, "percentile");
        try {
            this.m_arbitraryPercentile = Double.parseDouble(temp);
        }
        catch (Exception ex) {
            this.m_arbitraryPercentile = -1.0;
        }
        this.m_interpolatePercentile = rep.getStepAttributeBoolean(id_step, nr, "interpolate");
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            UnivariateStatsMetaFunction mf = (UnivariateStatsMetaFunction)obj;
            return this.getXML() == mf.getXML();
        }
        return false;
    }

    public String getXML() {
        String xml = "<univariate_stats>";
        xml = xml + XMLHandler.addTagValue((String)"source_field_name", (String)this.m_sourceFieldName);
        xml = xml + XMLHandler.addTagValue((String)"N", (boolean)this.m_n);
        xml = xml + XMLHandler.addTagValue((String)"mean", (boolean)this.m_mean);
        xml = xml + XMLHandler.addTagValue((String)"stdDev", (boolean)this.m_stdDev);
        xml = xml + XMLHandler.addTagValue((String)"min", (boolean)this.m_min);
        xml = xml + XMLHandler.addTagValue((String)"max", (boolean)this.m_max);
        xml = xml + XMLHandler.addTagValue((String)"median", (boolean)this.m_median);
        xml = xml + XMLHandler.addTagValue((String)"percentile", (String)("" + this.m_arbitraryPercentile));
        xml = xml + XMLHandler.addTagValue((String)"interpolate", (boolean)this.m_interpolatePercentile);
        xml = xml + "</univariate_stats>";
        return xml;
    }

    public void saveRep(Repository rep, long id_transformation, long id_step, int nr) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "source_field_name", this.m_sourceFieldName);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "N", this.m_n);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "mean", this.m_mean);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "stdDev", this.m_stdDev);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "min", this.m_min);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "max", this.m_max);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "median", this.m_median);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "percentile", " " + this.m_arbitraryPercentile);
        rep.saveStepAttribute(id_transformation, id_step, (long)nr, "interpolate", this.m_interpolatePercentile);
    }

    public Object clone() {
        try {
            UnivariateStatsMetaFunction retval = (UnivariateStatsMetaFunction)super.clone();
            return retval;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setSourceFieldName(String sn) {
        this.m_sourceFieldName = sn;
    }

    public String getSourceFieldName() {
        return this.m_sourceFieldName;
    }

    public void setCalcN(boolean n) {
        this.m_n = n;
    }

    public boolean getCalcN() {
        return this.m_n;
    }

    public void setCalcMean(boolean b) {
        this.m_mean = b;
    }

    public boolean getCalcMean() {
        return this.m_mean;
    }

    public void setCalcStdDev(boolean b) {
        this.m_stdDev = b;
    }

    public boolean getCalcStdDev() {
        return this.m_stdDev;
    }

    public void setCalcMin(boolean b) {
        this.m_min = b;
    }

    public boolean getCalcMin() {
        return this.m_min;
    }

    public void setCalcMax(boolean b) {
        this.m_max = b;
    }

    public boolean getCalcMax() {
        return this.m_max;
    }

    public void setCalcMedian(boolean b) {
        this.m_median = b;
    }

    public boolean getCalcMedian() {
        return this.m_median;
    }

    public boolean getInterpolatePercentile() {
        return this.m_interpolatePercentile;
    }

    public void setInterpolatePercentile(boolean i) {
        this.m_interpolatePercentile = i;
    }

    public double getCalcPercentile() {
        return this.m_arbitraryPercentile;
    }

    public void setCalcPercentile(double percentile) {
        if (percentile < 0.0) {
            this.m_arbitraryPercentile = -1.0;
            return;
        }
        if (percentile >= 0.0 && percentile <= 100.0) {
            this.m_arbitraryPercentile = percentile / 100.0;
            return;
        }
        this.m_arbitraryPercentile = -1.0;
    }

    public int numberOfMetricsRequested() {
        int num = 0;
        if (this.getCalcN()) {
            ++num;
        }
        if (this.getCalcMean()) {
            ++num;
        }
        if (this.getCalcStdDev()) {
            ++num;
        }
        if (this.getCalcMin()) {
            ++num;
        }
        if (this.getCalcMax()) {
            ++num;
        }
        if (this.getCalcMedian()) {
            ++num;
        }
        if (this.getCalcPercentile() >= 0.0) {
            ++num;
        }
        return num;
    }
}

