/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.ExpressionColumn;
import org.hsqldb.RangeGroup;
import org.hsqldb.Session;
import org.hsqldb.SetFunction;
import org.hsqldb.SetFunctionValueAggregate;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.List;
import org.hsqldb.map.ValuePool;
import org.hsqldb.types.IntervalType;
import org.hsqldb.types.NumberType;
import org.hsqldb.types.RowType;
import org.hsqldb.types.Type;

public class ExpressionAggregate
extends Expression {
    ExpressionAggregate(int n, boolean bl, Expression expression) {
        super(n);
        this.nodes = new Expression[2];
        this.isDistinctAggregate = bl;
        this.nodes[0] = expression;
        this.nodes[1] = Expression.EXPR_TRUE;
    }

    @Override
    public boolean isSelfAggregate() {
        return true;
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(64);
        String string = ExpressionAggregate.getContextSQL(this.nodes.length > 0 ? this.nodes[0] : null);
        switch (this.opType) {
            case 74: {
                stringBuilder.append(' ').append("COUNT").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 75: {
                stringBuilder.append(' ').append("SUM").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 76: {
                stringBuilder.append(' ').append("MIN").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 77: {
                stringBuilder.append(' ').append("MAX").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 78: {
                stringBuilder.append(' ').append("AVG").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 79: {
                stringBuilder.append(' ').append("EVERY").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 80: {
                stringBuilder.append(' ').append("SOME").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 81: {
                stringBuilder.append(' ').append("STDDEV_POP").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 82: {
                stringBuilder.append(' ').append("STDDEV_SAMP").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 83: {
                stringBuilder.append(' ').append("VAR_POP").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            case 84: {
                stringBuilder.append(' ').append("VAR_SAMP").append('(');
                stringBuilder.append(string).append(')');
                break;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String describe(Session session, int n) {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append('\n');
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(' ');
        }
        switch (this.opType) {
            case 74: {
                stringBuilder.append("COUNT").append(' ');
                break;
            }
            case 75: {
                stringBuilder.append("SUM").append(' ');
                break;
            }
            case 76: {
                stringBuilder.append("MIN").append(' ');
                break;
            }
            case 77: {
                stringBuilder.append("MAX").append(' ');
                break;
            }
            case 78: {
                stringBuilder.append("AVG").append(' ');
                break;
            }
            case 79: {
                stringBuilder.append("EVERY").append(' ');
                break;
            }
            case 80: {
                stringBuilder.append("SOME").append(' ');
                break;
            }
            case 81: {
                stringBuilder.append("STDDEV_POP").append(' ');
                break;
            }
            case 82: {
                stringBuilder.append("STDDEV_SAMP").append(' ');
                break;
            }
            case 83: {
                stringBuilder.append("VAR_POP").append(' ');
                break;
            }
            case 84: {
                stringBuilder.append("VAR_SAMP").append(' ');
                break;
            }
        }
        if (this.getLeftNode() != null) {
            stringBuilder.append(" arg=[");
            stringBuilder.append(this.nodes[0].describe(session, n + 1));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public List resolveColumnReferences(Session session, RangeGroup rangeGroup, int n, RangeGroup[] rangeGroupArray, List arrayListIdentity, boolean bl) {
        List list = this.nodes[1].resolveColumnReferences(session, rangeGroup, n, rangeGroupArray, null, false);
        if (list != null) {
            ExpressionColumn.checkColumnsResolved(list);
        }
        if (arrayListIdentity == null) {
            arrayListIdentity = new ArrayListIdentity<ExpressionAggregate>();
        }
        arrayListIdentity.add(this);
        if (rangeGroup.getRangeVariables().length > 0) {
            this.rangeGroups = rangeGroupArray;
            this.rangeGroup = rangeGroup;
        }
        return arrayListIdentity;
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].resolveTypes(session, this);
        }
        if (this.nodes[0].getDegree() > 1) {
            this.nodes[0].dataType = new RowType(this.nodes[0].nodeDataTypes);
        }
        if (this.nodes[0].isUnresolvedParam()) {
            throw Error.error(5567);
        }
        if (this.isDistinctAggregate && this.nodes[0].dataType.isLobType()) {
            throw Error.error(5534);
        }
        this.dataType = ExpressionAggregate.getType(session, this.opType, this.nodes[0].dataType);
    }

    static Type getType(Session session, int n, Type type) {
        if (n == 74) {
            return Type.SQL_BIGINT;
        }
        int n2 = type.typeCode;
        if (type.isIntervalYearMonthType()) {
            n2 = 102;
        } else if (type.isIntervalDaySecondType()) {
            n2 = 106;
        }
        switch (n) {
            case 78: 
            case 89: {
                switch (n2) {
                    case -6: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 25: {
                        int n3 = session.database.sqlAvgScale;
                        if (n3 <= type.scale) {
                            return type;
                        }
                        int n4 = ((NumberType)type).getDecimalPrecision();
                        return NumberType.getNumberType(3, n4 + n3, n3);
                    }
                    case 6: 
                    case 7: 
                    case 8: 
                    case 91: 
                    case 92: 
                    case 93: 
                    case 94: 
                    case 95: 
                    case 102: 
                    case 106: {
                        return type;
                    }
                }
                throw Error.error(5563);
            }
            case 75: {
                switch (n2) {
                    case -6: 
                    case 4: 
                    case 5: {
                        return Type.SQL_BIGINT;
                    }
                    case 25: {
                        return Type.SQL_DECIMAL_BIGINT_SQR;
                    }
                    case 6: 
                    case 7: 
                    case 8: {
                        return Type.SQL_DOUBLE;
                    }
                    case 2: 
                    case 3: {
                        return Type.getType(type.typeCode, null, null, type.precision * 2L, type.scale);
                    }
                    case 102: 
                    case 106: {
                        return IntervalType.newIntervalType(type.typeCode, 9L, type.scale);
                    }
                }
                throw Error.error(5563);
            }
            case 76: 
            case 77: {
                if (type.isArrayType() || type.isLobType()) {
                    throw Error.error(5563);
                }
                return type;
            }
            case 79: 
            case 80: {
                if (!type.isBooleanType()) break;
                return Type.SQL_BOOLEAN;
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                if (!type.isNumberType()) break;
                return Type.SQL_DOUBLE;
            }
            case 99: {
                return type;
            }
            default: {
                throw Error.runtimeError(201, "ExpressionAggregate");
            }
        }
        throw Error.error(5563);
    }

    @Override
    boolean equals(Expression expression) {
        if (expression instanceof ExpressionAggregate) {
            ExpressionAggregate expressionAggregate = (ExpressionAggregate)expression;
            boolean bl = super.equals(expression) && this.isDistinctAggregate == expressionAggregate.isDistinctAggregate;
            return bl;
        }
        return false;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction) {
        if (!this.nodes[1].testCondition(session)) {
            return setFunction;
        }
        if (setFunction == null) {
            setFunction = this.getSetFunction(session);
        }
        Integer n = this.nodes[0].opType == 11 ? ValuePool.INTEGER_1 : this.nodes[0].getValue(session);
        setFunction.add(n);
        return setFunction;
    }

    @Override
    public SetFunction updateAggregatingValue(Session session, SetFunction setFunction, SetFunction setFunction2) {
        if (setFunction == null) {
            setFunction = this.getSetFunction(session);
        }
        setFunction.addGroup(setFunction2);
        return setFunction;
    }

    SetFunction getSetFunction(Session session) {
        return new SetFunctionValueAggregate(session, this.opType, this.nodes[0].dataType, this.dataType, this.isDistinctAggregate);
    }

    @Override
    public Object getAggregatedValue(Session session, SetFunction setFunction) {
        if (setFunction == null) {
            return this.opType == 74 ? Long.valueOf(0L) : null;
        }
        return setFunction.getValue();
    }

    @Override
    public Expression getCondition() {
        return this.nodes[1];
    }

    @Override
    public boolean hasCondition() {
        return !this.nodes[1].isTrue();
    }

    @Override
    public void setCondition(Expression expression) {
        this.nodes[1] = expression;
    }
}

