/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.regex.Pattern;
import org.traccar.BaseProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class StartekProtocolDecoder
extends BaseProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().text("&&").expression(".").number("d+,").number("(d+),").number("(xxx),").expression("(.+)").number("xx").text("\r\n").compile();
    private static final Pattern PATTERN_POSITION = new PatternBuilder().number("(d+),").expression("([^,]+)?,").number("(dd)(dd)(dd)").number("(dd)(dd)(dd),").expression("([AV]),").number("(-?d+.d+),").number("(-?d+.d+),").number("(d+),").number("(d+.d+),").number("(d+),").number("(d+),").number("(-?d+),").number("(d+),").number("(d+)|").number("(d+)|").number("(x+)|").number("(x+),").number("(d+),").number("(x+),").number("(x+),").number("(x+),").number("(x+)|").number("(x+)").expression("([^,]+)?").groupBegin().number(",d+").expression(",([^,]+)?").groupBegin().expression(",([^,]+)?").groupBegin().text(",").groupBegin().number("(d+)?|").number("(d+)?|").number("(d+)?|").number("(d+)?|").number("(d+)?|").number("(d+)?|").number("(d+)?|").number("(d+)?|").number("(d+)[%L]").optional().groupEnd("?").number(",(d+)").optional().groupEnd("?").groupEnd("?").groupEnd("?").any().compile();

    public StartekProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private String decodeAlarm(int value) {
        switch (value) {
            case 1: {
                return "sos";
            }
            case 5: 
            case 6: {
                return "door";
            }
            case 17: {
                return "lowPower";
            }
            case 18: {
                return "powerCut";
            }
            case 19: {
                return "powerRestored";
            }
            case 39: {
                return "hardAcceleration";
            }
            case 40: {
                return "hardBraking";
            }
            case 41: {
                return "hardCornering";
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        Parser parser = new Parser(PATTERN, (String)msg);
        if (!parser.matches()) {
            return null;
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, parser.next());
        if (deviceSession == null) {
            return null;
        }
        String type = parser.next();
        String content = parser.next();
        switch (type) {
            case "000": {
                return this.decodePosition(deviceSession, content);
            }
            case "710": {
                return this.decodeSerial(deviceSession, content);
            }
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        position.set("type", type);
        position.set("result", content);
        return position;
    }

    private Object decodePosition(DeviceSession deviceSession, String content) {
        int value;
        int index;
        Parser parser = new Parser(PATTERN_POSITION, content);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        int event = parser.nextInt();
        String eventData = parser.next();
        position.set("event", event);
        if (event == 53) {
            position.set("driverUniqueId", eventData);
        } else {
            position.set("alarm", this.decodeAlarm(event));
        }
        position.setTime(parser.nextDateTime());
        position.setValid(parser.next().equals("A"));
        position.setLatitude(parser.nextDouble());
        position.setLongitude(parser.nextDouble());
        position.set("sat", parser.nextInt());
        position.set("hdop", parser.nextDouble());
        position.setSpeed(UnitsConverter.knotsFromKph(parser.nextInt().intValue()));
        position.setCourse(parser.nextInt().intValue());
        position.setAltitude(parser.nextInt().intValue());
        position.set("odometer", parser.nextLong());
        position.setNetwork(new Network(CellTower.from(parser.nextInt(), parser.nextInt(), parser.nextHexInt(), parser.nextHexInt().intValue(), parser.nextInt())));
        position.set("status", parser.nextHexInt());
        int input = parser.nextHexInt();
        int output = parser.nextHexInt();
        position.set("ignition", BitUtil.check(input, 1));
        position.set("door", BitUtil.check(input, 2));
        position.set("input", input);
        position.set("output", output);
        position.set("power", (double)parser.nextHexInt().intValue() * 0.01);
        position.set("battery", (double)parser.nextHexInt().intValue() * 0.01);
        if (parser.hasNext()) {
            String[] adc = parser.next().split("\\|");
            for (int i = 1; i < adc.length; ++i) {
                position.set("adc" + (i + 1), (double)Integer.parseInt(adc[i], 16) * 0.01);
            }
        }
        if (parser.hasNext()) {
            String[] fuels;
            for (String fuel : fuels = parser.next().split("\\|")) {
                index = Integer.parseInt(fuel.substring(0, 2));
                value = Integer.parseInt(fuel.substring(2), 16);
                position.set("fuel" + index, (double)value * 0.1);
            }
        }
        if (parser.hasNext()) {
            String[] temperatures;
            for (String temperature : temperatures = parser.next().split("\\|")) {
                index = Integer.parseInt(temperature.substring(0, 2));
                value = Integer.parseInt(temperature.substring(2), 16);
                double convertedValue = BitUtil.to(value, 15);
                if (BitUtil.check(value, 15)) {
                    convertedValue = -convertedValue;
                }
                position.set("temp" + index, convertedValue * 0.1);
            }
        }
        if (parser.hasNextAny(9)) {
            position.set("rpm", parser.nextInt());
            position.set("engineLoad", parser.nextInt());
            position.set("airFlow", parser.nextInt());
            position.set("airPressure", parser.nextInt());
            if (parser.hasNext()) {
                position.set("airTemp", parser.nextInt() - 40);
            }
            position.set("throttle", parser.nextInt());
            if (parser.hasNext()) {
                position.set("coolantTemp", parser.nextInt() - 40);
            }
            if (parser.hasNext()) {
                position.set("fuelConsumption", (double)parser.nextInt().intValue() * 0.1);
            }
            position.set("fuel", parser.nextInt());
        }
        if (parser.hasNext()) {
            position.set("hours", (long)parser.nextInt().intValue() * 1000L);
        }
        return position;
    }

    private Object decodeSerial(DeviceSession deviceSession, String content) {
        String[] frames;
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        this.getLastLocation(position, null);
        block8: for (String frame : frames = content.split("\r\n")) {
            String type;
            String[] values = frame.split(",");
            int index = 0;
            switch (type = values[index++]) {
                case "T1": {
                    int n = ++index;
                    ++index;
                    position.set("rpm", Double.parseDouble(values[n]));
                    int n2 = ++index;
                    ++index;
                    position.set("fuel", Double.parseDouble(values[n2]));
                    index += 4;
                    int n3 = ++index;
                    ++index;
                    position.set("coolantTemp", Integer.parseInt(values[n3]));
                    int n4 = ++index;
                    ++index;
                    position.set("torque", Integer.parseInt(values[n4]));
                    int n5 = ++index;
                    ++index;
                    position.set("power", Double.parseDouble(values[n5]));
                    int n6 = ++index;
                    ++index;
                    position.set("oilTemp", Double.parseDouble(values[n6]));
                    int n7 = ++index;
                    ++index;
                    position.set("throttle", Double.parseDouble(values[n7]));
                    ++index;
                    ++index;
                    ++index;
                    int n8 = ++index;
                    ++index;
                    position.set("oilPressure", Integer.parseInt(values[n8]));
                    ++index;
                    int n9 = ++index;
                    ++index;
                    int ignition = Integer.parseInt(values[n9]);
                    if (ignition < 2) {
                        position.set("ignition", ignition > 0);
                    }
                    int n10 = ++index;
                    ++index;
                    position.set("catalystLevel", Double.parseDouble(values[n10]));
                    ++index;
                    continue block8;
                }
                case "T2": {
                    position.set("odometer", Double.parseDouble(values[index++]) * 1000.0);
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    ++index;
                    int n = ++index;
                    ++index;
                    position.set("hours", Integer.parseInt(values[n]));
                    int n11 = ++index;
                    ++index;
                    position.set("fuelConsumption", Double.parseDouble(values[n11]));
                    int n12 = ++index;
                    ++index;
                    position.set("fuelUsed", Double.parseDouble(values[n12]));
                    ++index;
                    continue block8;
                }
            }
        }
        return position;
    }
}

