/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedList;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.Checksum;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class NavisProtocolDecoder
extends BaseProtocolDecoder {
    private static final int[] FLEX_FIELDS_SIZES = new int[]{4, 2, 4, 1, 1, 1, 1, 1, 4, 4, 4, 4, 4, 2, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 4, 4, 2, 2, 4, 2, 2, 2, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 2, 1, 4, 2, 2, 2, 2, 2, 1, 1, 1, 2, 4, 2, 1, 8, 2, 1, 16, 4, 2, 4, 37, 1, 1, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 6, 12, 24, 48, 1, 1, 1, 1, 4, 4, 1, 4, 2, 6, 2, 6, 2, 2, 2, 2, 2, 2, 2, 2, 1, 2, 2, 2, 1};
    private String prefix;
    private long deviceUniqueId;
    private long serverId;
    private int flexDataSize;
    private int flexBitFieldSize;
    private final byte[] flexBitField = new byte[16];
    public static final int F10 = 1;
    public static final int F20 = 2;
    public static final int F30 = 3;
    public static final int F40 = 4;
    public static final int F50 = 5;
    public static final int F51 = 21;
    public static final int F52 = 37;
    public static final int F60 = 6;

    public NavisProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    public int getFlexDataSize() {
        return this.flexDataSize;
    }

    private static boolean isFormat(int type, int ... types) {
        for (int i : types) {
            if (type != i) continue;
            return true;
        }
        return false;
    }

    private Position parseNtcbPosition(DeviceSession deviceSession, ByteBuf buf) {
        int i;
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        int format = buf.getUnsignedByte(buf.readerIndex()) == 0 ? buf.readUnsignedShortLE() : (int)buf.readUnsignedByte();
        position.set("format", format);
        position.set("index", buf.readUnsignedIntLE());
        position.set("event", buf.readUnsignedShortLE());
        buf.skipBytes(6);
        short armedStatus = buf.readUnsignedByte();
        if (NavisProtocolDecoder.isFormat(format, 1, 2, 3, 4, 5, 21, 37)) {
            position.set("armed", BitUtil.to(armedStatus, 7));
            if (BitUtil.check(armedStatus, 7)) {
                position.set("alarm", "general");
            }
        } else if (NavisProtocolDecoder.isFormat(format, 6)) {
            position.set("armed", BitUtil.check(armedStatus, 0));
            if (BitUtil.check(armedStatus, 1)) {
                position.set("alarm", "general");
            }
        }
        position.set("status", buf.readUnsignedByte());
        position.set("rssi", buf.readUnsignedByte());
        if (NavisProtocolDecoder.isFormat(format, 1, 2, 3)) {
            int n = buf.readUnsignedShortLE();
            position.set("output", n);
            for (i = 0; i < 16; ++i) {
                position.set("out" + (i + 1), BitUtil.check(n, i));
            }
        } else if (NavisProtocolDecoder.isFormat(format, 5, 21, 37)) {
            short s = buf.readUnsignedByte();
            position.set("output", BitUtil.to(s, 2));
            position.set("out1", BitUtil.check(s, 0));
            position.set("out2", BitUtil.check(s, 1));
            position.set("sat", BitUtil.from(s, 2));
        } else if (NavisProtocolDecoder.isFormat(format, 4, 6)) {
            short s = buf.readUnsignedByte();
            position.set("output", BitUtil.to(s, 4));
            for (i = 0; i < 4; ++i) {
                position.set("out" + (i + 1), BitUtil.check(s, i));
            }
        }
        if (NavisProtocolDecoder.isFormat(format, 1, 2, 3, 4)) {
            int n = buf.readUnsignedShortLE();
            position.set("input", n);
            if (!NavisProtocolDecoder.isFormat(format, 4)) {
                for (i = 0; i < 16; ++i) {
                    position.set("in" + (i + 1), BitUtil.check(n, i));
                }
            } else {
                position.set("in1", BitUtil.check(n, 0));
                position.set("in2", BitUtil.check(n, 1));
                position.set("in3", BitUtil.check(n, 2));
                position.set("in4", BitUtil.check(n, 3));
                position.set("in5", BitUtil.between(n, 4, 7));
                position.set("in6", BitUtil.between(n, 7, 10));
                position.set("in7", BitUtil.between(n, 10, 12));
                position.set("in8", BitUtil.between(n, 12, 14));
            }
        } else if (NavisProtocolDecoder.isFormat(format, 5, 21, 37, 6)) {
            short s = buf.readUnsignedByte();
            position.set("input", s);
            for (i = 0; i < 8; ++i) {
                position.set("in" + (i + 1), BitUtil.check(s, i));
            }
        }
        position.set("power", (double)buf.readUnsignedShortLE() * 0.001);
        position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
        if (NavisProtocolDecoder.isFormat(format, 1, 2, 3)) {
            position.set("temp1", buf.readShortLE());
        }
        if (NavisProtocolDecoder.isFormat(format, 1, 2, 5, 21, 37, 6)) {
            position.set("adc1", buf.readUnsignedShortLE());
            position.set("adc2", buf.readUnsignedShortLE());
        }
        if (NavisProtocolDecoder.isFormat(format, 6)) {
            position.set("adc3", buf.readUnsignedShortLE());
        }
        if (NavisProtocolDecoder.isFormat(format, 2, 5, 21, 37, 6)) {
            buf.readUnsignedIntLE();
            buf.readUnsignedIntLE();
        }
        if (NavisProtocolDecoder.isFormat(format, 6)) {
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            position.set("temp1", buf.readByte());
            position.set("temp2", buf.readByte());
            position.set("temp3", buf.readByte());
            position.set("temp4", buf.readByte());
            position.set("axleWeight", buf.readIntLE());
            position.set("rpm", buf.readUnsignedShortLE());
        }
        if (NavisProtocolDecoder.isFormat(format, 2, 5, 21, 37, 6)) {
            short s = buf.readUnsignedByte();
            position.setValid(BitUtil.check(s, 1));
            if (NavisProtocolDecoder.isFormat(format, 6)) {
                position.set("sat", BitUtil.from(s, 2));
            }
            DateBuilder dateBuilder = new DateBuilder().setTime(buf.readUnsignedByte(), buf.readUnsignedByte(), buf.readUnsignedByte()).setDateReverse(buf.readUnsignedByte(), buf.readUnsignedByte() + 1, buf.readUnsignedByte());
            position.setTime(dateBuilder.getDate());
            if (NavisProtocolDecoder.isFormat(format, 6)) {
                position.setLatitude((double)buf.readIntLE() / 600000.0);
                position.setLongitude((double)buf.readIntLE() / 600000.0);
                position.setAltitude((double)buf.readIntLE() * 0.1);
            } else {
                position.setLatitude((double)buf.readFloatLE() / Math.PI * 180.0);
                position.setLongitude((double)buf.readFloatLE() / Math.PI * 180.0);
            }
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readFloatLE()));
            position.setCourse(buf.readUnsignedShortLE());
            position.set("odometer", Float.valueOf(buf.readFloatLE() * 1000.0f));
            position.set("distance", Float.valueOf(buf.readFloatLE() * 1000.0f));
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
        }
        if (NavisProtocolDecoder.isFormat(format, 21, 37)) {
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
            buf.readUnsignedShortLE();
            buf.readByte();
            buf.readUnsignedShortLE();
        }
        if (NavisProtocolDecoder.isFormat(format, 4, 37)) {
            position.set("temp1", buf.readByte());
            position.set("temp2", buf.readByte());
            position.set("temp3", buf.readByte());
            position.set("temp4", buf.readByte());
        }
        return position;
    }

    private Object processNtcbSingle(DeviceSession deviceSession, Channel channel, ByteBuf buf) {
        Position position = this.parseNtcbPosition(deviceSession, buf);
        ByteBuf response = Unpooled.buffer((int)7);
        response.writeCharSequence((CharSequence)"*<T", StandardCharsets.US_ASCII);
        response.writeIntLE((int)position.getLong("index"));
        this.sendNtcbReply(channel, response);
        return position.getFixTime() != null ? position : null;
    }

    private Object processNtcbArray(DeviceSession deviceSession, Channel channel, ByteBuf buf) {
        LinkedList<Position> positions = new LinkedList<Position>();
        int count = buf.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            Position position = this.parseNtcbPosition(deviceSession, buf);
            if (position.getFixTime() == null) continue;
            positions.add(position);
        }
        ByteBuf response = Unpooled.buffer((int)7);
        response.writeCharSequence((CharSequence)"*<A", StandardCharsets.US_ASCII);
        response.writeByte(count);
        this.sendNtcbReply(channel, response);
        if (positions.isEmpty()) {
            return null;
        }
        return positions;
    }

    private boolean checkFlexBitfield(int index) {
        int byteIndex = Math.floorDiv(index, 8);
        int bitIndex = Math.floorMod(index, 8);
        return BitUtil.check(this.flexBitField[byteIndex], 7 - bitIndex);
    }

    private Position parseFlexPosition(DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        short status = 0;
        short input = 0;
        short output = 0;
        block29: for (int i = 0; i < this.flexBitFieldSize; ++i) {
            if (!this.checkFlexBitfield(i)) continue;
            switch (i) {
                case 0: {
                    position.set("index", buf.readUnsignedIntLE());
                    continue block29;
                }
                case 1: {
                    position.set("event", buf.readUnsignedShortLE());
                    continue block29;
                }
                case 3: {
                    short armedStatus = buf.readUnsignedByte();
                    position.set("armed", BitUtil.check(armedStatus, 0));
                    if (!BitUtil.check(armedStatus, 1)) continue block29;
                    position.set("alarm", "general");
                    continue block29;
                }
                case 4: {
                    status = buf.readUnsignedByte();
                    position.set("status", Integer.valueOf(status));
                    continue block29;
                }
                case 5: {
                    short status2 = buf.readUnsignedByte();
                    position.set("status", (short)(BitUtil.to(status, 8) | status2 << 8));
                    continue block29;
                }
                case 6: {
                    position.set("rssi", buf.readUnsignedByte());
                    continue block29;
                }
                case 7: {
                    short navSensorState = buf.readUnsignedByte();
                    position.setValid(BitUtil.check(navSensorState, 1));
                    position.set("sat", BitUtil.from(navSensorState, 2));
                    continue block29;
                }
                case 8: {
                    position.setTime(new DateBuilder(new Date(buf.readUnsignedIntLE() * 1000L)).getDate());
                    continue block29;
                }
                case 9: {
                    position.setLatitude((double)buf.readIntLE() / 600000.0);
                    continue block29;
                }
                case 10: {
                    position.setLongitude((double)buf.readIntLE() / 600000.0);
                    continue block29;
                }
                case 11: {
                    position.setAltitude((double)buf.readIntLE() * 0.1);
                    continue block29;
                }
                case 12: {
                    position.setSpeed(UnitsConverter.knotsFromKph(buf.readFloatLE()));
                    continue block29;
                }
                case 13: {
                    position.setCourse(buf.readUnsignedShortLE());
                    continue block29;
                }
                case 14: {
                    position.set("odometer", Float.valueOf(buf.readFloatLE() * 1000.0f));
                    continue block29;
                }
                case 15: {
                    position.set("distance", Float.valueOf(buf.readFloatLE() * 1000.0f));
                    continue block29;
                }
                case 18: {
                    position.set("power", (double)buf.readUnsignedShortLE() * 0.001);
                    continue block29;
                }
                case 19: {
                    position.set("battery", (double)buf.readUnsignedShortLE() * 0.001);
                    continue block29;
                }
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: {
                    position.set("adc" + (i - 19), buf.readUnsignedShortLE());
                    continue block29;
                }
                case 28: {
                    input = buf.readUnsignedByte();
                    position.set("input", input);
                    for (int k = 0; k < 8; ++k) {
                        position.set("in" + (k + 1), BitUtil.check(input, k));
                    }
                    continue block29;
                }
                case 29: {
                    int k;
                    short input2 = buf.readUnsignedByte();
                    position.set("input", (short)(BitUtil.to(input, 8) | input2 << 8));
                    for (k = 0; k < 8; ++k) {
                        position.set("in" + (k + 9), BitUtil.check(input2, k));
                    }
                    continue block29;
                }
                case 30: {
                    int k;
                    output = buf.readUnsignedByte();
                    position.set("output", output);
                    for (k = 0; k < 8; ++k) {
                        position.set("out" + (k + 1), BitUtil.check(output, k));
                    }
                    continue block29;
                }
                case 31: {
                    short output2 = buf.readUnsignedByte();
                    position.set("output", (short)(BitUtil.to(output, 8) | output2 << 8));
                    for (int k = 0; k < 8; ++k) {
                        position.set("out" + (k + 9), BitUtil.check(output2, k));
                    }
                    continue block29;
                }
                case 36: {
                    position.set("hours", buf.readUnsignedIntLE() * 1000L);
                    continue block29;
                }
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 51: {
                    position.set("temp" + (i - 43), buf.readByte());
                    continue block29;
                }
                case 68: {
                    position.set("can-speed", buf.readUnsignedByte());
                    continue block29;
                }
                case 69: {
                    int satVisible = 0;
                    for (int k = 0; k < 8; ++k) {
                        satVisible += buf.readUnsignedByte();
                    }
                    position.set("satVisible", satVisible);
                    continue block29;
                }
                case 70: {
                    position.set("hdop", (double)buf.readUnsignedByte() * 0.1);
                    position.set("pdop", (double)buf.readUnsignedByte() * 0.1);
                    continue block29;
                }
                default: {
                    if (i >= FLEX_FIELDS_SIZES.length) continue block29;
                    buf.skipBytes(FLEX_FIELDS_SIZES[i]);
                }
            }
        }
        return position;
    }

    private Position parseFlex20Position(DeviceSession deviceSession, ByteBuf buf) {
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        int length = buf.readUnsignedShort();
        if (length <= buf.readableBytes() && buf.readUnsignedByte() == 10) {
            buf.readUnsignedByte();
            position.set("index", buf.readUnsignedIntLE());
            position.set("event", buf.readUnsignedShortLE());
            buf.readUnsignedInt();
            short navSensorState = buf.readUnsignedByte();
            position.setValid(BitUtil.check(navSensorState, 1));
            position.set("sat", BitUtil.from(navSensorState, 2));
            position.setTime(new DateBuilder(new Date(buf.readUnsignedIntLE() * 1000L)).getDate());
            position.setLatitude((double)buf.readIntLE() / 600000.0);
            position.setLongitude((double)buf.readIntLE() / 600000.0);
            position.setAltitude((double)buf.readIntLE() * 0.1);
            position.setSpeed(UnitsConverter.knotsFromKph(buf.readFloatLE()));
            position.setCourse(buf.readUnsignedShortLE());
            position.set("odometer", Float.valueOf(buf.readFloatLE() * 1000.0f));
            buf.skipBytes(length - buf.readerIndex() - 1);
        }
        return position;
    }

    private Object processFlexSingle(FlexPositionParser parser, String flexHeader, DeviceSession deviceSession, Channel channel, ByteBuf buf) {
        if (!flexHeader.equals("~C")) {
            buf.readUnsignedInt();
        }
        Position position = parser.parsePosition(deviceSession, buf);
        ByteBuf response = Unpooled.buffer();
        response.writeCharSequence((CharSequence)flexHeader, StandardCharsets.US_ASCII);
        response.writeIntLE((int)position.getLong("index"));
        this.sendFlexReply(channel, response);
        return position.getFixTime() != null ? position : null;
    }

    private Object processFlexArray(FlexPositionParser parser, String flexHeader, DeviceSession deviceSession, Channel channel, ByteBuf buf) {
        LinkedList<Position> positions = new LinkedList<Position>();
        int count = buf.readUnsignedByte();
        for (int i = 0; i < count; ++i) {
            Position position = parser.parsePosition(deviceSession, buf);
            if (position.getFixTime() == null) continue;
            positions.add(position);
        }
        ByteBuf response = Unpooled.buffer();
        response.writeCharSequence((CharSequence)flexHeader, StandardCharsets.US_ASCII);
        response.writeByte(count);
        this.sendFlexReply(channel, response);
        return !positions.isEmpty() ? positions : null;
    }

    private Object processFlexNegotiation(Channel channel, ByteBuf buf) {
        if ((byte)buf.readUnsignedByte() != -80) {
            return null;
        }
        int flexProtocolVersion = buf.readUnsignedByte();
        int flexStructVersion = buf.readUnsignedByte();
        if (!(flexProtocolVersion != 10 && flexProtocolVersion != 20 || flexStructVersion != 10 && flexStructVersion != 20)) {
            this.flexBitFieldSize = buf.readUnsignedByte();
            if (this.flexBitFieldSize > 122) {
                return null;
            }
            buf.readBytes(this.flexBitField, 0, (int)Math.ceil((double)this.flexBitFieldSize / 8.0));
            this.flexDataSize = 0;
            for (int i = 0; i < this.flexBitFieldSize; ++i) {
                if (!this.checkFlexBitfield(i)) continue;
                this.flexDataSize += FLEX_FIELDS_SIZES[i];
            }
        } else {
            flexProtocolVersion = 20;
            flexStructVersion = 20;
        }
        ByteBuf response = Unpooled.buffer((int)9);
        response.writeCharSequence((CharSequence)"*<FLEX", StandardCharsets.US_ASCII);
        response.writeByte(176);
        response.writeByte(flexProtocolVersion);
        response.writeByte(flexStructVersion);
        this.sendNtcbReply(channel, response);
        return null;
    }

    private Object processHandshake(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        buf.readByte();
        if (this.getDeviceSession(channel, remoteAddress, buf.toString(StandardCharsets.US_ASCII)) != null) {
            this.sendNtcbReply(channel, Unpooled.copiedBuffer((CharSequence)"*<S", (Charset)StandardCharsets.US_ASCII));
        }
        return null;
    }

    private void sendNtcbReply(Channel channel, ByteBuf data) {
        if (channel != null) {
            ByteBuf header = Unpooled.buffer((int)16);
            header.writeCharSequence((CharSequence)this.prefix, StandardCharsets.US_ASCII);
            header.writeIntLE((int)this.deviceUniqueId);
            header.writeIntLE((int)this.serverId);
            header.writeShortLE(data.readableBytes());
            header.writeByte(Checksum.xor(data.nioBuffer()));
            header.writeByte(Checksum.xor(header.nioBuffer()));
            channel.writeAndFlush((Object)new NetworkMessage(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{header, data}), channel.remoteAddress()));
        }
    }

    private void sendFlexReply(Channel channel, ByteBuf data) {
        if (channel != null) {
            data.writeByte(Checksum.crc8(Checksum.CRC8_EGTS, data.nioBuffer()));
            channel.writeAndFlush((Object)new NetworkMessage(data, channel.remoteAddress()));
        }
    }

    private Object decodeNtcb(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        this.prefix = buf.toString(buf.readerIndex(), 4, StandardCharsets.US_ASCII);
        buf.skipBytes(this.prefix.length());
        this.serverId = buf.readUnsignedIntLE();
        this.deviceUniqueId = buf.readUnsignedIntLE();
        int length = buf.readUnsignedShortLE();
        buf.skipBytes(2);
        if (length == 0) {
            return null;
        }
        String type = buf.toString(buf.readerIndex(), 3, StandardCharsets.US_ASCII);
        buf.skipBytes(type.length());
        if (type.equals("*>S")) {
            return this.processHandshake(channel, remoteAddress, buf);
        }
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession != null) {
            switch (type) {
                case "*>A": {
                    return this.processNtcbArray(deviceSession, channel, buf);
                }
                case "*>T": {
                    return this.processNtcbSingle(deviceSession, channel, buf);
                }
                case "*>F": {
                    buf.skipBytes(3);
                    return this.processFlexNegotiation(channel, buf);
                }
            }
        }
        return null;
    }

    private Object decodeFlex(Channel channel, SocketAddress remoteAddress, ByteBuf buf) {
        if (buf.getByte(buf.readerIndex()) == 127) {
            return null;
        }
        String type = buf.toString(buf.readerIndex(), 2, StandardCharsets.US_ASCII);
        buf.skipBytes(type.length());
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, new String[0]);
        if (deviceSession != null) {
            switch (type) {
                case "~A": {
                    return this.processFlexArray(this::parseFlexPosition, type, deviceSession, channel, buf);
                }
                case "~T": 
                case "~C": {
                    return this.processFlexSingle(this::parseFlexPosition, type, deviceSession, channel, buf);
                }
                case "~E": {
                    return this.processFlexArray(this::parseFlex20Position, type, deviceSession, channel, buf);
                }
                case "~X": {
                    return this.processFlexSingle(this::parseFlex20Position, type, deviceSession, channel, buf);
                }
            }
        }
        return null;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        if (this.flexDataSize > 0) {
            return this.decodeFlex(channel, remoteAddress, buf);
        }
        return this.decodeNtcb(channel, remoteAddress, buf);
    }

    private static interface FlexPositionParser {
        public Position parsePosition(DeviceSession var1, ByteBuf var2);
    }
}

