/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.plugins;

import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginEnabler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.settingsSync.plugins.PluginManagerProxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b&\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0016\u0010\u0018\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0006H$J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u0006H\u0016R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/intellij/settingsSync/plugins/AbstractPluginManagerProxy;", "Lcom/intellij/settingsSync/plugins/PluginManagerProxy;", "()V", "_essentialPlugins", "Lkotlin/Lazy;", "", "Lcom/intellij/openapi/extensions/PluginId;", "essentialPlugins", "getEssentialPlugins", "()Ljava/util/Set;", "pluginEnabler", "Lcom/intellij/ide/plugins/PluginEnabler;", "getPluginEnabler", "()Lcom/intellij/ide/plugins/PluginEnabler;", "addAllDependenciesRecursively", "", "", "descriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "depth", "", "disablePlugins", "", "plugins", "enablePlugins", "getEffectiveEssentialPlugins", "isDescriptorEssential", "pluginId", "isEssential", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nAbstractPluginManagerProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPluginManagerProxy.kt\ncom/intellij/settingsSync/plugins/AbstractPluginManagerProxy\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,73:1\n766#2:74\n857#2,2:75\n3792#3:77\n4307#3,2:78\n10#4:80\n*S KotlinDebug\n*F\n+ 1 AbstractPluginManagerProxy.kt\ncom/intellij/settingsSync/plugins/AbstractPluginManagerProxy\n*L\n33#1:74\n33#1:75,2\n44#1:77\n44#1:78,2\n71#1:80\n*E\n"})
public abstract class AbstractPluginManagerProxy
implements PluginManagerProxy {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy<Set<PluginId>> _essentialPlugins = LazyKt.lazy((Function0)((Function0)new Function0<Set<? extends PluginId>>(this){
        final /* synthetic */ AbstractPluginManagerProxy this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        @NotNull
        public final Set<PluginId> invoke() {
            return AbstractPluginManagerProxy.access$getEffectiveEssentialPlugins(this.this$0);
        }
    }));
    @NotNull
    private static final Logger LOG;

    private final Set<PluginId> getEssentialPlugins() {
        return (Set)this._essentialPlugins.getValue();
    }

    @Override
    public boolean isEssential(@NotNull PluginId pluginId) {
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        return this.getEssentialPlugins().contains(pluginId);
    }

    @NotNull
    protected abstract PluginEnabler getPluginEnabler();

    protected abstract boolean isDescriptorEssential(@NotNull PluginId var1);

    @Override
    public boolean enablePlugins(@NotNull Set<PluginId> plugins) {
        Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
        if (plugins.isEmpty()) {
            return true;
        }
        return this.getPluginEnabler().enableById(plugins);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean disablePlugins(@NotNull Set<PluginId> plugins) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(plugins, (String)"plugins");
        if (plugins.isEmpty()) {
            return true;
        }
        Iterable $this$filter$iv = plugins;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PluginId it = (PluginId)element$iv$iv;
            boolean bl = false;
            if (!this.isEssential(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set essentials2disable = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!((Collection)essentials2disable).isEmpty()) {
            LOG.info("Won't disable essential (or effectively essential) plugins: " + essentials2disable);
        }
        Set nonessentialPlugins = SetsKt.minus(plugins, (Iterable)essentials2disable);
        return this.getPluginEnabler().disableById(nonessentialPlugins);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<PluginId> getEffectiveEssentialPlugins() {
        void $this$filterTo$iv$iv;
        HashSet essentialPlugins = new HashSet();
        IdeaPluginDescriptor[] $this$filter$iv = this.getPlugins();
        boolean $i$f$filter = false;
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        int n = ((void)$this$filterTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = $this$filterTo$iv$iv[i];
            boolean bl = false;
            PluginId pluginId = it.getPluginId();
            Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
            if (!this.isDescriptorEssential(pluginId)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredPlugins = (List)destination$iv$iv;
        for (IdeaPluginDescriptor pluginDescriptor : filteredPlugins) {
            this.addAllDependenciesRecursively(essentialPlugins, pluginDescriptor, 1);
        }
        return essentialPlugins;
    }

    private final void addAllDependenciesRecursively(Set<PluginId> essentialPlugins, IdeaPluginDescriptor descriptor, int depth) {
        if (depth > 6) {
            LOG.warn("getAllDependenciesRecursively is called with depth > 6");
            return;
        }
        PluginId pluginId = descriptor.getPluginId();
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getPluginId(...)");
        if (!essentialPlugins.add(pluginId)) {
            return;
        }
        for (IdeaPluginDependency dependency : descriptor.getDependencies()) {
            IdeaPluginDescriptor depPlugin;
            if (dependency.isOptional() || this.findPlugin(dependency.getPluginId()) == null) continue;
            this.addAllDependenciesRecursively(essentialPlugins, depPlugin, depth + 1);
        }
    }

    public static final /* synthetic */ Set access$getEffectiveEssentialPlugins(AbstractPluginManagerProxy $this) {
        return $this.getEffectiveEssentialPlugins();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(AbstractPluginManagerProxy.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/settingsSync/plugins/AbstractPluginManagerProxy$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

