/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.codeWithMe.ClientId;
import com.intellij.configurationStore.ComponentStoreImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.settingsSync.CloudConfigServerCommunicator;
import com.intellij.settingsSync.GitSettingsLog;
import com.intellij.settingsSync.SettingsSnapshot;
import com.intellij.settingsSync.SettingsSyncBridge;
import com.intellij.settingsSync.SettingsSyncIdeMediator;
import com.intellij.settingsSync.SettingsSyncIdeMediatorImpl;
import com.intellij.settingsSync.SettingsSyncMain;
import com.intellij.settingsSync.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.SettingsSyncUpdateChecker;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.ui.JBAccountInfoService;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\t\u001a\u00020\bH\u0016J\r\u0010\n\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain;", "Lcom/intellij/openapi/Disposable;", "()V", "controls", "Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "getControls", "()Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "disableSyncing", "", "dispose", "getRemoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "getRemoteCommunicator$intellij_settingsSync", "Companion", "SettingsSyncControls", "intellij.settingsSync"})
@ApiStatus.Internal
public final class SettingsSyncMain
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SettingsSyncControls controls;

    public SettingsSyncMain() {
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        Path appConfigPath = path;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application));
        Intrinsics.checkNotNull((Object)iComponentStore, (String)"null cannot be cast to non-null type com.intellij.configurationStore.ComponentStoreImpl");
        ComponentStoreImpl componentStore = (ComponentStoreImpl)iComponentStore;
        SettingsSyncIdeMediatorImpl ideMediator2 = new SettingsSyncIdeMediatorImpl(componentStore, appConfigPath, (Function0<Boolean>)((Function0)ideMediator.1.INSTANCE));
        Disposable disposable = this;
        Path path2 = appConfigPath.resolve("settingsSync");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        this.controls = Companion.init$intellij_settingsSync(disposable, path2, appConfigPath, new CloudConfigServerCommunicator(null, 1, null), ideMediator2);
    }

    @NotNull
    public final SettingsSyncControls getControls() {
        return this.controls;
    }

    public void dispose() {
    }

    @NotNull
    public final SettingsSyncRemoteCommunicator getRemoteCommunicator$intellij_settingsSync() {
        return this.controls.getRemoteCommunicator();
    }

    public final void disableSyncing() {
        this.controls.getIdeMediator().removeStreamProvider();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004J5\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain$Companion;", "", "()V", "getInstance", "Lcom/intellij/settingsSync/SettingsSyncMain;", "init", "Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "settingsSyncStorage", "Ljava/nio/file/Path;", "appConfigPath", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "ideMediator", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "init$intellij_settingsSync", "isAvailable", "", "intellij.settingsSync"})
    @SourceDebugExtension(value={"SMAP\nSettingsSyncMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncMain.kt\ncom/intellij/settingsSync/SettingsSyncMain$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,82:1\n49#2:83\n43#3,3:84\n*S KotlinDebug\n*F\n+ 1 SettingsSyncMain.kt\ncom/intellij/settingsSync/SettingsSyncMain$Companion\n*L\n54#1:83\n57#1:84,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isAvailable() {
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
            ComponentManager $this$serviceIfCreated$iv = (ComponentManager)application;
            boolean $i$f$serviceIfCreated = false;
            return $this$serviceIfCreated$iv.getServiceIfCreated(SettingsSyncMain.class) != null;
        }

        @NotNull
        public final SettingsSyncMain getInstance() {
            boolean $i$f$service = false;
            Class<SettingsSyncMain> serviceClass$iv = SettingsSyncMain.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (SettingsSyncMain)object;
        }

        @NotNull
        public final SettingsSyncControls init$intellij_settingsSync(@NotNull Disposable parentDisposable, @NotNull Path settingsSyncStorage, @NotNull Path appConfigPath, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator, @NotNull SettingsSyncIdeMediator ideMediator2) {
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            Intrinsics.checkNotNullParameter((Object)appConfigPath, (String)"appConfigPath");
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)ideMediator2, (String)"ideMediator");
            GitSettingsLog settingsLog2 = new GitSettingsLog(settingsSyncStorage, appConfigPath, parentDisposable, (Function0<JBAccountInfoService.JBAData>)((Function0)new Function0<JBAccountInfoService.JBAData>((Object)SettingsSyncAuthService.Companion.getInstance()){

                @Nullable
                public final JBAccountInfoService.JBAData invoke() {
                    return ((SettingsSyncAuthService)this.receiver).getUserData();
                }
            }), (Function1<? super SettingsSnapshot, SettingsSnapshot>)((Function1)new Function1<SettingsSnapshot, SettingsSnapshot>(ideMediator2, appConfigPath){
                final /* synthetic */ SettingsSyncIdeMediator $ideMediator;
                final /* synthetic */ Path $appConfigPath;
                {
                    this.$ideMediator = $ideMediator;
                    this.$appConfigPath = $appConfigPath;
                    super(1);
                }

                @NotNull
                public final SettingsSnapshot invoke(@NotNull SettingsSnapshot currentSnapshot) {
                    Intrinsics.checkNotNullParameter((Object)currentSnapshot, (String)"currentSnapshot");
                    return this.$ideMediator.getInitialSnapshot(this.$appConfigPath, currentSnapshot);
                }
            }));
            SettingsSyncUpdateChecker updateChecker = new SettingsSyncUpdateChecker(remoteCommunicator);
            SettingsSyncBridge bridge = new SettingsSyncBridge(parentDisposable, appConfigPath, settingsLog2, ideMediator2, remoteCommunicator, updateChecker);
            return new SettingsSyncControls(ideMediator2, updateChecker, bridge, remoteCommunicator, settingsSyncStorage);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/settingsSync/SettingsSyncMain$SettingsSyncControls;", "", "ideMediator", "Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "updateChecker", "Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "bridge", "Lcom/intellij/settingsSync/SettingsSyncBridge;", "remoteCommunicator", "Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "settingsSyncStorage", "Ljava/nio/file/Path;", "(Lcom/intellij/settingsSync/SettingsSyncIdeMediator;Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;Lcom/intellij/settingsSync/SettingsSyncBridge;Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;Ljava/nio/file/Path;)V", "getBridge", "()Lcom/intellij/settingsSync/SettingsSyncBridge;", "getIdeMediator", "()Lcom/intellij/settingsSync/SettingsSyncIdeMediator;", "getRemoteCommunicator", "()Lcom/intellij/settingsSync/SettingsSyncRemoteCommunicator;", "getSettingsSyncStorage", "()Ljava/nio/file/Path;", "getUpdateChecker", "()Lcom/intellij/settingsSync/SettingsSyncUpdateChecker;", "intellij.settingsSync"})
    public static final class SettingsSyncControls {
        @NotNull
        private final SettingsSyncIdeMediator ideMediator;
        @NotNull
        private final SettingsSyncUpdateChecker updateChecker;
        @NotNull
        private final SettingsSyncBridge bridge;
        @NotNull
        private final SettingsSyncRemoteCommunicator remoteCommunicator;
        @NotNull
        private final Path settingsSyncStorage;

        public SettingsSyncControls(@NotNull SettingsSyncIdeMediator ideMediator2, @NotNull SettingsSyncUpdateChecker updateChecker, @NotNull SettingsSyncBridge bridge, @NotNull SettingsSyncRemoteCommunicator remoteCommunicator, @NotNull Path settingsSyncStorage) {
            Intrinsics.checkNotNullParameter((Object)ideMediator2, (String)"ideMediator");
            Intrinsics.checkNotNullParameter((Object)updateChecker, (String)"updateChecker");
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)settingsSyncStorage, (String)"settingsSyncStorage");
            this.ideMediator = ideMediator2;
            this.updateChecker = updateChecker;
            this.bridge = bridge;
            this.remoteCommunicator = remoteCommunicator;
            this.settingsSyncStorage = settingsSyncStorage;
        }

        @NotNull
        public final SettingsSyncIdeMediator getIdeMediator() {
            return this.ideMediator;
        }

        @NotNull
        public final SettingsSyncUpdateChecker getUpdateChecker() {
            return this.updateChecker;
        }

        @NotNull
        public final SettingsSyncBridge getBridge() {
            return this.bridge;
        }

        @NotNull
        public final SettingsSyncRemoteCommunicator getRemoteCommunicator() {
            return this.remoteCommunicator;
        }

        @NotNull
        public final Path getSettingsSyncStorage() {
            return this.settingsSyncStorage;
        }
    }
}

