/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.backend.common.Mapping;
import org.jetbrains.kotlin.backend.common.MappingsKt;
import org.jetbrains.kotlin.backend.common.lower.InnerClassesSupport;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.backend.js.JsMapping;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.Namer;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0002J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\tH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport;", "Lorg/jetbrains/kotlin/backend/common/lower/InnerClassesSupport;", "mapping", "Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;", "irFactory", "Lorg/jetbrains/kotlin/ir/declarations/IrFactory;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsMapping;Lorg/jetbrains/kotlin/ir/declarations/IrFactory;)V", "innerClassConstructors", "Lorg/jetbrains/kotlin/backend/common/Mapping$Delegate;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "originalInnerClassPrimaryConstructorByClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "outerThisFieldSymbols", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "createInnerClassConstructorWithOuterThisParameter", "oldConstructor", "getInnerClassConstructorWithOuterThisParameter", "innerClassConstructor", "getInnerClassOriginalPrimaryConstructorOrNull", "innerClass", "getOuterThisField", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsInnerClassesSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsInnerClassesSupport.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n*L\n1#1,106:1\n1#2:107\n282#3,4:108\n344#3,4:112\n*S KotlinDebug\n*F\n+ 1 JsInnerClassesSupport.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsInnerClassesSupport\n*L\n80#1:108,4\n90#1:112,4\n*E\n"})
public final class JsInnerClassesSupport
implements InnerClassesSupport {
    @NotNull
    private final IrFactory irFactory;
    @NotNull
    private final Mapping.Delegate<IrClass, IrField> outerThisFieldSymbols;
    @NotNull
    private final Mapping.Delegate<IrConstructor, IrConstructor> innerClassConstructors;
    @NotNull
    private final Mapping.Delegate<IrClass, IrConstructor> originalInnerClassPrimaryConstructorByClass;

    public JsInnerClassesSupport(@NotNull JsMapping mapping2, @NotNull IrFactory irFactory) {
        Intrinsics.checkNotNullParameter((Object)((Object)mapping2), (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)irFactory, (String)"irFactory");
        this.irFactory = irFactory;
        this.outerThisFieldSymbols = mapping2.getOuterThisFieldSymbols();
        this.innerClassConstructors = mapping2.getInnerClassConstructors();
        this.originalInnerClassPrimaryConstructorByClass = mapping2.getOriginalInnerClassPrimaryConstructorByClass();
    }

    @NotNull
    public IrField getOuterThisField(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        if (!innerClass.isInner()) {
            CompilationExceptionKt.compilationException((String)"Class is not inner", (IrDeclaration)((IrDeclaration)innerClass));
            throw null;
        }
        return (IrField)MappingsKt.getOrPut(this.outerThisFieldSymbols, (IrDeclaration)((IrDeclaration)innerClass), (Function0)((Function0)new Function0<IrField>(innerClass, this){
            final /* synthetic */ IrClass $innerClass;
            final /* synthetic */ JsInnerClassesSupport this$0;
            {
                this.$innerClass = $innerClass;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final IrField invoke() {
                IrDeclarationParent irDeclarationParent = this.$innerClass.getParent();
                IrClass irClass = irDeclarationParent instanceof IrClass ? (IrClass)irDeclarationParent : null;
                if (irClass == null) {
                    CompilationExceptionKt.compilationException((String)"No containing class for inner class", (IrDeclaration)((IrDeclaration)this.$innerClass));
                    throw null;
                }
                IrClass outerClass = irClass;
                IrFactory $this$buildField$iv = JsInnerClassesSupport.access$getIrFactory$p(this.this$0);
                boolean $i$f$buildField = false;
                IrFieldBuilder $this$buildField_u24lambda_u244$iv = new IrFieldBuilder();
                boolean bl = false;
                IrFieldBuilder $this$invoke_u24lambda_u240 = $this$buildField_u24lambda_u244$iv;
                boolean bl2 = false;
                $this$invoke_u24lambda_u240.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.FIELD_FOR_OUTER_THIS.INSTANCE);
                Name name2 = Name.identifier((String)Namer.INSTANCE.getSYNTHETIC_RECEIVER_NAME());
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
                $this$invoke_u24lambda_u240.setName(name2);
                $this$invoke_u24lambda_u240.setType((IrType)IrUtilsKt.getDefaultType((IrClass)outerClass));
                DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PROTECTED;
                Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"PROTECTED");
                $this$invoke_u24lambda_u240.setVisibility(descriptorVisibility);
                $this$invoke_u24lambda_u240.setFinal(true);
                $this$invoke_u24lambda_u240.setExternal(false);
                $this$invoke_u24lambda_u240.setStatic(false);
                IrField irField = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv);
                IrClass irClass2 = this.$innerClass;
                IrField it = irField;
                boolean bl3 = false;
                it.setParent((IrDeclarationParent)irClass2);
                return irField;
            }
        }));
    }

    @NotNull
    public IrConstructor getInnerClassConstructorWithOuterThisParameter(@NotNull IrConstructor innerClassConstructor) {
        Intrinsics.checkNotNullParameter((Object)innerClassConstructor, (String)"innerClassConstructor");
        IrDeclarationParent irDeclarationParent = innerClassConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass innerClass = (IrClass)irDeclarationParent;
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = false;
            String $i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22 = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)$i$a$-assert-JsInnerClassesSupport$getInnerClassConstructorWithOuterThisParameter$22);
        }
        Object object = MappingsKt.getOrPut(this.innerClassConstructors, (IrDeclaration)((IrDeclaration)innerClassConstructor), (Function0)((Function0)new Function0<IrConstructor>(this, innerClassConstructor){
            final /* synthetic */ JsInnerClassesSupport this$0;
            final /* synthetic */ IrConstructor $innerClassConstructor;
            {
                this.this$0 = $receiver;
                this.$innerClassConstructor = $innerClassConstructor;
                super(0);
            }

            @NotNull
            public final IrConstructor invoke() {
                return JsInnerClassesSupport.access$createInnerClassConstructorWithOuterThisParameter(this.this$0, this.$innerClassConstructor);
            }
        }));
        IrConstructor it = (IrConstructor)object;
        boolean bl2 = false;
        if (innerClassConstructor.isPrimary()) {
            this.originalInnerClassPrimaryConstructorByClass.set((IrDeclaration)innerClass, (Object)innerClassConstructor);
        }
        return (IrConstructor)object;
    }

    @Nullable
    public IrConstructor getInnerClassOriginalPrimaryConstructorOrNull(@NotNull IrClass innerClass) {
        Intrinsics.checkNotNullParameter((Object)innerClass, (String)"innerClass");
        boolean bl = innerClass.isInner();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Class is not inner: " + innerClass;
            throw new AssertionError((Object)string2);
        }
        return (IrConstructor)this.originalInnerClassPrimaryConstructorByClass.get((IrDeclaration)innerClass);
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor createInnerClassConstructorWithOuterThisParameter(IrConstructor oldConstructor) {
        void $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u245;
        IrDeclarationParent irDeclarationParent = oldConstructor.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass irClass = (IrClass)irDeclarationParent;
        IrDeclarationParent irDeclarationParent2 = irClass.getParent();
        Intrinsics.checkNotNull((Object)irDeclarationParent2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrSimpleType outerThisType = IrUtilsKt.getDefaultType((IrClass)((IrClass)irDeclarationParent2));
        IrFactory $this$buildConstructor$iv = this.irFactory;
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u243 = $this$buildConstructor_u24lambda_u2424$iv;
        boolean $i$a$-buildConstructor-JsInnerClassesSupport$createInnerClassConstructorWithOuterThisParameter$newConstructor$22 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u243.updateFrom((IrFunction)oldConstructor);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u243.setReturnType(oldConstructor.getReturnType());
        IrFactory it = $this$buildConstructor$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2424$iv);
        boolean bl2 = false;
        it.setParent(oldConstructor.getParent());
        it.setAnnotations(oldConstructor.getAnnotations());
        IrFactory newConstructor = $this$buildConstructor$iv;
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)newConstructor), (IrTypeParametersContainer)((IrTypeParametersContainer)oldConstructor), null, null, (int)6, null);
        IrValueParameter[] irValueParameterArray = new IrValueParameter[1];
        boolean $i$f$buildValueParameter = false;
        IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2430$iv = new IrValueParameterBuilder();
        boolean bl3 = false;
        IrValueParameterBuilder $i$a$-buildConstructor-JsInnerClassesSupport$createInnerClassConstructorWithOuterThisParameter$newConstructor$22 = $this$buildValueParameter_u24lambda_u2430$iv;
        int n = 0;
        Object[] objectArray = irValueParameterArray;
        boolean bl4 = false;
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u245.setOrigin((IrDeclarationOrigin)JsIrBuilder.SYNTHESIZED_DECLARATION.INSTANCE);
        Name name2 = Name.identifier((String)Namer.INSTANCE.getOUTER_NAME());
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u245.setName(name2);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u245.setIndex(0);
        $this$createInnerClassConstructorWithOuterThisParameter_u24lambda_u245.setType((IrType)outerThisType);
        Unit unit = Unit.INSTANCE;
        objectArray[n] = DeclarationBuildersKt.buildValueParameter((IrFactory)((IrDeclaration)newConstructor).getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u2430$iv, (IrDeclarationParent)((IrDeclarationParent)((IrDeclaration)newConstructor)));
        List newValueParameters = CollectionsKt.mutableListOf((Object[])irValueParameterArray);
        for (IrValueParameter p : oldConstructor.getValueParameters()) {
            ((Collection)newValueParameters).add(IrUtilsKt.copyTo$default((IrValueParameter)p, (IrFunction)((IrFunction)newConstructor), null, (int)(p.getIndex() + 1), (int)0, (int)0, null, null, null, null, null, (boolean)false, (boolean)false, (boolean)false, (int)8186, null));
        }
        newConstructor.setValueParameters(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus((List)newConstructor.getValueParameters(), (List)newValueParameters));
        return newConstructor;
    }

    public static final /* synthetic */ IrFactory access$getIrFactory$p(JsInnerClassesSupport $this) {
        return $this.irFactory;
    }

    public static final /* synthetic */ IrConstructor access$createInnerClassConstructorWithOuterThisParameter(JsInnerClassesSupport $this, IrConstructor oldConstructor) {
        return $this.createInnerClassConstructorWithOuterThisParameter(oldConstructor);
    }
}

