/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilder;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.MavenComparableVersion;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformer;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002:\u0001\u001fB\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000f\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u000e\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformer;", "Lorg/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering$Data;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "apiVersion", "Lorg/jetbrains/kotlin/config/MavenComparableVersion;", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "isApiVersionIsAtLeast", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "isInInlineFunInKotlinRuntime", "currentFunction", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "visitBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "data", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitFunction", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Data", "backend.jvm.lower"})
public final class ApiVersionIsAtLeastEvaluationLowering
implements FileLoweringPass,
IrElementTransformer<Data> {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final MavenComparableVersion apiVersion;

    public ApiVersionIsAtLeastEvaluationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.apiVersion = this.context.getConfig().getLanguageVersionSettings().getApiVersion().getVersion();
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        irFile.accept((IrElementVisitor)this, (Object)new Data(null, false));
    }

    @NotNull
    public IrExpression visitBlock(@NotNull IrBlock expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return IrElementTransformer.DefaultImpls.visitBlock((IrElementTransformer)this, (IrBlock)expression2, (Object)Data.copy$default(data, null, data.isInsideInlinedBlock() || expression2 instanceof IrInlinedFunctionBlock, 1, null));
    }

    @NotNull
    public IrStatement visitFunction(@NotNull IrFunction declaration, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return IrElementTransformer.DefaultImpls.visitFunction((IrElementTransformer)this, (IrFunction)declaration, (Object)Data.copy$default(data, declaration, false, 2, null));
    }

    @NotNull
    public IrExpression visitCall(@NotNull IrCall expression2, @NotNull Data data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!data.isInsideInlinedBlock() || !this.isApiVersionIsAtLeast(expression2.getSymbol().getOwner()) || this.isInInlineFunInKotlinRuntime(data.getCurrentFunction())) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall((IrElementTransformer)this, (IrCall)expression2, (Object)data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        Integer n = JvmIrUtilsKt.getIntConstArgumentOrNull((IrMemberAccessExpression)expression2, 0);
        if (n == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall((IrElementTransformer)this, (IrCall)expression2, (Object)data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int epic = n;
        Integer n2 = JvmIrUtilsKt.getIntConstArgumentOrNull((IrMemberAccessExpression)expression2, 1);
        if (n2 == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall((IrElementTransformer)this, (IrCall)expression2, (Object)data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int major = n2;
        Integer n3 = JvmIrUtilsKt.getIntConstArgumentOrNull((IrMemberAccessExpression)expression2, 2);
        if (n3 == null) {
            IrElement irElement = IrElementTransformer.DefaultImpls.visitCall((IrElementTransformer)this, (IrCall)expression2, (Object)data);
            Intrinsics.checkNotNull((Object)irElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
            return (IrExpression)irElement;
        }
        int minor = n3;
        IrFunction currentFunction = data.getCurrentFunction();
        if (!(currentFunction != null)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        JvmIrBuilder builder2 = JvmIrBuilderKt.createJvmIrBuilder$default(this.context, (IrSymbol)currentFunction.getSymbol(), 0, 0, 6, null);
        MavenComparableVersion versionArgument = new MavenComparableVersion("" + epic + '.' + major + '.' + minor);
        return this.apiVersion.compareTo(versionArgument) >= 0 ? (IrExpression)ExpressionHelpersKt.irTrue((IrBuilderWithScope)builder2) : (IrExpression)ExpressionHelpersKt.irFalse((IrBuilderWithScope)builder2);
    }

    private final boolean isInInlineFunInKotlinRuntime(IrFunction currentFunction) {
        return currentFunction != null && currentFunction.isInline() && IrUtilsKt.getPackageFragment((IrDeclaration)((IrDeclaration)currentFunction)).getPackageFqName().startsWith(StandardNames.BUILT_INS_PACKAGE_NAME);
    }

    private final boolean isApiVersionIsAtLeast(IrFunction $this$isApiVersionIsAtLeast) {
        return Intrinsics.areEqual((Object)$this$isApiVersionIsAtLeast.getName().asString(), (Object)"apiVersionIsAtLeast") && Intrinsics.areEqual((Object)IrUtilsKt.getPackageFragment((IrDeclaration)((IrDeclaration)$this$isApiVersionIsAtLeast)).getPackageFqName(), (Object)StandardNames.KOTLIN_INTERNAL_FQ_NAME) && IrUtilsKt.isFacadeClass((IrDeclarationParent)$this$isApiVersionIsAtLeast.getParent()) && $this$isApiVersionIsAtLeast.getValueParameters().size() == 3 && IrTypePredicatesKt.isInt((IrType)((IrValueParameter)$this$isApiVersionIsAtLeast.getValueParameters().get(0)).getType()) && IrTypePredicatesKt.isInt((IrType)((IrValueParameter)$this$isApiVersionIsAtLeast.getValueParameters().get(1)).getType()) && IrTypePredicatesKt.isInt((IrType)((IrValueParameter)$this$isApiVersionIsAtLeast.getValueParameters().get(2)).getType()) && $this$isApiVersionIsAtLeast.getDispatchReceiverParameter() == null && $this$isApiVersionIsAtLeast.getExtensionReceiverParameter() == null;
    }

    @NotNull
    public IrStatement visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitAnonymousInitializer((IrElementTransformer)this, (IrAnonymousInitializer)declaration, (Object)data);
    }

    @NotNull
    public IrBody visitBlockBody(@NotNull IrBlockBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBlockBody((IrElementTransformer)this, (IrBlockBody)body2, (Object)data);
    }

    @NotNull
    public IrBody visitBody(@NotNull IrBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBody((IrElementTransformer)this, (IrBody)body2, (Object)data);
    }

    @NotNull
    public IrBranch visitBranch(@NotNull IrBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBranch((IrElementTransformer)this, (IrBranch)branch, (Object)data);
    }

    @NotNull
    public IrExpression visitBreak(@NotNull IrBreak jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreak((IrElementTransformer)this, (IrBreak)jump, (Object)data);
    }

    @NotNull
    public IrExpression visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitBreakContinue((IrElementTransformer)this, (IrBreakContinue)jump, (Object)data);
    }

    @NotNull
    public IrElement visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCallableReference((IrElementTransformer)this, expression2, (Object)data);
    }

    @NotNull
    public IrCatch visitCatch(@NotNull IrCatch aCatch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitCatch((IrElementTransformer)this, (IrCatch)aCatch, (Object)data);
    }

    @NotNull
    public IrStatement visitClass(@NotNull IrClass declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClass((IrElementTransformer)this, (IrClass)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitClassReference(@NotNull IrClassReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitClassReference((IrElementTransformer)this, (IrClassReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitComposite(@NotNull IrComposite expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitComposite((IrElementTransformer)this, (IrComposite)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitConst(@NotNull IrConst<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConst((IrElementTransformer)this, expression2, (Object)data);
    }

    @NotNull
    public IrConstantValue visitConstantArray(@NotNull IrConstantArray expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantArray((IrElementTransformer)this, (IrConstantArray)expression2, (Object)data);
    }

    @NotNull
    public IrConstantValue visitConstantObject(@NotNull IrConstantObject expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantObject((IrElementTransformer)this, (IrConstantObject)expression2, (Object)data);
    }

    @NotNull
    public IrConstantValue visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantPrimitive((IrElementTransformer)this, (IrConstantPrimitive)expression2, (Object)data);
    }

    @NotNull
    public IrConstantValue visitConstantValue(@NotNull IrConstantValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstantValue((IrElementTransformer)this, (IrConstantValue)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructor((IrElementTransformer)this, (IrConstructor)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitConstructorCall((IrElementTransformer)this, (IrConstructorCall)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContainerExpression((IrElementTransformer)this, (IrContainerExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitContinue(@NotNull IrContinue jump, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitContinue((IrElementTransformer)this, (IrContinue)jump, (Object)data);
    }

    @NotNull
    public IrStatement visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclaration((IrElementTransformer)this, (IrDeclarationBase)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDeclarationReference((IrElementTransformer)this, (IrDeclarationReference)expression2, (Object)data);
    }

    @NotNull
    public IrElement visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDelegatingConstructorCall((IrElementTransformer)this, (IrDelegatingConstructorCall)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDoWhileLoop((IrElementTransformer)this, (IrDoWhileLoop)loop, (Object)data);
    }

    @NotNull
    public IrExpression visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicExpression((IrElementTransformer)this, (IrDynamicExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicMemberExpression((IrElementTransformer)this, (IrDynamicMemberExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitDynamicOperatorExpression((IrElementTransformer)this, (IrDynamicOperatorExpression)expression2, (Object)data);
    }

    @NotNull
    public IrElement visitElement(@NotNull IrElement element, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElement((IrElementTransformer)this, (IrElement)element, (Object)data);
    }

    @NotNull
    public IrElseBranch visitElseBranch(@NotNull IrElseBranch branch, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitElseBranch((IrElementTransformer)this, (IrElseBranch)branch, (Object)data);
    }

    @NotNull
    public IrElement visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumConstructorCall((IrElementTransformer)this, (IrEnumConstructorCall)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitEnumEntry((IrElementTransformer)this, (IrEnumEntry)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorCallExpression((IrElementTransformer)this, (IrErrorCallExpression)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorDeclaration((IrElementTransformer)this, (IrErrorDeclaration)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitErrorExpression((IrElementTransformer)this, (IrErrorExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitExpression(@NotNull IrExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpression((IrElementTransformer)this, (IrExpression)expression2, (Object)data);
    }

    @NotNull
    public IrBody visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExpressionBody((IrElementTransformer)this, (IrExpressionBody)body2, (Object)data);
    }

    @NotNull
    public IrExternalPackageFragment visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitExternalPackageFragment((IrElementTransformer)this, (IrExternalPackageFragment)declaration, (Object)data);
    }

    @NotNull
    public IrStatement visitField(@NotNull IrField declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitField((IrElementTransformer)this, (IrField)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFieldAccess((IrElementTransformer)this, (IrFieldAccessExpression)expression2, (Object)data);
    }

    @NotNull
    public IrFile visitFile(@NotNull IrFile declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFile((IrElementTransformer)this, (IrFile)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionAccess((IrElementTransformer)this, (IrFunctionAccessExpression)expression2, (Object)data);
    }

    @NotNull
    public IrElement visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionExpression((IrElementTransformer)this, (IrFunctionExpression)expression2, (Object)data);
    }

    @NotNull
    public IrElement visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitFunctionReference((IrElementTransformer)this, (IrFunctionReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetClass(@NotNull IrGetClass expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetClass((IrElementTransformer)this, (IrGetClass)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetEnumValue((IrElementTransformer)this, (IrGetEnumValue)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetField(@NotNull IrGetField expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetField((IrElementTransformer)this, (IrGetField)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetObjectValue((IrElementTransformer)this, (IrGetObjectValue)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitGetValue((IrElementTransformer)this, (IrGetValue)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitInstanceInitializerCall((IrElementTransformer)this, (IrInstanceInitializerCall)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedProperty((IrElementTransformer)this, (IrLocalDelegatedProperty)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementTransformer)this, (IrLocalDelegatedPropertyReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitLoop(@NotNull IrLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitLoop((IrElementTransformer)this, (IrLoop)loop, (Object)data);
    }

    @NotNull
    public IrElement visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitMemberAccess((IrElementTransformer)this, expression2, (Object)data);
    }

    @NotNull
    public IrModuleFragment visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitModuleFragment((IrElementTransformer)this, (IrModuleFragment)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPackageFragment((IrElementTransformer)this, (IrPackageFragment)declaration, (Object)data);
    }

    @NotNull
    public IrStatement visitProperty(@NotNull IrProperty declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitProperty((IrElementTransformer)this, (IrProperty)declaration, (Object)data);
    }

    @NotNull
    public IrElement visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitPropertyReference((IrElementTransformer)this, (IrPropertyReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitRawFunctionReference((IrElementTransformer)this, (IrRawFunctionReference)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitReturn(@NotNull IrReturn expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitReturn((IrElementTransformer)this, (IrReturn)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitScript(@NotNull IrScript declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitScript((IrElementTransformer)this, (IrScript)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitSetField(@NotNull IrSetField expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetField((IrElementTransformer)this, (IrSetField)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSetValue((IrElementTransformer)this, (IrSetValue)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSimpleFunction((IrElementTransformer)this, (IrSimpleFunction)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSingletonReference((IrElementTransformer)this, (IrGetSingletonValue)expression2, (Object)data);
    }

    @NotNull
    public IrSpreadElement visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSpreadElement((IrElementTransformer)this, (IrSpreadElement)spread, (Object)data);
    }

    @NotNull
    public IrExpression visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitStringConcatenation((IrElementTransformer)this, (IrStringConcatenation)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspendableExpression((IrElementTransformer)this, (IrSuspendableExpression)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSuspensionPoint((IrElementTransformer)this, (IrSuspensionPoint)expression2, (Object)data);
    }

    @NotNull
    public IrBody visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitSyntheticBody((IrElementTransformer)this, (IrSyntheticBody)body2, (Object)data);
    }

    @NotNull
    public IrExpression visitThrow(@NotNull IrThrow expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitThrow((IrElementTransformer)this, (IrThrow)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitTry(@NotNull IrTry aTry, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTry((IrElementTransformer)this, (IrTry)aTry, (Object)data);
    }

    @NotNull
    public IrStatement visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeAlias((IrElementTransformer)this, (IrTypeAlias)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeOperator((IrElementTransformer)this, (IrTypeOperatorCall)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitTypeParameter((IrElementTransformer)this, (IrTypeParameter)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueAccess((IrElementTransformer)this, (IrValueAccessExpression)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitValueParameter(@NotNull IrValueParameter declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitValueParameter((IrElementTransformer)this, (IrValueParameter)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitVararg(@NotNull IrVararg expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVararg((IrElementTransformer)this, (IrVararg)expression2, (Object)data);
    }

    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitVariable((IrElementTransformer)this, (IrVariable)declaration, (Object)data);
    }

    @NotNull
    public IrExpression visitWhen(@NotNull IrWhen expression2, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhen((IrElementTransformer)this, (IrWhen)expression2, (Object)data);
    }

    @NotNull
    public IrExpression visitWhileLoop(@NotNull IrWhileLoop loop, @NotNull Data data) {
        return IrElementTransformer.DefaultImpls.visitWhileLoop((IrElementTransformer)this, (IrWhileLoop)loop, (Object)data);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\f\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/ApiVersionIsAtLeastEvaluationLowering$Data;", "", "currentFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "isInsideInlinedBlock", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Z)V", "getCurrentFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "backend.jvm.lower"})
    public static final class Data {
        @Nullable
        private final IrFunction currentFunction;
        private final boolean isInsideInlinedBlock;

        public Data(@Nullable IrFunction currentFunction, boolean isInsideInlinedBlock) {
            this.currentFunction = currentFunction;
            this.isInsideInlinedBlock = isInsideInlinedBlock;
        }

        @Nullable
        public final IrFunction getCurrentFunction() {
            return this.currentFunction;
        }

        public final boolean isInsideInlinedBlock() {
            return this.isInsideInlinedBlock;
        }

        @Nullable
        public final IrFunction component1() {
            return this.currentFunction;
        }

        public final boolean component2() {
            return this.isInsideInlinedBlock;
        }

        @NotNull
        public final Data copy(@Nullable IrFunction currentFunction, boolean isInsideInlinedBlock) {
            return new Data(currentFunction, isInsideInlinedBlock);
        }

        public static /* synthetic */ Data copy$default(Data data, IrFunction irFunction, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                irFunction = data.currentFunction;
            }
            if ((n & 2) != 0) {
                bl = data.isInsideInlinedBlock;
            }
            return data.copy(irFunction, bl);
        }

        @NotNull
        public String toString() {
            return "Data(currentFunction=" + this.currentFunction + ", isInsideInlinedBlock=" + this.isInsideInlinedBlock + ')';
        }

        public int hashCode() {
            int result2 = this.currentFunction == null ? 0 : this.currentFunction.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isInsideInlinedBlock);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (!Intrinsics.areEqual((Object)this.currentFunction, (Object)data.currentFunction)) {
                return false;
            }
            return this.isInsideInlinedBlock == data.isInsideInlinedBlock;
        }
    }
}

