/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.signing.signatory.internal.pgp;

import java.util.Arrays;
import org.gradle.api.Project;
import org.gradle.plugins.signing.signatory.internal.ConfigurableSignatoryProvider;
import org.gradle.plugins.signing.signatory.pgp.PgpSignatory;
import org.gradle.security.internal.pgp.BaseInMemoryPgpSignatoryProvider;

public class InMemoryPgpSignatoryProvider
extends BaseInMemoryPgpSignatoryProvider
implements ConfigurableSignatoryProvider<PgpSignatory> {
    public InMemoryPgpSignatoryProvider(String defaultSecretKey, String defaultPassword) {
        super(defaultSecretKey, defaultPassword);
    }

    public InMemoryPgpSignatoryProvider(String defaultKeyId, String defaultSecretKey, String defaultPassword) {
        super(defaultKeyId, defaultSecretKey, defaultPassword);
    }

    @Override
    public void createSignatoryFor(Project project, String name, Object[] args) {
        String keyId = null;
        String secretKey2 = null;
        String password = null;
        switch (args.length) {
            case 2: {
                secretKey2 = args[0].toString();
                password = args[1].toString();
                break;
            }
            case 3: {
                keyId = args[0].toString();
                secretKey2 = args[1].toString();
                password = args[2].toString();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid args (" + name + ": " + Arrays.toString(args) + ")");
            }
        }
        this.addSignatory(name, keyId, secretKey2, password);
    }

    public PgpSignatory propertyMissing(String signatoryName) {
        return this.getSignatory(signatoryName);
    }
}

