/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugin.devel.plugins;

import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.XmlProvider;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublicationContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.plugin.devel.GradlePluginDevelopmentExtension;
import org.gradle.plugin.devel.PluginDeclaration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

abstract class MavenPluginPublishPlugin
implements Plugin<Project> {
    @Inject
    protected abstract ProviderFactory getProviderFactory();

    @Inject
    public MavenPluginPublishPlugin() {
    }

    @Override
    public void apply(Project project) {
        project.afterEvaluate((Action<? super Project>)new Action<Project>(){

            @Override
            public void execute(Project project) {
                MavenPluginPublishPlugin.this.configurePublishing(project);
            }
        });
    }

    private void configurePublishing(final Project project) {
        project.getExtensions().configure(PublishingExtension.class, new Action<PublishingExtension>(){

            @Override
            public void execute(PublishingExtension publishing) {
                GradlePluginDevelopmentExtension pluginDevelopment = project.getExtensions().getByType(GradlePluginDevelopmentExtension.class);
                if (!pluginDevelopment.isAutomatedPublishing()) {
                    return;
                }
                SoftwareComponent mainComponent = (SoftwareComponent)project.getComponents().getByName("java");
                MavenPublication mainPublication = MavenPluginPublishPlugin.this.addMainPublication(publishing, mainComponent);
                MavenPluginPublishPlugin.this.addMarkerPublications(mainPublication, publishing, pluginDevelopment);
            }
        });
    }

    private MavenPublication addMainPublication(PublishingExtension publishing, SoftwareComponent mainComponent) {
        MavenPublication publication = publishing.getPublications().maybeCreate("pluginMaven", MavenPublication.class);
        publication.from(mainComponent);
        return publication;
    }

    private void addMarkerPublications(MavenPublication mainPublication, PublishingExtension publishing, GradlePluginDevelopmentExtension pluginDevelopment) {
        for (PluginDeclaration declaration : pluginDevelopment.getPlugins()) {
            this.createMavenMarkerPublication(declaration, mainPublication, publishing.getPublications());
        }
    }

    private void createMavenMarkerPublication(PluginDeclaration declaration, MavenPublication coordinates, PublicationContainer publications) {
        String pluginId = declaration.getId();
        MavenPublicationInternal publication = (MavenPublicationInternal)publications.create(declaration.getName() + "PluginMarkerMaven", MavenPublication.class);
        publication.setAlias(true);
        publication.setArtifactId(pluginId + ".gradle.plugin");
        publication.setGroupId(pluginId);
        final Provider<String> groupProvider = this.getProviderFactory().provider(coordinates::getGroupId);
        final Provider<String> artifactIdProvider = this.getProviderFactory().provider(coordinates::getArtifactId);
        final Provider<String> versionProvider = this.getProviderFactory().provider(coordinates::getVersion);
        publication.getPom().withXml((Action<? super XmlProvider>)new Action<XmlProvider>(){

            @Override
            public void execute(XmlProvider xmlProvider) {
                Element root = xmlProvider.asElement();
                Document document = root.getOwnerDocument();
                Node dependencies = root.appendChild(document.createElement("dependencies"));
                Node dependency = dependencies.appendChild(document.createElement("dependency"));
                Node groupId = dependency.appendChild(document.createElement("groupId"));
                groupId.setTextContent((String)groupProvider.get());
                Node artifactId = dependency.appendChild(document.createElement("artifactId"));
                artifactId.setTextContent((String)artifactIdProvider.get());
                Node version = dependency.appendChild(document.createElement("version"));
                version.setTextContent((String)versionProvider.get());
            }
        });
        publication.getPom().getName().set(declaration.getDisplayName());
        publication.getPom().getDescription().set(declaration.getDescription());
    }
}

