/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.model.internal.registry;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.model.RuleSource;
import org.gradle.model.internal.core.ChainingModelProjection;
import org.gradle.model.internal.core.EmptyModelProjection;
import org.gradle.model.internal.core.ModelAction;
import org.gradle.model.internal.core.ModelActionRole;
import org.gradle.model.internal.core.ModelAdapter;
import org.gradle.model.internal.core.ModelNode;
import org.gradle.model.internal.core.ModelNodes;
import org.gradle.model.internal.core.ModelPath;
import org.gradle.model.internal.core.ModelProjection;
import org.gradle.model.internal.core.ModelPromise;
import org.gradle.model.internal.core.ModelRegistration;
import org.gradle.model.internal.core.ModelView;
import org.gradle.model.internal.core.MutableModelNode;
import org.gradle.model.internal.core.NodePredicate;
import org.gradle.model.internal.core.rule.describe.ModelRuleDescriptor;
import org.gradle.model.internal.inspect.ExtractedRuleSource;
import org.gradle.model.internal.registry.DefaultModelRegistry;
import org.gradle.model.internal.registry.ModelBinding;
import org.gradle.model.internal.registry.ModelRegistryInternal;
import org.gradle.model.internal.registry.RuleBinder;
import org.gradle.model.internal.type.ModelType;

abstract class ModelNodeInternal
implements MutableModelNode {
    protected final ModelRegistryInternal modelRegistry;
    private final ModelPath path;
    private final ModelRuleDescriptor descriptor;
    private Set<ModelNodeInternal> dependencies;
    private Set<ModelNodeInternal> dependents;
    private ModelNode.State state = ModelNode.State.Registered;
    private boolean hidden;
    private List<ModelRuleDescriptor> executedRules;
    private List<RuleBinder> registrationActionBinders;
    private List<ModelProjection> projections;

    public ModelNodeInternal(ModelRegistryInternal modelRegistry, ModelRegistration registration) {
        this.modelRegistry = modelRegistry;
        this.path = registration.getPath();
        this.descriptor = registration.getDescriptor();
        this.hidden = registration.isHidden();
    }

    public List<RuleBinder> getRegistrationActionBinders() {
        return this.registrationActionBinders == null ? Collections.emptyList() : this.registrationActionBinders;
    }

    public void addRegistrationActionBinder(RuleBinder binder) {
        if (this.registrationActionBinders == null) {
            this.registrationActionBinders = Lists.newArrayList();
        }
        this.registrationActionBinders.add(binder);
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public void notifyFired(RuleBinder binder) {
        assert (binder.isBound()) : "RuleBinder must be in a bound state";
        for (ModelBinding inputBinding : binder.getInputBindings()) {
            ModelNodeInternal node = inputBinding.getNode();
            if (this.dependencies == null) {
                this.dependencies = Sets.newHashSet();
            }
            this.dependencies.add(node);
            if (node.dependents == null) {
                node.dependents = Sets.newHashSet();
            }
            node.dependents.add(this);
        }
        if (this.executedRules == null) {
            this.executedRules = Lists.newArrayList();
        }
        this.executedRules.add(binder.getDescriptor());
    }

    public Iterable<? extends ModelNode> getDependencies() {
        return this.dependencies == null ? Collections.emptyList() : this.dependencies;
    }

    public Iterable<? extends ModelNode> getDependents() {
        return this.dependents == null ? Collections.emptyList() : this.dependents;
    }

    @Override
    public ModelPath getPath() {
        return this.path;
    }

    @Override
    public ModelRuleDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public ModelNode.State getState() {
        return this.state;
    }

    public void setState(ModelNode.State state) {
        this.state = state;
    }

    @Override
    public boolean isMutable() {
        return this.state.mutable;
    }

    @Override
    @Nullable
    public abstract ModelNodeInternal getLink(String var1);

    @Override
    public boolean canBeViewedAs(ModelType<?> type) {
        return this.getPromise().canBeViewedAs(type);
    }

    @Override
    public Iterable<String> getTypeDescriptions() {
        return this.getPromise().getTypeDescriptions(this);
    }

    private ModelProjection toProjection() {
        if (this.projections == null) {
            return EmptyModelProjection.INSTANCE;
        }
        return new ChainingModelProjection(this.projections);
    }

    public ModelPromise getPromise() {
        if (!this.state.isAtLeast(ModelNode.State.Discovered)) {
            throw new IllegalStateException(String.format("Cannot get promise for '%s' in state %s.", new Object[]{this.getPath(), this.state}));
        }
        return this.toProjection();
    }

    public ModelAdapter getAdapter() {
        if (!this.state.isAtLeast(ModelNode.State.Created)) {
            throw new IllegalStateException(String.format("Cannot get adapter for '%s' in state %s.", new Object[]{this.getPath(), this.state}));
        }
        return this.toProjection();
    }

    public ModelProjection getProjection() {
        return this.toProjection();
    }

    @Override
    public void addProjection(ModelProjection projection) {
        if (this.isAtLeast(ModelNode.State.Discovered)) {
            throw new IllegalStateException(String.format("Cannot add projections to '%s' as it is already in state %s.", new Object[]{this.getPath(), this.state}));
        }
        if (this.projections == null) {
            this.projections = Lists.newArrayList();
        }
        this.projections.add(projection);
    }

    public String toString() {
        return this.getPath().toString();
    }

    public abstract Iterable<? extends ModelNodeInternal> getLinks();

    @Override
    public boolean isAtLeast(ModelNode.State state) {
        return this.getState().compareTo(state) >= 0;
    }

    @Override
    public Optional<String> getValueDescription() {
        this.ensureUsable();
        return this.getAdapter().getValueDescription(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> getTypeDescription() {
        this.ensureUsable();
        ModelView<Object> modelView = this.getAdapter().asImmutable(ModelType.untyped(), this, null);
        if (modelView != null) {
            try {
                ModelType<Object> type = modelView.getType();
                if (type != null) {
                    Optional optional = Optional.of((Object)type.toString());
                    return optional;
                }
            }
            finally {
                modelView.close();
            }
        }
        return Optional.absent();
    }

    @Override
    public List<ModelRuleDescriptor> getExecutedRules() {
        return this.executedRules == null ? Collections.emptyList() : this.executedRules;
    }

    @Override
    public boolean hasLink(String name, ModelType<?> type) {
        return this.hasLink(name, ModelNodes.withType(type));
    }

    @Override
    public Iterable<? extends MutableModelNode> getLinks(ModelType<?> type) {
        return this.getLinks(ModelNodes.withType(type));
    }

    @Override
    public Set<String> getLinkNames(ModelType<?> type) {
        return this.getLinkNames(ModelNodes.withType(type));
    }

    @Override
    public void defineRulesForLink(ModelActionRole role, ModelAction action) {
        this.applyToLink(role, action);
    }

    @Override
    public void defineRulesFor(NodePredicate predicate, ModelActionRole role, ModelAction action) {
        this.applyTo(predicate, role, action);
    }

    @Override
    public void applyToSelf(ModelActionRole role, ModelAction action) {
        DefaultModelRegistry.checkNodePath(this, action);
        this.modelRegistry.bind(action.getSubject(), role, action);
    }

    @Override
    public void applyToSelf(ExtractedRuleSource<?> rules) {
        rules.apply(this.modelRegistry, this);
    }

    @Override
    public void applyToSelf(Class<? extends RuleSource> rulesClass) {
        ExtractedRuleSource<?> rules = this.modelRegistry.newRuleSource(rulesClass);
        rules.assertNoPlugins();
        rules.apply(this.modelRegistry, this);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

