/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.exec;

import javax.annotation.Nullable;
import org.gradle.tooling.internal.provider.serialization.SerializedPayload;

public class BuildActionResult {
    private final SerializedPayload result;
    private final SerializedPayload serializedFailure;
    private final RuntimeException failure;
    private final boolean wasCancelled;

    private BuildActionResult(SerializedPayload result2, SerializedPayload serializedFailure, RuntimeException failure, boolean wasCancelled) {
        this.result = result2;
        this.serializedFailure = serializedFailure;
        this.failure = failure;
        this.wasCancelled = wasCancelled;
    }

    public static BuildActionResult of(@Nullable SerializedPayload result2) {
        return new BuildActionResult(result2, null, null, false);
    }

    public static BuildActionResult failed(SerializedPayload failure) {
        return new BuildActionResult(null, failure, null, false);
    }

    public static BuildActionResult failed(RuntimeException failure) {
        return new BuildActionResult(null, null, failure, false);
    }

    public static BuildActionResult cancelled(SerializedPayload failure) {
        return new BuildActionResult(null, failure, null, true);
    }

    public static BuildActionResult cancelled(RuntimeException failure) {
        return new BuildActionResult(null, null, failure, true);
    }

    public static BuildActionResult failed(boolean wasCancelled, @Nullable SerializedPayload failure, @Nullable RuntimeException exception) {
        return new BuildActionResult(null, failure, exception, wasCancelled);
    }

    public boolean wasCancelled() {
        return this.wasCancelled;
    }

    @Nullable
    public SerializedPayload getResult() {
        return this.result;
    }

    @Nullable
    public SerializedPayload getFailure() {
        return this.serializedFailure;
    }

    @Nullable
    public RuntimeException getException() {
        return this.failure;
    }

    public boolean hasFailure() {
        return this.failure != null || this.serializedFailure != null;
    }

    public void rethrow() {
        if (this.failure != null) {
            throw this.failure;
        }
    }
}

