/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.List;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.TypeConversionException;

public class CompositeNotationConverter<N, T>
implements NotationConverter<N, T> {
    private final List<NotationConverter<? super N, ? extends T>> converters;

    public CompositeNotationConverter(List<NotationConverter<? super N, ? extends T>> converters) {
        this.converters = converters;
    }

    @Override
    public void convert(N notation, NotationConvertResult<? super T> result2) throws TypeConversionException {
        for (int i = 0; !result2.hasResult() && i < this.converters.size(); ++i) {
            NotationConverter<N, T> converter = this.converters.get(i);
            converter.convert(notation, result2);
        }
    }

    @Override
    public void describe(DiagnosticsVisitor visitor) {
        for (NotationConverter<N, T> converter : this.converters) {
            converter.describe(visitor);
        }
    }
}

