/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service.scopes;

import java.nio.file.Path;
import org.gradle.internal.event.AnonymousListenerBroadcast;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.watch.registry.FileWatcherRegistry;
import org.gradle.internal.watch.vfs.FileChangeListener;
import org.gradle.internal.watch.vfs.FileChangeListeners;

public class DefaultFileChangeListeners
implements FileChangeListeners {
    private final AnonymousListenerBroadcast<FileChangeListener> broadcaster;

    public DefaultFileChangeListeners(ListenerManager listenerManager) {
        this.broadcaster = listenerManager.createAnonymousBroadcaster(FileChangeListener.class);
    }

    @Override
    public void addListener(FileChangeListener listener2) {
        this.broadcaster.add(listener2);
    }

    @Override
    public void removeListener(FileChangeListener listener2) {
        this.broadcaster.remove(listener2);
    }

    @Override
    public void broadcastChange(FileWatcherRegistry.Type type, Path path) {
        ((FileChangeListener)this.broadcaster.getSource()).handleChange(type, path);
    }

    @Override
    public void broadcastWatchingError() {
        ((FileChangeListener)this.broadcaster.getSource()).stopWatchingAfterError();
    }
}

