/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resolve.result;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.internal.component.model.ComponentGraphResolveState;
import org.gradle.internal.component.model.ComponentGraphSpecificResolveState;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.RejectedVersion;
import org.gradle.internal.resolve.result.BuildableComponentIdResolveResult;
import org.gradle.internal.resolve.result.DefaultResourceAwareResolveResult;

public class DefaultBuildableComponentIdResolveResult
extends DefaultResourceAwareResolveResult
implements BuildableComponentIdResolveResult {
    private ModuleVersionResolveException failure;
    private ComponentGraphResolveState state;
    private ComponentGraphSpecificResolveState graphState;
    private ComponentIdentifier id;
    private ModuleVersionIdentifier moduleVersionId;
    private boolean rejected;
    private ImmutableSet.Builder<String> unmatchedVersions;
    private ImmutableSet.Builder<RejectedVersion> rejections;
    private Object mark;

    @Override
    public boolean hasResult() {
        return this.id != null || this.failure != null;
    }

    @Override
    public ModuleVersionResolveException getFailure() {
        return this.failure;
    }

    @Override
    public ComponentIdentifier getId() {
        this.assertResolved();
        return this.id;
    }

    @Override
    public ModuleVersionIdentifier getModuleVersionId() {
        this.assertResolved();
        return this.moduleVersionId;
    }

    @Override
    public ComponentGraphResolveState getState() {
        this.assertResolved();
        return this.state;
    }

    @Override
    @Nullable
    public ComponentGraphSpecificResolveState getGraphState() {
        this.assertResolved();
        return this.graphState;
    }

    @Override
    public boolean isRejected() {
        return this.rejected;
    }

    @Override
    public void resolved(ComponentIdentifier id, ModuleVersionIdentifier moduleVersionIdentifier) {
        this.reset();
        this.id = id;
        this.moduleVersionId = moduleVersionIdentifier;
    }

    @Override
    public void rejected(ComponentIdentifier id, ModuleVersionIdentifier moduleVersionIdentifier) {
        this.resolved(id, moduleVersionIdentifier);
        this.rejected = true;
    }

    @Override
    public void resolved(ComponentGraphResolveState state, ComponentGraphSpecificResolveState graphState) {
        this.resolved(state.getId(), state.getMetadata().getModuleVersionId());
        this.state = state;
        this.graphState = graphState;
    }

    @Override
    public void failed(ModuleVersionResolveException failure) {
        this.reset();
        this.failure = failure;
    }

    @Override
    public void unmatched(Collection<String> unmatchedVersions) {
        if (unmatchedVersions.isEmpty()) {
            return;
        }
        if (this.unmatchedVersions == null) {
            this.unmatchedVersions = new ImmutableSet.Builder();
        }
        this.unmatchedVersions.addAll(unmatchedVersions);
    }

    @Override
    public void rejections(Collection<RejectedVersion> rejections) {
        if (rejections.isEmpty()) {
            return;
        }
        if (this.rejections == null) {
            this.rejections = new ImmutableSet.Builder();
        }
        this.rejections.addAll(rejections);
    }

    @Override
    public Collection<String> getUnmatchedVersions() {
        return DefaultBuildableComponentIdResolveResult.safeBuild(this.unmatchedVersions);
    }

    @Override
    public Collection<RejectedVersion> getRejectedVersions() {
        return DefaultBuildableComponentIdResolveResult.safeBuild(this.rejections);
    }

    @Override
    public boolean mark(Object o) {
        if (this.mark == o) {
            return false;
        }
        this.mark = o;
        return true;
    }

    private static <T> Collection<T> safeBuild(ImmutableSet.Builder<T> builder) {
        if (builder == null) {
            return Collections.emptyList();
        }
        return builder.build();
    }

    private void assertResolved() {
        if (this.failure != null) {
            throw this.failure;
        }
        if (this.id == null) {
            throw new IllegalStateException("Not resolved.");
        }
    }

    private void reset() {
        this.failure = null;
        this.state = null;
        this.id = null;
        this.moduleVersionId = null;
        this.rejected = false;
    }
}

