/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.operations.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.ConsoleRenderer;
import org.gradle.internal.operations.logging.BuildOperationLogInfo;
import org.gradle.internal.operations.logging.BuildOperationLogger;

class DefaultBuildOperationLogger
implements BuildOperationLogger {
    private final BuildOperationLogInfo configuration;
    private final Logger logger;
    private final File outputFile;
    private PrintWriter logWriter;
    private boolean started;
    private int numberOfFailedOperationsSeen;

    DefaultBuildOperationLogger(BuildOperationLogInfo configuration, Logger logger, File outputFile) {
        this.configuration = configuration;
        this.logger = logger;
        this.outputFile = outputFile;
        this.numberOfFailedOperationsSeen = 0;
        this.started = false;
    }

    @Override
    public void start() {
        assert (!this.started);
        this.logWriter = this.createWriter(this.outputFile);
        this.logInBoth(LogLevel.INFO, String.format("See %s for all output for %s.", this.getLogLocation(), this.configuration.getTaskName()));
        this.started = true;
    }

    protected PrintWriter createWriter(File outputFile) {
        PrintWriter logWriter = null;
        try {
            logWriter = new PrintWriter((Writer)new FileWriter(outputFile), true);
        }
        catch (IOException e) {
            UncheckedException.throwAsUncheckedException(e);
        }
        return logWriter;
    }

    @Override
    public synchronized void operationSuccess(String description, String output) {
        assert (this.started);
        this.logInBoth(LogLevel.DEBUG, description.concat(" successful."));
        this.maybeShowSuccess(output);
    }

    @Override
    public synchronized void operationFailed(String description, String output) {
        assert (this.started);
        this.logInBoth(LogLevel.DEBUG, description.concat(" failed."));
        this.maybeShowFailure(output);
    }

    @Override
    public void done() {
        assert (this.started);
        try {
            int suppressedCount = this.numberOfFailedOperationsSeen - this.configuration.getMaximumFailedOperationsShown();
            if (suppressedCount > 0) {
                this.logger.log(LogLevel.ERROR, String.format("...output for %d more failed operation(s) continued in %s.", suppressedCount, this.getLogLocation()));
            }
            this.logInBoth(LogLevel.INFO, String.format("Finished %s, see full log %s.", this.configuration.getTaskName(), this.getLogLocation()));
        }
        finally {
            IoActions.closeQuietly(this.logWriter);
            this.started = false;
        }
    }

    private void maybeShowSuccess(String output) {
        this.logger.log(LogLevel.INFO, output);
        this.logWriter.println(output);
    }

    private void maybeShowFailure(String output) {
        if (this.numberOfFailedOperationsSeen < this.configuration.getMaximumFailedOperationsShown()) {
            this.logger.log(LogLevel.ERROR, output);
        }
        this.logWriter.println(output);
        ++this.numberOfFailedOperationsSeen;
    }

    private void logInBoth(LogLevel logLevel, String message) {
        this.logger.log(logLevel, message);
        this.logWriter.println(message);
    }

    @Override
    public String getLogLocation() {
        return new ConsoleRenderer().asClickableFileUrl(this.configuration.getOutputFile());
    }
}

