/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.services;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.text.AbstractLineChoppingStyledTextOutput;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.time.Clock;

public class LoggingBackedStyledTextOutput
extends AbstractLineChoppingStyledTextOutput {
    private final OutputEventListener listener;
    private final String category;
    private final LogLevel logLevel;
    private final Clock clock;
    private final StringBuilder buffer = new StringBuilder();
    private List<StyledTextOutputEvent.Span> spans = new ArrayList<StyledTextOutputEvent.Span>();
    private StyledTextOutput.Style style = StyledTextOutput.Style.Normal;

    public LoggingBackedStyledTextOutput(OutputEventListener listener2, String category, LogLevel logLevel, Clock clock) {
        this.listener = listener2;
        this.category = category;
        this.logLevel = logLevel;
        this.clock = clock;
    }

    @Override
    protected void doStyleChange(StyledTextOutput.Style style) {
        if (this.buffer.length() > 0) {
            this.spans.add(new StyledTextOutputEvent.Span(this.style, this.buffer.toString()));
            this.buffer.setLength(0);
        }
        this.style = style;
    }

    @Override
    protected void doLineText(CharSequence text) {
        this.buffer.append(text);
    }

    @Override
    protected void doEndLine(CharSequence endOfLine) {
        this.buffer.append(endOfLine);
        this.spans.add(new StyledTextOutputEvent.Span(this.style, this.buffer.toString()));
        this.buffer.setLength(0);
        OperationIdentifier buildOperationId = CurrentBuildOperationRef.instance().getId();
        this.listener.onOutput(new StyledTextOutputEvent(this.clock.getCurrentTime(), this.category, this.logLevel, buildOperationId, this.spans));
        this.spans = new ArrayList<StyledTextOutputEvent.Span>();
    }
}

