/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.logging.events.StyledTextOutputEvent;
import org.gradle.internal.logging.format.TersePrettyDurationFormatter;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgressBar {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgressBar.class);
    private final TersePrettyDurationFormatter elapsedTimeFormatter = new TersePrettyDurationFormatter();
    private final ConsoleMetaData consoleMetaData;
    private final String progressBarPrefix;
    private final int progressBarWidth;
    private final String progressBarSuffix;
    private final char fillerChar;
    private final char incompleteChar;
    private final String suffix;
    private int current;
    private int total;
    private ExecutorService deadlockPreventer;
    private boolean failing;
    private String lastElapsedTimeStr;
    private List<StyledTextOutputEvent.Span> formatted;

    public ProgressBar(ConsoleMetaData consoleMetaData, String progressBarPrefix, int progressBarWidth, String progressBarSuffix, char completeChar, char incompleteChar, String suffix, int initialProgress, int totalProgress) {
        this.consoleMetaData = consoleMetaData;
        this.progressBarPrefix = progressBarPrefix;
        this.progressBarWidth = progressBarWidth;
        this.progressBarSuffix = progressBarSuffix;
        this.fillerChar = completeChar;
        this.incompleteChar = incompleteChar;
        this.suffix = suffix;
        this.current = initialProgress;
        this.total = totalProgress;
    }

    public void moreProgress(int totalProgress) {
        this.total += totalProgress;
        this.formatted = null;
    }

    public void update(boolean failing) {
        ++this.current;
        if (this.current > this.total) {
            if (this.deadlockPreventer == null) {
                this.deadlockPreventer = Executors.newSingleThreadExecutor();
            }
            this.deadlockPreventer.submit(new Runnable(){

                @Override
                public void run() {
                    LOGGER.warn("More progress was logged than there should be ({} > {})", (Object)ProgressBar.this.current, (Object)ProgressBar.this.total);
                }
            });
        }
        this.failing = this.failing || failing;
        this.formatted = null;
    }

    public List<StyledTextOutputEvent.Span> formatProgress(boolean timerEnabled, long elapsedTime) {
        String elapsedTimeStr = this.elapsedTimeFormatter.format(elapsedTime);
        if (this.formatted == null || !elapsedTimeStr.equals(this.lastElapsedTimeStr)) {
            int consoleCols = this.consoleMetaData.getCols();
            int completedWidth = this.current > this.total ? this.progressBarWidth - 1 : (int)((double)this.current / (double)this.total * (double)this.progressBarWidth);
            int remainingWidth = this.progressBarWidth - completedWidth;
            String statusPrefix = this.trimToConsole(consoleCols, 0, this.progressBarPrefix);
            String coloredProgress = this.trimToConsole(consoleCols, statusPrefix.length(), this.fill(this.fillerChar, completedWidth));
            String statusSuffix = this.trimToConsole(consoleCols, coloredProgress.length(), this.fill(this.incompleteChar, remainingWidth) + this.progressBarSuffix + " " + (int)((double)this.current * 100.0 / (double)this.total) + '%' + ' ' + this.suffix + (timerEnabled ? " [" + elapsedTimeStr + "]" : ""));
            this.lastElapsedTimeStr = elapsedTimeStr;
            this.formatted = Lists.newArrayList((Object[])new StyledTextOutputEvent.Span[]{new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, statusPrefix), new StyledTextOutputEvent.Span(this.failing ? StyledTextOutput.Style.FailureHeader : StyledTextOutput.Style.SuccessHeader, coloredProgress), new StyledTextOutputEvent.Span(StyledTextOutput.Style.Header, statusSuffix)});
        }
        return this.formatted;
    }

    private String fill(char ch, int count) {
        char[] chars = new char[count];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = ch;
        }
        return new String(chars);
    }

    private String trimToConsole(int cols, int prefixLength, String str) {
        int consoleWidth = cols - 1;
        int remainingWidth = consoleWidth - prefixLength;
        if (consoleWidth < 0) {
            return str;
        }
        if (remainingWidth <= 0) {
            return "";
        }
        if (consoleWidth < str.length()) {
            return str.substring(0, consoleWidth);
        }
        return str;
    }
}

