/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaProperty;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Describable;
import org.gradle.api.NonNullApi;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.GeneratedSubclass;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.provider.DefaultProperty;
import org.gradle.api.internal.provider.support.LazyGroovySupport;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.services.ServiceReference;
import org.gradle.cache.internal.CrossBuildInMemoryCache;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.DisplayName;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.extensibility.ConventionAwareHelper;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.org.objectweb.asm.AnnotationVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.ClassVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Handle;
import org.gradle.internal.impldep.org.objectweb.asm.Label;
import org.gradle.internal.impldep.org.objectweb.asm.MethodVisitor;
import org.gradle.internal.impldep.org.objectweb.asm.Type;
import org.gradle.internal.instantiation.ClassGenerationException;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.generator.AbstractClassGenerator;
import org.gradle.internal.instantiation.generator.ClassGenerator;
import org.gradle.internal.instantiation.generator.ManagedObjectFactory;
import org.gradle.internal.instantiation.generator.MixInExtensibleDynamicObject;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.metaobject.AbstractDynamicObject;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.state.Managed;
import org.gradle.internal.state.ModelObject;
import org.gradle.internal.state.OwnerAware;
import org.gradle.model.internal.asm.AsmClassGenerator;
import org.gradle.model.internal.asm.AsmClassGeneratorUtils;
import org.gradle.model.internal.asm.BytecodeFragment;
import org.gradle.model.internal.asm.ClassGeneratorSuffixRegistry;
import org.gradle.model.internal.asm.ClassVisitorScope;
import org.gradle.model.internal.asm.MethodVisitorScope;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.util.internal.ConfigureUtil;
import sun.reflect.ReflectionFactory;

public class AsmBackedClassGenerator
extends AbstractClassGenerator {
    private static final ThreadLocal<ObjectCreationDetails> SERVICES_FOR_NEXT_OBJECT = new ThreadLocal();
    private static final AtomicReference<CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl>> GENERATED_CLASSES_CACHES = new AtomicReference();
    private final boolean decorate;
    private final String suffix;
    private final int factoryId;
    private static final String GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME = "getDisplayNameForNext";
    private static final String GET_SERVICES_FOR_NEXT_METHOD_NAME = "getServicesForNext";
    private static final String GET_FACTORY_FOR_NEXT_METHOD_NAME = "getFactoryForNext";

    @Nullable
    public static Describable getDisplayNameForNext() {
        ObjectCreationDetails details = SERVICES_FOR_NEXT_OBJECT.get();
        if (details == null) {
            return null;
        }
        return details.displayName;
    }

    public static ServiceLookup getServicesForNext() {
        return AsmBackedClassGenerator.SERVICES_FOR_NEXT_OBJECT.get().services;
    }

    public static ManagedObjectFactory getFactoryForNext() {
        ObjectCreationDetails details = SERVICES_FOR_NEXT_OBJECT.get();
        return new ManagedObjectFactory(details.services, details.instantiator, details.roleHandler);
    }

    private AsmBackedClassGenerator(boolean decorate, String suffix, Collection<? extends InjectAnnotationHandler> allKnownAnnotations, Collection<Class<? extends Annotation>> enabledInjectAnnotations, PropertyRoleAnnotationHandler roleHandler, CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl> generatedClasses, int factoryId) {
        super(allKnownAnnotations, enabledInjectAnnotations, roleHandler, generatedClasses);
        this.decorate = decorate;
        this.suffix = suffix;
        this.factoryId = factoryId;
    }

    static ClassGenerator decorateAndInject(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, PropertyRoleAnnotationHandler roleHandler, Collection<Class<? extends Annotation>> enabledInjectAnnotations, CrossBuildInMemoryCacheFactory cacheFactory, int factoryId) {
        CrossBuildInMemoryCache<Class<?>, AbstractClassGenerator.GeneratedClassImpl> generatedClasses;
        String suffix;
        if (enabledInjectAnnotations.isEmpty()) {
            suffix = "_Decorated";
            if (GENERATED_CLASSES_CACHES.get() == null && GENERATED_CLASSES_CACHES.compareAndSet(null, cacheFactory.newClassMap())) {
                ClassGeneratorSuffixRegistry.register(suffix);
            }
            generatedClasses = GENERATED_CLASSES_CACHES.get();
        } else {
            suffix = ClassGeneratorSuffixRegistry.assign("$Decorated");
            generatedClasses = cacheFactory.newClassMap();
        }
        return new AsmBackedClassGenerator(true, suffix, allKnownAnnotations, enabledInjectAnnotations, roleHandler, generatedClasses, factoryId);
    }

    static ClassGenerator injectOnly(Collection<? extends InjectAnnotationHandler> allKnownAnnotations, PropertyRoleAnnotationHandler roleHandler, Collection<Class<? extends Annotation>> enabledInjectAnnotations, CrossBuildInMemoryCacheFactory cacheFactory, int factoryId) {
        String suffix = ClassGeneratorSuffixRegistry.assign("$Inject");
        return new AsmBackedClassGenerator(false, suffix, allKnownAnnotations, enabledInjectAnnotations, roleHandler, cacheFactory.newClassMap(), factoryId);
    }

    @Override
    protected AbstractClassGenerator.InstantiationStrategy createUsingConstructor(Constructor<?> constructor) {
        return new InvokeConstructorStrategy(constructor, this.getRoleHandler());
    }

    @Override
    protected AbstractClassGenerator.InstantiationStrategy createForSerialization(Class<?> generatedType, Class<?> baseClass) {
        Constructor<?> constructor;
        try {
            constructor = ReflectionFactory.getReflectionFactory().newConstructorForSerialization(generatedType, baseClass.getDeclaredConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        Method method = CollectionUtils.findFirst(generatedType.getDeclaredMethods(), m -> m.getName().equals("$gradleInit"));
        assert (method != null);
        method.setAccessible(true);
        return new InvokeSerializationConstructorAndInitializeFieldsStrategy(constructor, method, this.getRoleHandler());
    }

    @Override
    protected AbstractClassGenerator.ClassInspectionVisitor start(Class<?> type) {
        if (type.isAnnotation() || type.isEnum()) {
            TreeFormatter formatter = new TreeFormatter();
            formatter.node(type);
            formatter.append(" is not a class or interface.");
            throw new ClassGenerationException(formatter.toString());
        }
        return new ClassInspectionVisitorImpl(type, this.decorate, this.suffix, this.factoryId);
    }

    @Nullable
    private static String getBuildServiceName(AbstractClassGenerator.PropertyMetadata property2) {
        ServiceReference annotation = property2.findAnnotation(ServiceReference.class);
        if (annotation != null) {
            return annotation.value();
        }
        return null;
    }

    @Nonnull
    private static String descriptorOf(Class<?> type) {
        return Type.getType(type).getDescriptor();
    }

    private static String propFieldName(AbstractClassGenerator.PropertyMetadata property2) {
        return AsmBackedClassGenerator.propFieldName(property2.getName());
    }

    public static String propFieldName(String name) {
        return "__" + name + "__";
    }

    private static Class<?> rawTypeParam(AbstractClassGenerator.PropertyMetadata property2, int paramNum) {
        java.lang.reflect.Type type = property2.getGenericType();
        if (!(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Declaration of property " + property2.getName() + " does not include any type arguments in its property type " + type);
        }
        java.lang.reflect.Type argument = ((ParameterizedType)type).getActualTypeArguments()[paramNum];
        if (argument instanceof Class) {
            return (Class)argument;
        }
        return (Class)((ParameterizedType)argument).getRawType();
    }

    private static class InvokeSerializationConstructorAndInitializeFieldsStrategy
    implements AbstractClassGenerator.InstantiationStrategy {
        private final PropertyRoleAnnotationHandler roleHandler;
        private final Constructor<?> constructor;
        private final Method initMethod;

        public InvokeSerializationConstructorAndInitializeFieldsStrategy(Constructor<?> constructor, Method initMethod, PropertyRoleAnnotationHandler roleHandler) {
            this.constructor = constructor;
            this.initMethod = initMethod;
            this.roleHandler = roleHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object newInstance(ServiceLookup services, InstanceGenerator nested, @Nullable Describable displayName, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            ObjectCreationDetails previous = (ObjectCreationDetails)SERVICES_FOR_NEXT_OBJECT.get();
            SERVICES_FOR_NEXT_OBJECT.set(new ObjectCreationDetails(nested, services, displayName, this.roleHandler));
            try {
                Object instance = this.constructor.newInstance(new Object[0]);
                this.initMethod.invoke(instance, new Object[0]);
                Object obj = instance;
                return obj;
            }
            finally {
                SERVICES_FOR_NEXT_OBJECT.set(previous);
            }
        }
    }

    private static class InvokeConstructorStrategy
    implements AbstractClassGenerator.InstantiationStrategy {
        private final Constructor<?> constructor;
        private final PropertyRoleAnnotationHandler roleHandler;

        public InvokeConstructorStrategy(Constructor<?> constructor, PropertyRoleAnnotationHandler roleHandler) {
            this.constructor = constructor;
            this.roleHandler = roleHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object newInstance(ServiceLookup services, InstanceGenerator nested, @Nullable Describable displayName, Object[] params) throws InvocationTargetException, IllegalAccessException, InstantiationException {
            ObjectCreationDetails previous = (ObjectCreationDetails)SERVICES_FOR_NEXT_OBJECT.get();
            SERVICES_FOR_NEXT_OBJECT.set(new ObjectCreationDetails(nested, services, displayName, this.roleHandler));
            try {
                Object obj = this.constructor.newInstance(params);
                return obj;
            }
            finally {
                SERVICES_FOR_NEXT_OBJECT.set(previous);
            }
        }
    }

    private static class NoOpBuilder
    implements AbstractClassGenerator.ClassGenerationVisitor {
        private final Class<?> type;

        public NoOpBuilder(Class<?> type) {
            this.type = type;
        }

        @Override
        public void addConstructor(Constructor<?> constructor, boolean addNameParameter) {
        }

        @Override
        public void addDefaultConstructor() {
        }

        @Override
        public void addNameConstructor() {
        }

        @Override
        public void mixInDynamicAware() {
        }

        @Override
        public void addNoDeprecationConventionPrivateGetter() {
        }

        @Override
        public void mixInConventionAware() {
        }

        @Override
        public void mixInGroovyObject() {
        }

        @Override
        public void addDynamicMethods() {
        }

        @Override
        public void addExtensionsProperty() {
        }

        @Override
        public void applyServiceInjectionToProperty(AbstractClassGenerator.PropertyMetadata property2) {
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property2, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property2, Method setter) {
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property2, Class<? extends Annotation> annotation, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property2, Class<? extends Annotation> annotation, Method setter) {
        }

        @Override
        public void applyManagedStateToProperty(AbstractClassGenerator.PropertyMetadata property2) {
        }

        @Override
        public void applyReadOnlyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property2, Method getter, boolean applyRole) {
        }

        @Override
        public void applyManagedStateToGetter(AbstractClassGenerator.PropertyMetadata property2, Method getter) {
        }

        @Override
        public void applyManagedStateToSetter(AbstractClassGenerator.PropertyMetadata property2, Method setter) {
        }

        @Override
        public void addManagedMethods(List<AbstractClassGenerator.PropertyMetadata> mutableProperties, List<AbstractClassGenerator.PropertyMetadata> readOnlyProperties) {
        }

        @Override
        public void applyConventionMappingToProperty(AbstractClassGenerator.PropertyMetadata property2) {
        }

        @Override
        public void applyConventionMappingToGetter(AbstractClassGenerator.PropertyMetadata property2, AbstractClassGenerator.MethodMetadata getter, boolean attachOwner, boolean applyRole) {
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetadata property2, Method setter) {
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetadata property2, Method setter) {
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetadata propertyMetaData, Method setter) {
        }

        @Override
        public void addActionMethod(Method method) {
        }

        @Override
        public void addLazyGroovySupportSetterOverloads(AbstractClassGenerator.PropertyMetadata property2, AbstractClassGenerator.MethodMetadata getter) {
        }

        @Override
        public void addNameProperty() {
        }

        @Override
        public Class<?> generate() {
            return this.type;
        }
    }

    private static class ObjectCreationDetails {
        final InstanceGenerator instantiator;
        final ServiceLookup services;
        @Nullable
        final Describable displayName;
        PropertyRoleAnnotationHandler roleHandler;

        ObjectCreationDetails(InstanceGenerator instantiator2, ServiceLookup services, @Nullable Describable displayName, PropertyRoleAnnotationHandler roleHandler) {
            this.instantiator = instantiator2;
            this.services = services;
            this.displayName = displayName;
            this.roleHandler = roleHandler;
        }
    }

    @NonNullApi
    private static class ClassBuilderImpl
    extends ClassVisitorScope
    implements AbstractClassGenerator.ClassGenerationVisitor {
        public static final int PV_FINAL_STATIC = 4122;
        private static final Set<? extends Class<?>> PRIMITIVE_TYPES = ImmutableSet.of(Byte.TYPE, Boolean.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, (Object[])new Class[]{Float.TYPE, Double.TYPE});
        private static final String DYNAMIC_OBJECT_HELPER_FIELD = "_gr_dyn_";
        private static final String MAPPING_FIELD = "_gr_map_";
        private static final String META_CLASS_FIELD = "_gr_mc_";
        private static final String SERVICES_FIELD = "_gr_svcs_";
        private static final String NAME_FIELD = "_gr_n_";
        private static final String DISPLAY_NAME_FIELD = "_gr_dn_";
        private static final String OWNER_FIELD = "_gr_owner_";
        private static final String FACTORY_ID_FIELD = "_gr_fid_";
        private static final String FACTORY_FIELD = "_gr_f_";
        private static final String SERVICES_METHOD = "$gradleServices";
        private static final String FACTORY_METHOD = "$gradleFactory";
        private static final String INIT_METHOD = "$gradleInit";
        private static final String INIT_WORK_METHOD = "$gradleInitWork";
        private static final String INIT_ATTACH_METHOD = "$gradleInitAttach";
        private static final String CONVENTION_MAPPING_FIELD_DESCRIPTOR = Type.getDescriptor(ConventionMapping.class);
        private static final String META_CLASS_TYPE_DESCRIPTOR = Type.getDescriptor(MetaClass.class);
        private static final Type META_CLASS_TYPE = Type.getType(MetaClass.class);
        private static final Type GENERATED_SUBCLASS_TYPE = Type.getType(GeneratedSubclass.class);
        private static final Type MODEL_OBJECT_TYPE = Type.getType(ModelObject.class);
        private static final Type OWNER_AWARE_TYPE = Type.getType(OwnerAware.class);
        private static final Type CONVENTION_AWARE_TYPE = Type.getType(IConventionAware.class);
        private static final Type CONVENTION_AWARE_HELPER_TYPE = Type.getType(ConventionAwareHelper.class);
        private static final Type DYNAMIC_OBJECT_AWARE_TYPE = Type.getType(DynamicObjectAware.class);
        private static final Type EXTENSION_AWARE_TYPE = Type.getType(ExtensionAware.class);
        private static final Type HAS_CONVENTION_TYPE = Type.getType(HasConvention.class);
        private static final Type DYNAMIC_OBJECT_TYPE = Type.getType(DynamicObject.class);
        private static final Type CONVENTION_MAPPING_TYPE = Type.getType(ConventionMapping.class);
        private static final Type GROOVY_OBJECT_TYPE = Type.getType(GroovyObject.class);
        private static final Type CONVENTION_TYPE = Type.getType(Convention.class);
        private static final Type ASM_BACKED_CLASS_GENERATOR_TYPE = Type.getType(AsmBackedClassGenerator.class);
        private static final Type ABSTRACT_DYNAMIC_OBJECT_TYPE = Type.getType(AbstractDynamicObject.class);
        private static final Type EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = Type.getType(MixInExtensibleDynamicObject.class);
        private static final Type NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE = Type.getType(BeanDynamicObject.class);
        private static final String JAVA_REFLECT_TYPE_DESCRIPTOR = Type.getDescriptor(java.lang.reflect.Type.class);
        private static final Type CONFIGURE_UTIL_TYPE = Type.getType(ConfigureUtil.class);
        private static final Type CLOSURE_TYPE = Type.getType(Closure.class);
        private static final Type SERVICE_REGISTRY_TYPE = Type.getType(ServiceRegistry.class);
        private static final Type SERVICE_LOOKUP_TYPE = Type.getType(ServiceLookup.class);
        private static final Type MANAGED_OBJECT_FACTORY_TYPE = Type.getType(ManagedObjectFactory.class);
        private static final Type DEFAULT_PROPERTY_TYPE = Type.getType(DefaultProperty.class);
        private static final Type BUILD_SERVICE_PROVIDER_TYPE = Type.getType((String)"Lorg/gradle/api/services/internal/BuildServiceProvider;");
        private static final Type INSTRUMENTED_EXECUTION_ACCESS_TYPE = Type.getType((String)"Lorg/gradle/internal/classpath/InstrumentedExecutionAccess;");
        private static final Set<Type> DISALLOWED_AT_EXECUTION_INJECTED_SERVICES_TYPES = ImmutableSet.of((Object)Type.getType(Project.class), (Object)Type.getType((String)"Lorg/gradle/api/internal/project/ProjectInternal;"), (Object)Type.getType(Gradle.class), (Object)Type.getType((String)"Lorg/gradle/api/internal/GradleInternal;"));
        private static final Type JAVA_LANG_REFLECT_TYPE = Type.getType(java.lang.reflect.Type.class);
        private static final Type OBJECT_TYPE = Type.getType(Object.class);
        private static final Type CLASS_TYPE = Type.getType(Class.class);
        private static final Type METHOD_TYPE = Type.getType(Method.class);
        private static final Type STRING_TYPE = Type.getType(String.class);
        private static final Type CLASS_ARRAY_TYPE = Type.getType(Class[].class);
        private static final Type GROOVY_SYSTEM_TYPE = Type.getType(GroovySystem.class);
        private static final Type META_CLASS_REGISTRY_TYPE = Type.getType(MetaClassRegistry.class);
        private static final Type OBJECT_ARRAY_TYPE = Type.getType(Object[].class);
        private static final Type ACTION_TYPE = Type.getType(Action.class);
        private static final Type LAZY_GROOVY_SUPPORT_TYPE = Type.getType(LazyGroovySupport.class);
        private static final Type MANAGED_TYPE = Type.getType(Managed.class);
        private static final Type EXTENSION_CONTAINER_TYPE = Type.getType(ExtensionContainer.class);
        private static final Type DESCRIBABLE_TYPE = Type.getType(Describable.class);
        private static final Type DISPLAY_NAME_TYPE = Type.getType(DisplayName.class);
        private static final Type INJECT_TYPE = Type.getType(Inject.class);
        private static final Type RUNNABLE_TYPE = Type.getType(Runnable.class);
        private static final Type FACTORY_TYPE = Type.getType(Factory.class);
        private static final Type LAMBDA_METAFACTORY_TYPE = Type.getType(LambdaMetafactory.class);
        private static final Type METHOD_HANDLES_TYPE = Type.getType(MethodHandles.class);
        private static final Type METHOD_HANDLES_LOOKUP_TYPE = Type.getType(MethodHandles.Lookup.class);
        private static final Type METHOD_TYPE_TYPE = Type.getType(MethodType.class);
        private static final Type DEPRECATION_LOGGER_TYPE = Type.getType(DeprecationLogger.class);
        private static final String RETURN_STRING = Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[0]);
        private static final String RETURN_DESCRIBABLE = Type.getMethodDescriptor((Type)DESCRIBABLE_TYPE, (Type[])new Type[0]);
        private static final String RETURN_VOID_FROM_OBJECT = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT_SERVICE_LOOKUP = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE, CLASS_TYPE, DYNAMIC_OBJECT_TYPE, SERVICE_LOOKUP_TYPE});
        private static final String RETURN_OBJECT_FROM_STRING_OBJECT_BOOLEAN = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{OBJECT_TYPE, STRING_TYPE, Type.BOOLEAN_TYPE});
        private static final String RETURN_CLASS = Type.getMethodDescriptor((Type)CLASS_TYPE, (Type[])new Type[0]);
        private static final String RETURN_BOOLEAN = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]);
        private static final String RETURN_VOID = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]);
        private static final String RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CONVENTION_AWARE_TYPE, CONVENTION_TYPE});
        private static final String RETURN_CONVENTION = Type.getMethodDescriptor((Type)CONVENTION_TYPE, (Type[])new Type[0]);
        private static final String RETURN_CONVENTION_MAPPING = Type.getMethodDescriptor((Type)CONVENTION_MAPPING_TYPE, (Type[])new Type[0]);
        private static final String RETURN_OBJECT = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[0]);
        private static final String RETURN_EXTENSION_CONTAINER = Type.getMethodDescriptor((Type)EXTENSION_CONTAINER_TYPE, (Type[])new Type[0]);
        private static final String RETURN_OBJECT_FROM_STRING = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE});
        private static final String RETURN_OBJECT_FROM_STRING_OBJECT = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_STRING_OBJECT = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_TYPE});
        private static final String RETURN_DYNAMIC_OBJECT = Type.getMethodDescriptor((Type)DYNAMIC_OBJECT_TYPE, (Type[])new Type[0]);
        private static final String RETURN_META_CLASS_FROM_CLASS = Type.getMethodDescriptor((Type)META_CLASS_TYPE, (Type[])new Type[]{CLASS_TYPE});
        private static final String RETURN_BOOLEAN_FROM_STRING = Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[]{STRING_TYPE});
        private static final String RETURN_META_CLASS_REGISTRY = Type.getMethodDescriptor((Type)META_CLASS_REGISTRY_TYPE, (Type[])new Type[0]);
        private static final String RETURN_SERVICE_REGISTRY = Type.getMethodDescriptor((Type)SERVICE_REGISTRY_TYPE, (Type[])new Type[0]);
        private static final String RETURN_SERVICE_LOOKUP = Type.getMethodDescriptor((Type)SERVICE_LOOKUP_TYPE, (Type[])new Type[0]);
        private static final String RETURN_MANAGED_OBJECT_FACTORY = Type.getMethodDescriptor((Type)MANAGED_OBJECT_FACTORY_TYPE, (Type[])new Type[0]);
        private static final String RETURN_META_CLASS = Type.getMethodDescriptor((Type)META_CLASS_TYPE, (Type[])new Type[0]);
        private static final String RETURN_VOID_FROM_META_CLASS = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{META_CLASS_TYPE});
        private static final String GET_DECLARED_METHOD_DESCRIPTOR = Type.getMethodDescriptor((Type)METHOD_TYPE, (Type[])new Type[]{STRING_TYPE, CLASS_ARRAY_TYPE});
        private static final String RETURN_VOID_FROM_OBJECT_MODEL_OBJECT = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_TYPE, MODEL_OBJECT_TYPE});
        private static final String RETURN_VOID_FROM_DEFAULT_PROPERTY_SERVICE_LOOKUP_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{DEFAULT_PROPERTY_TYPE, SERVICE_LOOKUP_TYPE, STRING_TYPE});
        private static final String RETURN_VOID_FROM_MODEL_OBJECT_DISPLAY_NAME = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{MODEL_OBJECT_TYPE, DISPLAY_NAME_TYPE});
        private static final String RETURN_OBJECT_FROM_TYPE = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{JAVA_LANG_REFLECT_TYPE});
        private static final String RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{OBJECT_TYPE, MODEL_OBJECT_TYPE, STRING_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE, CLASS_TYPE});
        private static final String RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS_CLASS = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{MODEL_OBJECT_TYPE, STRING_TYPE, CLASS_TYPE, CLASS_TYPE, CLASS_TYPE});
        private static final String RETURN_VOID_FROM_STRING = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{STRING_TYPE});
        private static final String LAMBDA_METAFACTORY_METHOD = Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{METHOD_HANDLES_LOOKUP_TYPE, STRING_TYPE, METHOD_TYPE_TYPE, METHOD_TYPE_TYPE, Type.getType(MethodHandle.class), METHOD_TYPE_TYPE});
        private static final String DEPRECATION_LOGGER_WHILE_DISABLED_RUNNABLE_METHOD = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{RUNNABLE_TYPE});
        private static final String DEPRECATION_LOGGER_WHILE_DISABLED_FACTORY_METHOD = Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{FACTORY_TYPE});
        private static final Handle LAMBDA_BOOTSTRAP_HANDLE = new Handle(6, LAMBDA_METAFACTORY_TYPE.getInternalName(), "metafactory", LAMBDA_METAFACTORY_METHOD, false);
        private static final Type RETURN_VOID_METHOD_TYPE = Type.getMethodType((String)RETURN_VOID);
        private static final Type RETURN_OBJECT_METHOD_TYPE = Type.getMethodType((String)RETURN_OBJECT);
        private static final Type RETURN_CONVENTION_METHOD_TYPE = Type.getMethodType((String)RETURN_CONVENTION);
        private static final String[] EMPTY_STRINGS = new String[0];
        private static final Type[] EMPTY_TYPES = new Type[0];
        private final Class<?> type;
        private final boolean managed;
        private final Type generatedType;
        private final Type superclassType;
        private final Map<java.lang.reflect.Type, ReturnTypeEntry> genericReturnTypeConstantsIndex = Maps.newHashMap();
        private final AsmClassGenerator classGenerator;
        private final int factoryId;
        private boolean hasMappingField;
        private final boolean conventionAware;
        private final boolean mixInDsl;
        private final boolean extensible;
        private final boolean providesOwnDynamicObject;
        private final boolean requiresToString;
        private final List<AttachedProperty> propertiesToAttachAtConstruction;
        private final List<AttachedProperty> propertiesToAttachOnDemand;
        private final List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties;
        private final boolean requiresServicesMethod;
        private final boolean requiresFactory;

        private ClassBuilderImpl(AsmClassGenerator classGenerator, boolean decorated, int factoryId, boolean extensible, boolean conventionAware, boolean managed, boolean providesOwnDynamicObject, boolean requiresToString, boolean requiresServicesMethod, boolean requiresFactory, List<AttachedProperty> propertiesToAttachAtConstruction, List<AttachedProperty> propertiesToAttachOnDemand, List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties) {
            super((ClassVisitor)classGenerator.getVisitor());
            this.classGenerator = classGenerator;
            this.type = classGenerator.getTargetType();
            this.generatedType = classGenerator.getGeneratedType();
            this.factoryId = factoryId;
            this.managed = managed;
            this.requiresToString = requiresToString;
            this.propertiesToAttachAtConstruction = propertiesToAttachAtConstruction;
            this.propertiesToAttachOnDemand = propertiesToAttachOnDemand;
            this.superclassType = Type.getType(this.type);
            this.mixInDsl = decorated;
            this.extensible = extensible;
            this.conventionAware = conventionAware;
            this.providesOwnDynamicObject = providesOwnDynamicObject;
            this.requiresServicesMethod = requiresServicesMethod;
            this.requiresFactory = requiresFactory;
            this.ineligibleProperties = ineligibleProperties;
        }

        public void startClass() {
            ArrayList<String> interfaceTypes = new ArrayList<String>();
            Type superclass = this.superclassType;
            if (this.type.isInterface()) {
                interfaceTypes.add(this.superclassType.getInternalName());
                superclass = OBJECT_TYPE;
            }
            interfaceTypes.add(GENERATED_SUBCLASS_TYPE.getInternalName());
            interfaceTypes.add(MODEL_OBJECT_TYPE.getInternalName());
            interfaceTypes.add(OWNER_AWARE_TYPE.getInternalName());
            if (this.conventionAware) {
                interfaceTypes.add(CONVENTION_AWARE_TYPE.getInternalName());
            }
            if (this.extensible) {
                interfaceTypes.add(EXTENSION_AWARE_TYPE.getInternalName());
                interfaceTypes.add(HAS_CONVENTION_TYPE.getInternalName());
            }
            if (this.mixInDsl) {
                interfaceTypes.add(DYNAMIC_OBJECT_AWARE_TYPE.getInternalName());
                interfaceTypes.add(GROOVY_OBJECT_TYPE.getInternalName());
            }
            if (this.managed) {
                interfaceTypes.add(MANAGED_TYPE.getInternalName());
            }
            this.includeNotInheritedAnnotations();
            this.visit(52, 4097, this.generatedType.getInternalName(), null, superclass.getInternalName(), interfaceTypes.toArray(EMPTY_STRINGS));
            this.generateInitMethod();
            this.generateGeneratedSubtypeMethods();
            this.generateModelObjectMethods();
            if (this.requiresToString) {
                this.generateToStringSupport();
            }
            if (this.requiresServicesMethod) {
                this.generateServiceRegistrySupport();
            }
            if (this.requiresFactory) {
                this.generateManagedPropertyCreationSupport();
            }
        }

        @Override
        public void addDefaultConstructor() {
            this.publicMethod("<init>", RETURN_VOID, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKESPECIAL(OBJECT_TYPE, "<init>", RETURN_VOID);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.INIT_METHOD, RETURN_VOID);
                    this._RETURN();
                }
            });
        }

        @Override
        public void addNameConstructor() {
            this.publicMethod("<init>", RETURN_VOID_FROM_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this.visitAnnotation(INJECT_TYPE.getDescriptor(), true).visitEnd();
                    this._ALOAD(0);
                    this._INVOKESPECIAL(OBJECT_TYPE, "<init>", RETURN_VOID);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.NAME_FIELD, STRING_TYPE);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.INIT_METHOD, RETURN_VOID);
                    this._RETURN();
                }
            });
        }

        @Override
        public void addConstructor(final Constructor<?> constructor, final boolean addNameParameter) {
            String methodDescriptor;
            final List<Type> paramTypes = ClassBuilderImpl.paramTypesOf(constructor, addNameParameter);
            final String superMethodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])paramTypes.toArray(EMPTY_TYPES));
            if (addNameParameter) {
                paramTypes.add(0, STRING_TYPE);
                methodDescriptor = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])paramTypes.toArray(EMPTY_TYPES));
            } else {
                methodDescriptor = superMethodDescriptor;
            }
            this.publicMethod("<init>", methodDescriptor, AsmClassGeneratorUtils.signature(constructor, addNameParameter), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    int stackVar;
                    super(methodVisitor);
                    ClassBuilderImpl.visitDeclaredAnnotationsOf(constructor, this.mv);
                    this._ALOAD(0);
                    int n = stackVar = addNameParameter ? 2 : 1;
                    for (int typeVar = addNameParameter ? 1 : 0; typeVar < paramTypes.size(); ++typeVar) {
                        Type argType = (Type)paramTypes.get(typeVar);
                        this._ILOAD_OF(argType, stackVar);
                        stackVar += argType.getSize();
                    }
                    this._INVOKESPECIAL(superclassType, "<init>", superMethodDescriptor);
                    if (addNameParameter) {
                        this._ALOAD(0);
                        this._ALOAD(1);
                        this._PUTFIELD(generatedType, ClassBuilderImpl.NAME_FIELD, STRING_TYPE);
                    }
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.INIT_METHOD, RETURN_VOID);
                    this._RETURN();
                }
            });
        }

        @Nonnull
        private static List<Type> paramTypesOf(Constructor<?> constructor, boolean addNameParameter) {
            Class<?>[] parameterTypes = constructor.getParameterTypes();
            ArrayList<Type> paramTypes = new ArrayList<Type>(parameterTypes.length + (addNameParameter ? 1 : 0));
            for (Class<?> paramType : parameterTypes) {
                paramTypes.add(Type.getType(paramType));
            }
            return paramTypes;
        }

        private static void visitDeclaredAnnotationsOf(Constructor<?> constructor, MethodVisitor methodVisitor) {
            for (Annotation annotation : constructor.getDeclaredAnnotations()) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotationType.getAnnotation(Retention.class);
                methodVisitor.visitAnnotation(AsmBackedClassGenerator.descriptorOf(annotationType), retention != null && retention.value() == RetentionPolicy.RUNTIME).visitEnd();
            }
        }

        private void generateInitMethod() {
            this.visitInnerClass(METHOD_HANDLES_LOOKUP_TYPE.getInternalName(), METHOD_HANDLES_TYPE.getInternalName(), "Lookup", 4098);
            this.privateSyntheticMethod(INIT_METHOD, RETURN_VOID, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEDYNAMIC("run", Type.getMethodDescriptor((Type)RUNNABLE_TYPE, (Type[])new Type[]{generatedType}), LAMBDA_BOOTSTRAP_HANDLE, Arrays.asList(RETURN_VOID_METHOD_TYPE, new Handle(7, generatedType.getInternalName(), ClassBuilderImpl.INIT_WORK_METHOD, RETURN_VOID, false), RETURN_VOID_METHOD_TYPE));
                    this._INVOKESTATIC(DEPRECATION_LOGGER_TYPE, "whileDisabled", DEPRECATION_LOGGER_WHILE_DISABLED_RUNNABLE_METHOD);
                    this._RETURN();
                }
            });
            this.privateSyntheticMethod(INIT_ATTACH_METHOD, RETURN_VOID, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    for (AttachedProperty attached : propertiesToAttachAtConstruction) {
                        this.attachProperty(attached);
                    }
                    this._RETURN();
                }
            });
            this.privateSyntheticMethod(INIT_WORK_METHOD, RETURN_VOID, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, AsmBackedClassGenerator.GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME, RETURN_DESCRIBABLE);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                    if (requiresServicesMethod) {
                        this._ALOAD(0);
                        this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, AsmBackedClassGenerator.GET_SERVICES_FOR_NEXT_METHOD_NAME, RETURN_SERVICE_LOOKUP);
                        this._PUTFIELD(generatedType, ClassBuilderImpl.SERVICES_FIELD, SERVICE_LOOKUP_TYPE);
                    }
                    if (requiresFactory) {
                        this._ALOAD(0);
                        this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, AsmBackedClassGenerator.GET_FACTORY_FOR_NEXT_METHOD_NAME, RETURN_MANAGED_OBJECT_FACTORY);
                        this._PUTFIELD(generatedType, ClassBuilderImpl.FACTORY_FIELD, MANAGED_OBJECT_FACTORY_TYPE);
                    }
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.INIT_ATTACH_METHOD, RETURN_VOID);
                    if (conventionAware && IConventionAware.class.isAssignableFrom(type)) {
                        for (AbstractClassGenerator.PropertyMetadata property2 : ineligibleProperties) {
                            this._ALOAD(0);
                            this._INVOKEVIRTUAL(generatedType, "getConventionMapping", RETURN_CONVENTION_MAPPING);
                            this._LDC(property2.getName());
                            this._INVOKEINTERFACE(CONVENTION_MAPPING_TYPE, "ineligible", RETURN_VOID_FROM_STRING);
                        }
                    }
                    this._RETURN();
                }
            });
        }

        @Override
        public void addNoDeprecationConventionPrivateGetter() {
            this.privateSyntheticMethod("getConventionWhileDisabledDeprecationLogger", RETURN_CONVENTION, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEDYNAMIC("create", Type.getMethodDescriptor((Type)FACTORY_TYPE, (Type[])new Type[]{generatedType}), LAMBDA_BOOTSTRAP_HANDLE, Arrays.asList(RETURN_OBJECT_METHOD_TYPE, new Handle(5, generatedType.getInternalName(), "getConvention", RETURN_CONVENTION, false), RETURN_CONVENTION_METHOD_TYPE));
                    this._INVOKESTATIC(DEPRECATION_LOGGER_TYPE, "whileDisabled", DEPRECATION_LOGGER_WHILE_DISABLED_FACTORY_METHOD);
                    this._CHECKCAST(CONVENTION_TYPE);
                    this._ARETURN();
                }
            });
        }

        @Override
        public void addExtensionsProperty() {
            this.addGetter("getExtensions", EXTENSION_CONTAINER_TYPE, RETURN_EXTENSION_CONTAINER, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getConventionWhileDisabledDeprecationLogger", RETURN_CONVENTION);
                }
            });
        }

        @Override
        public void mixInDynamicAware() {
            if (!this.mixInDsl) {
                return;
            }
            this.addField(130, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE);
            if (this.extensible) {
                this.addGetter("getConvention", CONVENTION_TYPE, RETURN_CONVENTION, methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._ALOAD(0);
                        this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                        this._CHECKCAST(EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE);
                        this._INVOKEVIRTUAL(EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE, "getConvention", RETURN_CONVENTION);
                    }
                });
            }
            this.addLazyGetter("getAsDynamicObject", DYNAMIC_OBJECT_TYPE, RETURN_DYNAMIC_OBJECT, DYNAMIC_OBJECT_HELPER_FIELD, ABSTRACT_DYNAMIC_OBJECT_TYPE, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    if (extensible) {
                        this._NEW(EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE);
                        this._DUP();
                        this._ALOAD(0);
                        this._ALOAD(0);
                        this._INVOKEVIRTUAL(generatedType, "getClass", RETURN_CLASS);
                        this._INVOKEVIRTUAL(CLASS_TYPE, "getSuperclass", RETURN_CLASS);
                        if (providesOwnDynamicObject) {
                            this._ALOAD(0);
                            this._INVOKESPECIAL(Type.getType((Class)type), "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                        } else {
                            this._ACONST_NULL();
                        }
                        this.putServiceRegistryOnStack();
                        this._INVOKESPECIAL(EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE, "<init>", RETURN_VOID_FROM_OBJECT_CLASS_DYNAMIC_OBJECT_SERVICE_LOOKUP);
                    } else {
                        this._NEW(NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE);
                        this._DUP();
                        this._ALOAD(0);
                        this._INVOKESPECIAL(NON_EXTENSIBLE_DYNAMIC_OBJECT_HELPER_TYPE, "<init>", RETURN_VOID_FROM_OBJECT);
                    }
                }
            });
        }

        @Override
        public void mixInConventionAware() {
            this.addField(130, MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR);
            this.hasMappingField = true;
            this.addLazyGetter("getConventionMapping", CONVENTION_MAPPING_TYPE, RETURN_CONVENTION_MAPPING, MAPPING_FIELD, CONVENTION_MAPPING_TYPE, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._NEW(CONVENTION_AWARE_HELPER_TYPE);
                    this._DUP();
                    this._ALOAD(0);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getConventionWhileDisabledDeprecationLogger", RETURN_CONVENTION);
                    this._INVOKESPECIAL(CONVENTION_AWARE_HELPER_TYPE, "<init>", RETURN_VOID_FROM_CONVENTION_AWARE_CONVENTION);
                    for (AbstractClassGenerator.PropertyMetadata property2 : ineligibleProperties) {
                        this._DUP();
                        this._LDC(property2.getName());
                        this._INVOKEINTERFACE(CONVENTION_MAPPING_TYPE, "ineligible", RETURN_VOID_FROM_STRING);
                    }
                }
            });
        }

        @Override
        public void mixInGroovyObject() {
            if (!this.mixInDsl) {
                return;
            }
            this.addField(130, META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR);
            this.addLazyGetter("getMetaClass", META_CLASS_TYPE, RETURN_META_CLASS, META_CLASS_FIELD, META_CLASS_TYPE, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._INVOKESTATIC(GROOVY_SYSTEM_TYPE, "getMetaClassRegistry", RETURN_META_CLASS_REGISTRY);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(OBJECT_TYPE, "getClass", RETURN_CLASS);
                    this._INVOKEINTERFACE(META_CLASS_REGISTRY_TYPE, "getMetaClass", RETURN_META_CLASS_FROM_CLASS);
                }
            });
            this.addSetter("setMetaClass", RETURN_VOID_FROM_META_CLASS, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.META_CLASS_FIELD, META_CLASS_TYPE_DESCRIPTOR);
                }
            });
        }

        private void addSetter(String methodName, String methodDescriptor, BytecodeFragment body) {
            this.addSetter(methodName, methodDescriptor, null, body);
        }

        private void addSetter(String methodName, String methodDescriptor, @Nullable String signature, final BytecodeFragment body) {
            this.publicMethod(methodName, methodDescriptor, signature, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this.emit(body);
                    this._RETURN();
                }
            });
        }

        @Override
        public void addLazyGroovySupportSetterOverloads(AbstractClassGenerator.PropertyMetadata property2, final AbstractClassGenerator.MethodMetadata getter) {
            if (!this.mixInDsl) {
                return;
            }
            this.addSetter(MetaProperty.getSetterName((String)property2.getName()), RETURN_VOID_FROM_OBJECT, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(getter.getReturnType()), (Type[])new Type[0]));
                    this._CHECKCAST(LAZY_GROOVY_SUPPORT_TYPE);
                    this._ALOAD(1);
                    this._INVOKEINTERFACE(LAZY_GROOVY_SUPPORT_TYPE, "setFromAnyValue", RETURN_VOID_FROM_OBJECT);
                }
            });
        }

        private void addLazyGetter(String methodName, Type returnType, String methodDescriptor, String fieldName, Type fieldType, BytecodeFragment initializer) {
            this.addLazyGetter(methodName, returnType, methodDescriptor, null, fieldName, fieldType, initializer, BytecodeFragment.NO_OP);
        }

        private void addLazyGetter(String methodName, Type returnType, String methodDescriptor, @Nullable String signature, final String fieldName, final Type fieldType, final BytecodeFragment initializer, final BytecodeFragment epilogue) {
            this.addGetter(methodName, returnType, methodDescriptor, signature, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, fieldName, fieldType);
                    this._ASTORE(1);
                    this._ALOAD(1);
                    Label returnValue = new Label();
                    this._IFNONNULL(returnValue);
                    this.emit(initializer);
                    this._ASTORE(1);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._PUTFIELD(generatedType, fieldName, fieldType);
                    this.visitLabel(returnValue);
                    this.emit(epilogue);
                    this._ALOAD(1);
                }
            });
        }

        @Override
        public void addDynamicMethods() {
            if (!this.mixInDsl) {
                return;
            }
            if (this.type.getName().equals("org.gradle.api.internal.project.DefaultProject")) {
                return;
            }
            this.addGetter("getProperty", OBJECT_TYPE, RETURN_OBJECT_FROM_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                    this._ALOAD(1);
                    this._INVOKEINTERFACE(DYNAMIC_OBJECT_TYPE, "getProperty", RETURN_OBJECT_FROM_STRING);
                }
            });
            this.publicMethod("hasProperty", RETURN_BOOLEAN_FROM_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                    this._ALOAD(1);
                    this._INVOKEINTERFACE(DYNAMIC_OBJECT_TYPE, "hasProperty", RETURN_BOOLEAN_FROM_STRING);
                    this._IRETURN();
                }
            });
            this.addSetter("setProperty", RETURN_VOID_FROM_STRING_OBJECT, setter -> new MethodVisitorScope(setter){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                    this._ALOAD(1);
                    this._ALOAD(2);
                    this._INVOKEINTERFACE(DYNAMIC_OBJECT_TYPE, "setProperty", RETURN_VOID_FROM_STRING_OBJECT);
                }
            });
            this.addGetter("invokeMethod", OBJECT_TYPE, RETURN_OBJECT_FROM_STRING_OBJECT, getter -> new MethodVisitorScope(getter){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, "getAsDynamicObject", RETURN_DYNAMIC_OBJECT);
                    this._ALOAD(1);
                    Label end = new Label();
                    Label notArray = new Label();
                    this._ALOAD(2);
                    this._INSTANCEOF(OBJECT_ARRAY_TYPE);
                    this._IFEQ(notArray);
                    this._ALOAD(2);
                    this._CHECKCAST(OBJECT_ARRAY_TYPE);
                    this._GOTO(end);
                    this.visitLabel(notArray);
                    this._ICONST_1();
                    this._ANEWARRAY(OBJECT_TYPE);
                    this._DUP();
                    this._ICONST_0();
                    this._ALOAD(2);
                    this._AASTORE();
                    this.visitLabel(end);
                    this._INVOKEINTERFACE(DYNAMIC_OBJECT_TYPE, "invokeMethod", Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{STRING_TYPE, OBJECT_ARRAY_TYPE}));
                }
            });
        }

        @Override
        public void applyServiceInjectionToProperty(AbstractClassGenerator.PropertyMetadata property2) {
            this.addField(130, AsmBackedClassGenerator.propFieldName(property2), property2.getType());
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property2, AbstractClassGenerator.MethodMetadata getter) {
            this.applyServiceInjectionToGetter(property2, null, getter);
        }

        @Override
        public void applyServiceInjectionToGetter(AbstractClassGenerator.PropertyMetadata property2, final @Nullable Class<? extends Annotation> annotation, AbstractClassGenerator.MethodMetadata getter) {
            final String getterName = getter.getName();
            Type returnType = Type.getType(getter.getReturnType());
            String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[0]);
            final Type serviceType = Type.getType(property2.getType());
            final java.lang.reflect.Type genericServiceType = property2.getGenericType();
            String propFieldName = AsmBackedClassGenerator.propFieldName(property2);
            String signature = AsmClassGeneratorUtils.getterSignature(getter.getGenericReturnType());
            BytecodeFragment getterInitializer = methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this.putServiceRegistryOnStack();
                    if (genericServiceType instanceof Class) {
                        this._LDC(Type.getType((Class)((Class)genericServiceType)));
                    } else {
                        String constantFieldName = this.getConstantNameForGenericReturnType(genericServiceType, getterName);
                        this._GETSTATIC(generatedType, constantFieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
                    }
                    if (annotation == null) {
                        this._INVOKEINTERFACE(SERVICE_LOOKUP_TYPE, "get", RETURN_OBJECT_FROM_TYPE);
                    } else {
                        this._LDC(Type.getType((Class)annotation));
                        this._INVOKEINTERFACE(SERVICE_LOOKUP_TYPE, "get", Type.getMethodDescriptor((Type)OBJECT_TYPE, (Type[])new Type[]{JAVA_LANG_REFLECT_TYPE, CLASS_TYPE}));
                    }
                    this._CHECKCAST(serviceType);
                }
            };
            BytecodeFragment getterEpilogue = this.getInjectedServiceGetterEpilogue(serviceType, getterName);
            this.addLazyGetter(getterName, returnType, methodDescriptor, signature, propFieldName, serviceType, getterInitializer, getterEpilogue);
        }

        private BytecodeFragment getInjectedServiceGetterEpilogue(final Type serviceType, final String getterName) {
            if (DISALLOWED_AT_EXECUTION_INJECTED_SERVICES_TYPES.contains(serviceType)) {
                return methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        this._LDC(serviceType);
                        this._LDC(getterName);
                        this._LDC(type.getName());
                        this._INVOKESTATIC(INSTRUMENTED_EXECUTION_ACCESS_TYPE, "disallowedAtExecutionInjectedServiceAccessed", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{CLASS_TYPE, STRING_TYPE, STRING_TYPE}));
                    }
                };
            }
            return BytecodeFragment.NO_OP;
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property2, Class<? extends Annotation> annotation, Method setter) {
            this.applyServiceInjectionToSetter(property2, setter);
        }

        private String getConstantNameForGenericReturnType(java.lang.reflect.Type genericReturnType, String getterName) {
            ReturnTypeEntry entry = this.genericReturnTypeConstantsIndex.get(genericReturnType);
            if (entry == null) {
                String fieldName = "_GENERIC_RETURN_TYPE_" + this.genericReturnTypeConstantsIndex.size();
                entry = new ReturnTypeEntry(fieldName, getterName);
                this.genericReturnTypeConstantsIndex.put(genericReturnType, entry);
            }
            return entry.fieldName;
        }

        @Override
        public void applyServiceInjectionToSetter(AbstractClassGenerator.PropertyMetadata property2, Method setter) {
            this.addSetterForProperty(property2, setter);
        }

        @Override
        public void applyManagedStateToProperty(AbstractClassGenerator.PropertyMetadata property2) {
            this.addField(2, AsmBackedClassGenerator.propFieldName(property2), property2.getType());
        }

        @Override
        public void applyReadOnlyManagedStateToGetter(final AbstractClassGenerator.PropertyMetadata property2, Method getter, final boolean applyRole) {
            final Type propType = Type.getType(property2.getType());
            Type returnType = Type.getType(getter.getReturnType());
            String descriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[0]);
            String fieldName = AsmBackedClassGenerator.propFieldName(property2);
            this.addLazyGetter(getter.getName(), returnType, descriptor, fieldName, propType, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    String buildServiceName;
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.FACTORY_METHOD, RETURN_MANAGED_OBJECT_FACTORY);
                    this._ALOAD(0);
                    this._LDC(property2.getName());
                    switch (property2.getType().getTypeParameters().length) {
                        case 1: {
                            Type elementType = Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property2, 0));
                            this._LDC(propType);
                            this._LDC(elementType);
                            this._INVOKEVIRTUAL(MANAGED_OBJECT_FACTORY_TYPE, "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS);
                            break;
                        }
                        case 2: {
                            Type keyType = Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property2, 0));
                            Type valueType = Type.getType((Class)AsmBackedClassGenerator.rawTypeParam(property2, 1));
                            this._LDC(propType);
                            this._LDC(keyType);
                            this._LDC(valueType);
                            this._INVOKEVIRTUAL(MANAGED_OBJECT_FACTORY_TYPE, "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS_CLASS_CLASS);
                            break;
                        }
                        default: {
                            this._LDC(propType);
                            this._INVOKEVIRTUAL(MANAGED_OBJECT_FACTORY_TYPE, "newInstance", RETURN_OBJECT_FROM_MODEL_OBJECT_STRING_CLASS);
                        }
                    }
                    if (applyRole) {
                        this._DUP();
                        this.applyRole();
                    }
                    if ((buildServiceName = AsmBackedClassGenerator.getBuildServiceName(property2)) != null) {
                        this._DUP();
                        this.setBuildServiceConvention(buildServiceName);
                    }
                    this._CHECKCAST(propType);
                }
            });
        }

        @Override
        public void applyManagedStateToGetter(final AbstractClassGenerator.PropertyMetadata property2, Method getter) {
            final Type returnType = Type.getType(getter.getReturnType());
            this.addGetter(getter.getName(), returnType, Type.getMethodDescriptor((Type)returnType, (Type[])new Type[0]), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property2), returnType);
                }
            });
        }

        @Override
        public void applyManagedStateToSetter(AbstractClassGenerator.PropertyMetadata property2, Method setter) {
            this.addSetterForProperty(property2, setter);
        }

        private void addSetterForProperty(final AbstractClassGenerator.PropertyMetadata property2, Method setter) {
            final Type fieldType = Type.getType(property2.getType());
            this.addSetter(setter.getName(), Type.getMethodDescriptor((Method)setter), AsmClassGeneratorUtils.signature(setter), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ILOAD_OF(fieldType, 1);
                    this._PUTFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property2), fieldType);
                }
            });
        }

        private void generateGeneratedSubtypeMethods() {
            this.publicMethod("publicType", RETURN_CLASS, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._LDC(superclassType);
                    this._ARETURN();
                }
            });
            this.addMethod(9, "generatedFrom", RETURN_CLASS, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._LDC(superclassType);
                    this._ARETURN();
                }
            });
        }

        private void generateModelObjectMethods() {
            this.addField(4098, DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
            this.addField(4098, OWNER_FIELD, MODEL_OBJECT_TYPE);
            this.publicMethod("hasUsefulDisplayName", RETURN_BOOLEAN, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    if (requiresToString) {
                        this._ALOAD(0);
                        this._GETFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                        Label label = new Label();
                        this._IFNULL(label);
                        this._LDC(true);
                        this._IRETURN_OF(Type.BOOLEAN_TYPE);
                        this.visitLabel(label);
                        this._LDC(false);
                        this._IRETURN_OF(Type.BOOLEAN_TYPE);
                    } else {
                        this._LDC(true);
                        this._IRETURN_OF(Type.BOOLEAN_TYPE);
                    }
                }
            });
            this.publicMethod("getModelIdentityDisplayName", RETURN_DESCRIBABLE, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                    this._ARETURN();
                }
            });
            this.publicMethod("getTaskThatOwnsThisObject", Type.getMethodDescriptor((Type)Type.getType(Task.class), (Type[])new Type[0]), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    if (Task.class.isAssignableFrom(type)) {
                        this._ALOAD(0);
                    } else {
                        this._ALOAD(0);
                        this._GETFIELD(generatedType, ClassBuilderImpl.OWNER_FIELD, MODEL_OBJECT_TYPE);
                        this._DUP();
                        Label useNull = new Label();
                        this._IFNULL(useNull);
                        this._INVOKEINTERFACE(MODEL_OBJECT_TYPE, "getTaskThatOwnsThisObject", Type.getMethodDescriptor((Type)Type.getType(Task.class), (Type[])new Type[0]));
                        this.visitLabel(useNull);
                    }
                    this._ARETURN();
                }
            });
            this.publicMethod("attachOwner", RETURN_VOID_FROM_MODEL_OBJECT_DISPLAY_NAME, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ALOAD(1);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.OWNER_FIELD, MODEL_OBJECT_TYPE);
                    this._ALOAD(0);
                    this._ALOAD(2);
                    this._PUTFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                    this._RETURN();
                }
            });
            this.publicMethod("attachModelProperties", RETURN_VOID, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(generatedType, ClassBuilderImpl.INIT_ATTACH_METHOD, RETURN_VOID);
                    for (AttachedProperty attached : propertiesToAttachOnDemand) {
                        this.attachProperty(attached);
                    }
                    this._RETURN();
                }
            });
        }

        @Override
        public void addManagedMethods(final List<AbstractClassGenerator.PropertyMetadata> mutableProperties, final List<AbstractClassGenerator.PropertyMetadata> readOnlyProperties) {
            this.addField(10, FACTORY_ID_FIELD, Type.INT_TYPE);
            final int mutablePropertySize = mutableProperties.size();
            final int readOnlyPropertySize = readOnlyProperties.size();
            this.addMethod(4097, "initFromState", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{OBJECT_ARRAY_TYPE}), methodVisitor -> new MethodVisitorScope(methodVisitor){
                int propertyIndex;
                {
                    super(methodVisitor);
                    this.loadPropertiesFromState(mutableProperties);
                    this.loadPropertiesFromState(readOnlyProperties);
                    this._RETURN();
                    this.propertyIndex = 0;
                }

                private void loadPropertiesFromState(List<AbstractClassGenerator.PropertyMetadata> properties) {
                    for (AbstractClassGenerator.PropertyMetadata property2 : properties) {
                        this._ALOAD(0);
                        this._ALOAD(1);
                        this._LDC(this.propertyIndex);
                        this._AALOAD();
                        Type propertyType = Type.getType(property2.getType());
                        this._UNBOX(propertyType);
                        this._PUTFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property2), propertyType);
                        ++this.propertyIndex;
                    }
                }
            });
            this.publicMethod("isImmutable", RETURN_BOOLEAN, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._LDC(mutablePropertySize == 0 && readOnlyPropertySize == 0);
                    this._IRETURN();
                }
            });
            this.publicMethod("unpackState", RETURN_OBJECT, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    Type propertyType;
                    super(methodVisitor);
                    this._LDC(mutablePropertySize + readOnlyPropertySize);
                    this._ANEWARRAY(OBJECT_TYPE);
                    int propertyIndex = 0;
                    for (AbstractClassGenerator.PropertyMetadata property2 : mutableProperties) {
                        String propFieldName = AsmBackedClassGenerator.propFieldName(property2);
                        this._DUP();
                        this._LDC(propertyIndex);
                        this._ALOAD(0);
                        propertyType = Type.getType(property2.getType());
                        this._GETFIELD(generatedType, propFieldName, propertyType);
                        this._AUTOBOX(property2.getType(), propertyType);
                        this._AASTORE();
                        ++propertyIndex;
                    }
                    for (AbstractClassGenerator.PropertyMetadata property2 : readOnlyProperties) {
                        this._DUP();
                        this._LDC(propertyIndex);
                        this._ALOAD(0);
                        AbstractClassGenerator.MethodMetadata getter = property2.getMainGetter();
                        this._INVOKEVIRTUAL(generatedType, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(getter.getReturnType()), (Type[])new Type[0]));
                        propertyType = Type.getType(property2.getType());
                        this._AUTOBOX(property2.getType(), propertyType);
                        this._AASTORE();
                        ++propertyIndex;
                    }
                    this._ARETURN();
                }
            });
            this.publicMethod("getFactoryId", Type.getMethodDescriptor((Type)Type.INT_TYPE, (Type[])new Type[0]), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._GETSTATIC(generatedType, ClassBuilderImpl.FACTORY_ID_FIELD, Type.INT_TYPE);
                    this._IRETURN();
                }
            });
        }

        @Override
        public void applyConventionMappingToProperty(AbstractClassGenerator.PropertyMetadata property2) {
            if (!this.conventionAware) {
                return;
            }
            this.addField(130, AsmBackedClassGenerator.propFieldName(property2), Type.BOOLEAN_TYPE);
        }

        @Override
        public void applyConventionMappingToGetter(final AbstractClassGenerator.PropertyMetadata property2, final AbstractClassGenerator.MethodMetadata getter, final boolean attachOwner, final boolean applyRole) {
            if (!this.conventionAware && !attachOwner) {
                return;
            }
            final String getterName = getter.getName();
            final Type returnType = Type.getType(getter.getReturnType());
            final String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[0]);
            this.publicMethod(getterName, methodDescriptor, methodVisitor -> new LocalMethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    if (conventionAware) {
                        Label finish = new Label();
                        if (hasMappingField) {
                            this._ALOAD(0);
                            this._GETFIELD(generatedType, ClassBuilderImpl.MAPPING_FIELD, CONVENTION_MAPPING_FIELD_DESCRIPTOR);
                            Label useConvention = new Label();
                            this._IFNONNULL(useConvention);
                            this._ALOAD(0);
                            this._INVOKESPECIAL(superclassType, getterName, methodDescriptor, type.isInterface());
                            this._GOTO(finish);
                            this.visitLabel(useConvention);
                        }
                        this._ALOAD(0);
                        this._INVOKEINTERFACE(CONVENTION_AWARE_TYPE, "getConventionMapping", Type.getMethodDescriptor((Type)CONVENTION_MAPPING_TYPE, (Type[])new Type[0]));
                        this._ALOAD(0);
                        this._INVOKESPECIAL(superclassType, getterName, methodDescriptor, type.isInterface());
                        this._AUTOBOX(getter.getReturnType(), returnType);
                        this._LDC(property2.getName());
                        this._ALOAD(0);
                        this._GETFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property2), Type.BOOLEAN_TYPE);
                        this._INVOKEINTERFACE(CONVENTION_MAPPING_TYPE, "getConventionValue", RETURN_OBJECT_FROM_STRING_OBJECT_BOOLEAN);
                        this._UNBOX(returnType);
                        this.visitLabel(finish);
                    } else {
                        this._ALOAD(0);
                        this._INVOKESPECIAL(superclassType, getterName, methodDescriptor, type.isInterface());
                    }
                    if (attachOwner) {
                        this._DUP();
                        this._ALOAD(0);
                        this._LDC(property2.getName());
                        this._INVOKESTATIC(MANAGED_OBJECT_FACTORY_TYPE, "attachOwner", RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING);
                        this._POP();
                        if (applyRole) {
                            this._DUP();
                            this.applyRole();
                        }
                    }
                    this._IRETURN_OF(returnType);
                }
            });
        }

        @Override
        public void addSetMethod(AbstractClassGenerator.PropertyMetadata property2, final Method setter) {
            if (!this.mixInDsl) {
                return;
            }
            final Type paramType = Type.getType(setter.getParameterTypes()[0]);
            Type returnType = Type.getType(setter.getReturnType());
            final String setterDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[]{paramType});
            this.addSetter(property2.getName(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{paramType}), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ILOAD_OF(paramType, 1);
                    this._INVOKEVIRTUAL(generatedType, setter.getName(), setterDescriptor);
                }
            });
        }

        @Override
        public void applyConventionMappingToSetter(AbstractClassGenerator.PropertyMetadata property2, Method setter) {
            if (!this.conventionAware) {
                return;
            }
            this.addConventionSetter(setter, property2);
        }

        @Override
        public void applyConventionMappingToSetMethod(AbstractClassGenerator.PropertyMetadata property2, Method setter) {
            if (!this.mixInDsl || !this.conventionAware) {
                return;
            }
            this.addConventionSetter(setter, property2);
        }

        private void addConventionSetter(final Method setter, final AbstractClassGenerator.PropertyMetadata property2) {
            final Type paramType = Type.getType(setter.getParameterTypes()[0]);
            final Type returnType = Type.getType(setter.getReturnType());
            final String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])new Type[]{paramType});
            this.publicMethod(setter.getName(), methodDescriptor, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._ILOAD_OF(paramType, 1);
                    this._INVOKESPECIAL(superclassType, setter.getName(), methodDescriptor);
                    this._ALOAD(0);
                    this._LDC(true);
                    this._PUTFIELD(generatedType, AsmBackedClassGenerator.propFieldName(property2), Type.BOOLEAN_TYPE);
                    this._IRETURN_OF(returnType);
                }
            });
        }

        @Override
        public void addActionMethod(final Method method) {
            if (!this.mixInDsl) {
                return;
            }
            final Type returnType = Type.getType(method.getReturnType());
            final Type[] originalParameterTypes = CollectionUtils.collectArray(method.getParameterTypes(), Type.class, Type::getType);
            final int numParams = originalParameterTypes.length;
            final Type[] closurisedParameterTypes = new Type[numParams];
            System.arraycopy(originalParameterTypes, 0, closurisedParameterTypes, 0, numParams);
            closurisedParameterTypes[numParams - 1] = CLOSURE_TYPE;
            String methodDescriptor = Type.getMethodDescriptor((Type)returnType, (Type[])closurisedParameterTypes);
            this.publicMethod(method.getName(), methodDescriptor, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    int stackVar = 1;
                    for (int typeVar = 0; typeVar < numParams - 1; ++typeVar) {
                        Type argType = closurisedParameterTypes[typeVar];
                        this._ILOAD_OF(argType, stackVar);
                        stackVar += argType.getSize();
                    }
                    this._ALOAD(stackVar);
                    this._INVOKESTATIC(CONFIGURE_UTIL_TYPE, "configureUsing", Type.getMethodDescriptor((Type)ACTION_TYPE, (Type[])new Type[]{CLOSURE_TYPE}));
                    this._INVOKEVIRTUAL(generatedType, method.getName(), Type.getMethodDescriptor((Type)Type.getType(method.getReturnType()), (Type[])originalParameterTypes));
                    this._IRETURN_OF(returnType);
                }
            });
        }

        private void generateToStringSupport() {
            this.publicMethod("toString", RETURN_STRING, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, ClassBuilderImpl.DISPLAY_NAME_FIELD, DESCRIBABLE_TYPE);
                    this._DUP();
                    Label label1 = new Label();
                    this._IFNULL(label1);
                    this._INVOKEINTERFACE(DESCRIBABLE_TYPE, "getDisplayName", RETURN_STRING);
                    this._ARETURN();
                    this.visitLabel(label1);
                    this._ALOAD(0);
                    this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, AsmBackedClassGenerator.GET_DISPLAY_NAME_FOR_NEXT_METHOD_NAME, RETURN_DESCRIBABLE);
                    this._DUP();
                    Label label2 = new Label();
                    this._IFNULL(label2);
                    this._INVOKEINTERFACE(DESCRIBABLE_TYPE, "getDisplayName", RETURN_STRING);
                    this._ARETURN();
                    this.visitLabel(label2);
                    this._ALOAD(0);
                    this._INVOKESPECIAL(OBJECT_TYPE, "toString", RETURN_STRING);
                    this._ARETURN();
                }
            });
        }

        private void generateServiceRegistrySupport() {
            this.addServiceSupport(SERVICES_FIELD, SERVICE_LOOKUP_TYPE, SERVICES_METHOD, AsmBackedClassGenerator.GET_SERVICES_FOR_NEXT_METHOD_NAME, RETURN_SERVICE_LOOKUP);
        }

        private void generateManagedPropertyCreationSupport() {
            this.addServiceSupport(FACTORY_FIELD, MANAGED_OBJECT_FACTORY_TYPE, FACTORY_METHOD, AsmBackedClassGenerator.GET_FACTORY_FOR_NEXT_METHOD_NAME, RETURN_MANAGED_OBJECT_FACTORY);
        }

        private void addServiceSupport(String fieldName, Type fieldType, String getterName, String runtimeGetterName, String getterDescriptor) {
            this.addField(4226, fieldName, fieldType);
            this.addServiceGetter(getterName, fieldName, fieldType, runtimeGetterName, getterDescriptor);
        }

        private void includeNotInheritedAnnotations() {
            for (Annotation annotation : this.type.getDeclaredAnnotations()) {
                if (annotation.annotationType().getAnnotation(Inherited.class) != null) continue;
                Retention retention = annotation.annotationType().getAnnotation(Retention.class);
                boolean visible = retention != null && retention.value() == RetentionPolicy.RUNTIME;
                AnnotationVisitor annotationVisitor = this.visitAnnotation(AsmBackedClassGenerator.descriptorOf(annotation.annotationType()), visible);
                this.visitAnnotationValues(annotation, annotationVisitor);
                annotationVisitor.visitEnd();
            }
        }

        private void visitAnnotationValues(Annotation annotation, AnnotationVisitor annotationVisitor) {
            for (Method method : annotation.annotationType().getDeclaredMethods()) {
                String name = method.getName();
                Class<?> returnType = method.getReturnType();
                if (returnType.isEnum()) {
                    annotationVisitor.visitEnum(name, AsmBackedClassGenerator.descriptorOf(returnType), ClassBuilderImpl.getAnnotationParameterValue(annotation, method).toString());
                    continue;
                }
                if (returnType.isArray() && !PRIMITIVE_TYPES.contains(returnType.getComponentType())) {
                    AnnotationVisitor arrayVisitor = annotationVisitor.visitArray(name);
                    Object[] elements = (Object[])ClassBuilderImpl.getAnnotationParameterValue(annotation, method);
                    this.visitArrayElements(arrayVisitor, returnType.getComponentType(), elements);
                    arrayVisitor.visitEnd();
                    continue;
                }
                if (returnType.equals(Class.class)) {
                    Class clazz = (Class)ClassBuilderImpl.getAnnotationParameterValue(annotation, method);
                    annotationVisitor.visit(name, (Object)Type.getType((Class)clazz));
                    continue;
                }
                if (returnType.isAnnotation()) {
                    Annotation nestedAnnotation = (Annotation)ClassBuilderImpl.getAnnotationParameterValue(annotation, method);
                    AnnotationVisitor nestedAnnotationVisitor = annotationVisitor.visitAnnotation(name, AsmBackedClassGenerator.descriptorOf(returnType));
                    this.visitAnnotationValues(nestedAnnotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                    continue;
                }
                annotationVisitor.visit(name, ClassBuilderImpl.getAnnotationParameterValue(annotation, method));
            }
        }

        private void visitArrayElements(AnnotationVisitor arrayVisitor, Class<?> arrayElementType, Object[] arrayElements) {
            if (arrayElementType.isEnum()) {
                String enumDescriptor = AsmBackedClassGenerator.descriptorOf(arrayElementType);
                for (Object value : arrayElements) {
                    arrayVisitor.visitEnum(null, enumDescriptor, value.toString());
                }
            } else if (arrayElementType.equals(Class.class)) {
                for (Object value : arrayElements) {
                    Class clazz = (Class)value;
                    arrayVisitor.visit(null, (Object)Type.getType((Class)clazz));
                }
            } else if (arrayElementType.isAnnotation()) {
                for (Object annotation : arrayElements) {
                    AnnotationVisitor nestedAnnotationVisitor = arrayVisitor.visitAnnotation(null, AsmBackedClassGenerator.descriptorOf(arrayElementType));
                    this.visitAnnotationValues((Annotation)annotation, nestedAnnotationVisitor);
                    nestedAnnotationVisitor.visitEnd();
                }
            } else {
                for (Object value : arrayElements) {
                    arrayVisitor.visit(null, value);
                }
            }
        }

        private static Object getAnnotationParameterValue(Annotation annotation, Method method) {
            try {
                return method.invoke((Object)annotation, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        private static void attachFactoryIdToImplType(Class<?> implClass, int id) {
            try {
                Field factoryField = implClass.getDeclaredField(FACTORY_ID_FIELD);
                factoryField.setAccessible(true);
                factoryField.set(null, id);
            }
            catch (Exception e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }

        @Override
        public void addNameProperty() {
            this.addField(4114, NAME_FIELD, STRING_TYPE);
            this.addGetter("getName", STRING_TYPE, Type.getMethodDescriptor((Type)STRING_TYPE, (Type[])new Type[0]), methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, ClassBuilderImpl.NAME_FIELD, STRING_TYPE);
                }
            });
        }

        @Override
        public Class<?> generate() {
            this.writeGenericReturnTypeFields();
            this.visitEnd();
            Class generatedClass = this.classGenerator.define();
            if (this.managed) {
                ClassBuilderImpl.attachFactoryIdToImplType(generatedClass, this.factoryId);
            }
            return generatedClass;
        }

        private void writeGenericReturnTypeFields() {
            if (!this.genericReturnTypeConstantsIndex.isEmpty()) {
                this.addMethod(8, "<clinit>", "()V", methodVisitor -> new MethodVisitorScope(methodVisitor){
                    {
                        super(methodVisitor);
                        for (Map.Entry entry : genericReturnTypeConstantsIndex.entrySet()) {
                            ReturnTypeEntry returnType = (ReturnTypeEntry)entry.getValue();
                            this.addField(4122, returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
                            this._LDC(generatedType);
                            this._LDC(returnType.getterName);
                            this._ICONST_0();
                            this._ANEWARRAY(CLASS_TYPE);
                            this._INVOKEVIRTUAL(CLASS_TYPE, "getDeclaredMethod", GET_DECLARED_METHOD_DESCRIPTOR);
                            this._INVOKEVIRTUAL(METHOD_TYPE, "getGenericReturnType", Type.getMethodDescriptor((Type)JAVA_LANG_REFLECT_TYPE, (Type[])new Type[0]));
                            this._PUTSTATIC(generatedType, returnType.fieldName, JAVA_REFLECT_TYPE_DESCRIPTOR);
                        }
                        this._RETURN();
                    }
                });
            }
        }

        private void addServiceGetter(String name, final String fieldName, final Type fieldType, final String runtimeGetterName, final String getterDescriptor) {
            this.privateSyntheticMethod(name, getterDescriptor, methodVisitor -> new MethodVisitorScope(methodVisitor){
                {
                    super(methodVisitor);
                    this._ALOAD(0);
                    this._GETFIELD(generatedType, fieldName, fieldType);
                    this._DUP();
                    Label label = new Label();
                    this._IFNULL(label);
                    this._ARETURN();
                    this.visitLabel(label);
                    this._INVOKESTATIC(ASM_BACKED_CLASS_GENERATOR_TYPE, runtimeGetterName, getterDescriptor);
                    this._ARETURN();
                }
            });
        }

        private static final class ReturnTypeEntry {
            private final String fieldName;
            private final String getterName;

            private ReturnTypeEntry(String fieldName, String getterName) {
                this.fieldName = fieldName;
                this.getterName = getterName;
            }
        }

        private class LocalMethodVisitorScope
        extends MethodVisitorScope {
            public LocalMethodVisitorScope(MethodVisitor methodVisitor) {
                super(methodVisitor);
            }

            protected void attachProperty(AttachedProperty attached) {
                AbstractClassGenerator.PropertyMetadata property2 = attached.property;
                boolean applyRole = attached.applyRole;
                AbstractClassGenerator.MethodMetadata getter = property2.getMainGetter();
                this._ALOAD(0);
                this._INVOKEVIRTUAL(ClassBuilderImpl.this.generatedType, getter.getName(), Type.getMethodDescriptor((Type)Type.getType(getter.getReturnType()), (Type[])new Type[0]));
                if (applyRole) {
                    this._DUP();
                }
                this._ALOAD(0);
                this._LDC(property2.getName());
                this._INVOKESTATIC(MANAGED_OBJECT_FACTORY_TYPE, "attachOwner", RETURN_OBJECT_FROM_OBJECT_MODEL_OBJECT_STRING);
                if (applyRole) {
                    this.applyRole();
                }
            }

            protected void applyRole() {
                this._ALOAD(0);
                this._INVOKEVIRTUAL(ClassBuilderImpl.this.generatedType, ClassBuilderImpl.FACTORY_METHOD, RETURN_MANAGED_OBJECT_FACTORY);
                this._SWAP();
                this._ALOAD(0);
                this._INVOKEVIRTUAL(MANAGED_OBJECT_FACTORY_TYPE, "applyRole", RETURN_VOID_FROM_OBJECT_MODEL_OBJECT);
            }

            protected void setBuildServiceConvention(@Nullable String serviceName) {
                this._CHECKCAST(DEFAULT_PROPERTY_TYPE);
                this.putServiceRegistryOnStack();
                this._LDC(serviceName);
                this._INVOKESTATIC(BUILD_SERVICE_PROVIDER_TYPE, "setBuildServiceAsConvention", RETURN_VOID_FROM_DEFAULT_PROPERTY_SERVICE_LOOKUP_STRING);
            }

            protected void putServiceRegistryOnStack() {
                if (ClassBuilderImpl.this.requiresServicesMethod) {
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(ClassBuilderImpl.this.generatedType, ClassBuilderImpl.SERVICES_METHOD, RETURN_SERVICE_LOOKUP);
                } else {
                    this._ALOAD(0);
                    this._INVOKEVIRTUAL(ClassBuilderImpl.this.generatedType, "getServices", RETURN_SERVICE_REGISTRY);
                }
            }
        }
    }

    private static class ClassInspectionVisitorImpl
    implements AbstractClassGenerator.ClassInspectionVisitor {
        private final Class<?> type;
        private final boolean decorate;
        private final String suffix;
        private final int factoryId;
        private boolean extensible;
        private boolean serviceInjection;
        private boolean conventionAware;
        private boolean managed;
        private boolean providesOwnDynamicObjectImplementation;
        private boolean providesOwnServicesImplementation;
        private boolean providesOwnToStringImplementation;
        private boolean requiresFactory;
        private final List<AttachedProperty> propertiesToAttachAtConstruction = new ArrayList<AttachedProperty>();
        private final List<AttachedProperty> propertiesToAttachOnDemand = new ArrayList<AttachedProperty>();
        private final List<AbstractClassGenerator.PropertyMetadata> ineligibleProperties = new ArrayList<AbstractClassGenerator.PropertyMetadata>();

        public ClassInspectionVisitorImpl(Class<?> type, boolean decorate, String suffix, int factoryId) {
            this.type = type;
            this.decorate = decorate;
            this.suffix = suffix;
            this.factoryId = factoryId;
        }

        @Override
        public void mixInServiceInjection() {
            this.serviceInjection = true;
        }

        @Override
        public void mixInExtensible() {
            if (this.decorate) {
                this.extensible = true;
            }
        }

        @Override
        public void mixInConventionAware() {
            if (this.decorate) {
                this.conventionAware = true;
            }
        }

        @Override
        public void mixInFullyManagedState() {
            this.managed = true;
        }

        @Override
        public void providesOwnServicesImplementation() {
            this.providesOwnServicesImplementation = true;
        }

        @Override
        public void providesOwnDynamicObjectImplementation() {
            this.providesOwnDynamicObjectImplementation = true;
        }

        @Override
        public void providesOwnToString() {
            this.providesOwnToStringImplementation = true;
        }

        @Override
        public void instantiatesNestedObjects() {
            this.requiresFactory = true;
        }

        @Override
        public void attachDuringConstruction(AbstractClassGenerator.PropertyMetadata property2, boolean applyRole) {
            this.attachTo(this.propertiesToAttachAtConstruction, property2, applyRole);
        }

        @Override
        public void attachOnDemand(AbstractClassGenerator.PropertyMetadata property2, boolean applyRole) {
            this.attachTo(this.propertiesToAttachOnDemand, property2, applyRole);
        }

        private void attachTo(List<AttachedProperty> properties, AbstractClassGenerator.PropertyMetadata property2, boolean applyRole) {
            properties.add(AttachedProperty.of(property2, applyRole));
            if (applyRole) {
                this.requiresFactory = true;
            }
        }

        @Override
        public void markPropertyAsIneligibleForConventionMapping(AbstractClassGenerator.PropertyMetadata property2) {
            this.ineligibleProperties.add(property2);
        }

        @Override
        public AbstractClassGenerator.ClassGenerationVisitor builder() {
            if (!(this.decorate || this.serviceInjection || Modifier.isAbstract(this.type.getModifiers()))) {
                return new NoOpBuilder(this.type);
            }
            int modifiers = this.type.getModifiers();
            if (Modifier.isPrivate(modifiers)) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node(this.type);
                formatter.append(" is private.");
                throw new ClassGenerationException(formatter.toString());
            }
            if (Modifier.isFinal(modifiers)) {
                TreeFormatter formatter = new TreeFormatter();
                formatter.node(this.type);
                formatter.append(" is final.");
                throw new ClassGenerationException(formatter.toString());
            }
            boolean requiresServicesMethod = (this.extensible || this.serviceInjection) && !this.providesOwnServicesImplementation;
            boolean requiresToString = !this.providesOwnToStringImplementation;
            ClassBuilderImpl builder = new ClassBuilderImpl(new AsmClassGenerator(this.type, this.suffix), this.decorate, this.factoryId, this.extensible, this.conventionAware, this.managed, this.providesOwnDynamicObjectImplementation, requiresToString, requiresServicesMethod, this.requiresFactory, this.propertiesToAttachAtConstruction, this.propertiesToAttachOnDemand, this.ineligibleProperties);
            builder.startClass();
            return builder;
        }
    }

    private static class AttachedProperty {
        public final AbstractClassGenerator.PropertyMetadata property;
        public final boolean applyRole;

        public static AttachedProperty of(AbstractClassGenerator.PropertyMetadata property2, boolean applyRole) {
            return new AttachedProperty(property2, applyRole);
        }

        private AttachedProperty(AbstractClassGenerator.PropertyMetadata property2, boolean applyRole) {
            this.property = property2;
            this.applyRole = applyRole;
        }
    }
}

