/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.featurelifecycle;

import java.util.ArrayList;
import java.util.List;
import org.gradle.problems.buildtree.ProblemStream;

class StackTraceSanitizer
implements ProblemStream.StackTraceTransformer {
    private final Class<?> calledFrom;

    public StackTraceSanitizer(Class<?> calledFrom) {
        this.calledFrom = calledFrom;
    }

    @Override
    public List<StackTraceElement> transform(StackTraceElement[] originalStack) {
        int caller;
        ArrayList<StackTraceElement> result2 = new ArrayList<StackTraceElement>();
        String calledFromName = this.calledFrom.getName();
        boolean calledFromFound = false;
        for (caller = 0; caller < originalStack.length; ++caller) {
            StackTraceElement current = originalStack[caller];
            if (!calledFromFound) {
                if (!current.getClassName().startsWith(calledFromName)) continue;
                calledFromFound = true;
                continue;
            }
            if (!current.getClassName().startsWith(calledFromName)) break;
        }
        while (caller < originalStack.length) {
            StackTraceElement stackTraceElement = originalStack[caller];
            if (!StackTraceSanitizer.isSystemStackFrame(stackTraceElement.getClassName())) {
                result2.add(stackTraceElement);
            }
            ++caller;
        }
        return result2;
    }

    private static boolean isSystemStackFrame(String className) {
        return className.startsWith("jdk.internal.") || className.startsWith("sun.") || className.startsWith("com.sun.") || className.startsWith("org.codehaus.groovy.") || className.startsWith("org.gradle.internal.metaobject.") || className.startsWith("org.gradle.kotlin.dsl.execution.");
    }
}

