/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.model.annotations;

import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.problems.Severity;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.execution.model.annotations.AbstractInputPropertyAnnotationHandler;
import org.gradle.internal.execution.model.annotations.ModifierAnnotationCategory;
import org.gradle.internal.properties.PropertyValue;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.annotations.PropertyMetadata;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.TypeValidationContext;
import org.gradle.model.internal.type.ModelType;

public class InputPropertyAnnotationHandler
extends AbstractInputPropertyAnnotationHandler {
    public InputPropertyAnnotationHandler() {
        super(Input.class, ModifierAnnotationCategory.annotationsOf(ModifierAnnotationCategory.OPTIONAL));
    }

    @Override
    public boolean isPropertyRelevant() {
        return true;
    }

    @Override
    public void visitPropertyValue(String propertyName, PropertyValue value, PropertyMetadata propertyMetadata, PropertyVisitor visitor) {
        visitor.visitInputProperty(propertyName, value, propertyMetadata.isAnnotationPresent(Optional.class));
    }

    @Override
    public void validatePropertyMetadata(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        InputPropertyAnnotationHandler.validateUnsupportedInputPropertyValueTypes(propertyMetadata, validationContext, this.getAnnotationType());
        Class valueType = propertyMetadata.getDeclaredType().getRawType();
        this.validateNotDirectoryType(propertyMetadata, validationContext, valueType);
        this.validateNotFileType(propertyMetadata, validationContext, valueType);
        this.validateNotOptionalPrimitiveType(propertyMetadata, validationContext, valueType);
        InputPropertyAnnotationHandler.validateNotUrlType(propertyMetadata, validationContext);
    }

    private void validateNotOptionalPrimitiveType(PropertyMetadata propertyMetadata, TypeValidationContext validationContext, Class<?> valueType) {
        if (valueType.isPrimitive() && propertyMetadata.isAnnotationPresent(Optional.class)) {
            validationContext.visitPropertyProblem(problem2 -> problem2.forProperty(propertyMetadata.getPropertyName()).label("of type %s shouldn't be annotated with @Optional", valueType.getName()).documentedAt(Documentation.userManual("validation_problems", "cannot_use_optional_on_primitive_types")).noLocation().type(ValidationProblemId.CANNOT_USE_OPTIONAL_ON_PRIMITIVE_TYPE.name()).group("type_validation").details("Properties of primitive type cannot be optional").severity(Severity.ERROR).solution("Remove the @Optional annotation").solution("Use the " + JavaReflectionUtil.getWrapperTypeForPrimitiveType(valueType).getName() + " type instead"));
        }
    }

    private void validateNotFileType(PropertyMetadata propertyMetadata, TypeValidationContext validationContext, Class<?> valueType) {
        if (File.class.isAssignableFrom(valueType) || RegularFile.class.isAssignableFrom(valueType) || RegularFileProperty.class.isAssignableFrom(valueType) || Path.class.isAssignableFrom(valueType) || FileCollection.class.isAssignableFrom(valueType)) {
            validationContext.visitPropertyProblem(problem2 -> problem2.forProperty(propertyMetadata.getPropertyName()).label("has @Input annotation used on property of type '%s'", ModelType.of(valueType).getDisplayName()).documentedAt(Documentation.userManual("validation_problems", "incorrect_use_of_input_annotation")).noLocation().type(ValidationProblemId.INCORRECT_USE_OF_INPUT_ANNOTATION.name()).group("type_validation").severity(Severity.ERROR).details("A property of type '" + ModelType.of(valueType).getDisplayName() + "' annotated with @Input cannot determine how to interpret the file").solution("Annotate with @InputFile for regular files").solution("Annotate with @InputFiles for collections of files").solution("If you want to track the path, return File.absolutePath as a String and keep @Input"));
        }
    }

    private void validateNotDirectoryType(PropertyMetadata propertyMetadata, TypeValidationContext validationContext, Class<?> valueType) {
        if (Directory.class.isAssignableFrom(valueType) || DirectoryProperty.class.isAssignableFrom(valueType)) {
            validationContext.visitPropertyProblem(problem2 -> problem2.forProperty(propertyMetadata.getPropertyName()).label("has @Input annotation used on property of type '%s'", ModelType.of(valueType).getDisplayName()).documentedAt(Documentation.userManual("validation_problems", "incorrect_use_of_input_annotation")).noLocation().type(ValidationProblemId.INCORRECT_USE_OF_INPUT_ANNOTATION.name()).group("type_validation").severity(Severity.ERROR).details("A property of type '" + ModelType.of(valueType).getDisplayName() + "' annotated with @Input cannot determine how to interpret the file").solution("Annotate with @InputDirectory for directories"));
        }
    }

    private static void validateNotUrlType(PropertyMetadata propertyMetadata, TypeValidationContext validationContext) {
        List<Class<?>> valueTypes = InputPropertyAnnotationHandler.unpackValueTypesOf(propertyMetadata);
        if (valueTypes.stream().anyMatch(URL.class::isAssignableFrom)) {
            validationContext.visitPropertyProblem(problem2 -> problem2.forProperty(propertyMetadata.getPropertyName()).label("has @Input annotation used on type '%s' or a property of this type", URL.class.getName()).documentedAt(Documentation.userManual("validation_problems", "unsupported_value_type")).noLocation().type(ValidationProblemId.UNSUPPORTED_VALUE_TYPE.name()).group("type_validation").severity(Severity.WARNING).details(String.format("Type '%s' is not supported on properties annotated with @Input because Java Serialization can be inconsistent for this type", URL.class.getName())).solution("Use type 'java.net.URI' instead"));
        }
    }
}

