/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.caching;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.gradle.caching.BuildCacheKey;
import org.gradle.internal.Either;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingDisabledReasonCategory;
import org.gradle.internal.execution.history.BeforeExecutionState;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class CachingState {
    public static final CachingState NOT_DETERMINED = CachingState.disabledWithoutInputs(new CachingDisabledReason(CachingDisabledReasonCategory.UNKNOWN, "Cacheability was not determined"));
    private final Either<Enabled, Disabled> delegate;

    private CachingState(Either<Enabled, Disabled> delegate) {
        this.delegate = delegate;
    }

    public static CachingState enabled(BuildCacheKey key, BeforeExecutionState beforeExecutionState) {
        return new CachingState(Either.left(new Enabled(key, beforeExecutionState)));
    }

    public static CachingState disabled(ImmutableList<CachingDisabledReason> disabledReasons, @Nullable BuildCacheKey key, @Nullable BeforeExecutionState beforeExecutionState) {
        return new CachingState(Either.right(new Disabled(disabledReasons, key, beforeExecutionState)));
    }

    public static CachingState disabledWithoutInputs(CachingDisabledReason reason) {
        return CachingState.disabled((ImmutableList<CachingDisabledReason>)ImmutableList.of((Object)reason), null, null);
    }

    public Optional<Enabled> whenEnabled() {
        return this.delegate.getLeft();
    }

    public Optional<Disabled> whenDisabled() {
        return this.delegate.getRight();
    }

    public <T> T fold(Function<Enabled, T> enabled, Function<Disabled, T> disabled) {
        return this.delegate.fold(enabled, disabled);
    }

    public void apply(Consumer<Enabled> enabled, Consumer<Disabled> disabled) {
        this.delegate.apply(enabled, disabled);
    }

    public static class Disabled {
        private final ImmutableList<CachingDisabledReason> disabledReasons;
        private final BuildCacheKey key;
        private final BeforeExecutionState beforeExecutionState;

        private Disabled(ImmutableList<CachingDisabledReason> disabledReasons, @Nullable BuildCacheKey key, @Nullable BeforeExecutionState beforeExecutionState) {
            this.disabledReasons = disabledReasons;
            this.key = key;
            this.beforeExecutionState = beforeExecutionState;
        }

        public ImmutableList<CachingDisabledReason> getDisabledReasons() {
            return this.disabledReasons;
        }

        public Optional<BuildCacheKey> getKey() {
            return Optional.ofNullable(this.key);
        }

        public Optional<BeforeExecutionState> getBeforeExecutionState() {
            return Optional.ofNullable(this.beforeExecutionState);
        }
    }

    public static class Enabled {
        private final BuildCacheKey key;
        private final BeforeExecutionState beforeExecutionState;

        private Enabled(BuildCacheKey key, BeforeExecutionState beforeExecutionState) {
            this.key = key;
            this.beforeExecutionState = beforeExecutionState;
        }

        public BuildCacheKey getKey() {
            return this.key;
        }

        public BeforeExecutionState getBeforeExecutionState() {
            return this.beforeExecutionState;
        }
    }
}

