/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.internal.DisplayName;

public class DefaultModuleComponentIdentifier
implements ModuleComponentIdentifier,
DisplayName {
    private final ModuleIdentifier moduleIdentifier;
    private final String version;
    private final int hashCode;

    public DefaultModuleComponentIdentifier(ModuleIdentifier module, String version) {
        assert (module != null) : "module cannot be null";
        assert (module.getGroup() != null) : "group cannot be null";
        assert (module.getName() != null) : "name cannot be null";
        assert (version != null) : "version cannot be null";
        this.moduleIdentifier = module;
        this.version = version;
        this.hashCode = 31 * version.hashCode() + module.hashCode();
    }

    @Override
    public String getDisplayName() {
        String group = this.moduleIdentifier.getGroup();
        String module = this.moduleIdentifier.getName();
        StringBuilder builder = new StringBuilder(group.length() + module.length() + this.version.length() + 2);
        builder.append(group);
        builder.append(":");
        builder.append(module);
        builder.append(":");
        builder.append(this.version);
        return builder.toString();
    }

    @Override
    public String getCapitalizedDisplayName() {
        return this.getDisplayName();
    }

    @Override
    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    @Override
    public String getModule() {
        return this.moduleIdentifier.getName();
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentIdentifier that = (DefaultModuleComponentIdentifier)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (!this.moduleIdentifier.equals(that.moduleIdentifier)) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ModuleComponentIdentifier newId(ModuleIdentifier module, String version) {
        return new DefaultModuleComponentIdentifier(module, version);
    }

    public static ModuleComponentIdentifier newId(ModuleVersionIdentifier moduleVersionIdentifier) {
        return new DefaultModuleComponentIdentifier(moduleVersionIdentifier.getModule(), moduleVersionIdentifier.getVersion());
    }
}

