/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import java.util.function.Consumer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.ExecutionPlanFactory;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.taskgraph.TaskExecutionGraphInternal;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;

public class DefaultBuildWorkPreparer
implements BuildWorkPreparer {
    private final ExecutionPlanFactory executionPlanFactory;

    public DefaultBuildWorkPreparer(ExecutionPlanFactory executionPlanFactory) {
        this.executionPlanFactory = executionPlanFactory;
    }

    @Override
    public ExecutionPlan newExecutionPlan() {
        return this.executionPlanFactory.createPlan();
    }

    @Override
    public void populateWorkGraph(GradleInternal gradle, ExecutionPlan plan, Consumer<? super ExecutionPlan> action) {
        action.accept(plan);
        plan.determineExecutionPlan();
    }

    @Override
    public FinalizedExecutionPlan finalizeWorkGraph(GradleInternal gradle, ExecutionPlan plan) {
        TaskExecutionGraphInternal taskGraph = gradle.getTaskGraph();
        if (gradle.getStartParameter().isContinueOnFailure()) {
            plan.setContinueOnFailure(true);
        }
        FinalizedExecutionPlan finalizedExecutionPlan = plan.finalizePlan();
        taskGraph.populate(finalizedExecutionPlan);
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = gradle.getServices().get(BuildOutputCleanupRegistry.class);
        buildOutputCleanupRegistry.resolveOutputs();
        return finalizedExecutionPlan;
    }
}

