/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.authentication;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.gradle.api.credentials.Credentials;
import org.gradle.authentication.Authentication;
import org.gradle.internal.authentication.AuthenticationInternal;
import org.gradle.internal.impldep.com.google.common.collect.Sets;

public abstract class AbstractAuthentication
implements AuthenticationInternal {
    private final String name;
    private final Class<? extends Credentials> supportedCredentialType;
    private final Class<? extends Authentication> type;
    private Credentials credentials;
    private final Set<AuthenticationInternal.HostAndPort> hosts;

    public AbstractAuthentication(String name, Class<? extends Authentication> type) {
        this(name, type, null);
    }

    public AbstractAuthentication(String name, Class<? extends Authentication> type, Class<? extends Credentials> supportedCredential) {
        this.name = name;
        this.supportedCredentialType = supportedCredential;
        this.type = type;
        this.hosts = Sets.newHashSet();
    }

    @Override
    public Credentials getCredentials() {
        return this.credentials;
    }

    @Override
    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean supports(Credentials credentials) {
        return this.supportedCredentialType.isAssignableFrom(credentials.getClass());
    }

    @Override
    public Class<? extends Authentication> getType() {
        return this.type;
    }

    public String toString() {
        return String.format("'%s'(%s)", this.getName(), this.getType().getSimpleName());
    }

    @Override
    public Collection<AuthenticationInternal.HostAndPort> getHostsForAuthentication() {
        return this.hosts;
    }

    @Override
    public void addHost(String host, int port) {
        this.hosts.add(new DefaultHostAndPort(host, port));
    }

    private static class DefaultHostAndPort
    implements AuthenticationInternal.HostAndPort {
        private final String host;
        private final int port;

        DefaultHostAndPort(String host, int port) {
            this.host = host;
            this.port = port;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultHostAndPort that = (DefaultHostAndPort)o;
            return this.getPort() == that.getPort() && Objects.equals(this.getHost(), that.getHost());
        }

        public int hashCode() {
            return Objects.hash(this.getHost(), this.getPort());
        }
    }
}

