/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.BuildStructureOperationProject;
import org.gradle.initialization.LoadProjectsBuildOperationType;
import org.gradle.initialization.NotifyProjectsLoadedBuildOperationType;
import org.gradle.initialization.ProjectsIdentifiedProgressDetails;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.operations.RunnableBuildOperation;

public class NotifyingBuildLoader
implements BuildLoader {
    private static final NotifyProjectsLoadedBuildOperationType.Result PROJECTS_LOADED_OP_RESULT = new NotifyProjectsLoadedBuildOperationType.Result(){};
    private final BuildLoader buildLoader;
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildOperationProgressEventEmitter emitter;

    public NotifyingBuildLoader(BuildLoader buildLoader, BuildOperationExecutor buildOperationExecutor, BuildOperationProgressEventEmitter emitter) {
        this.buildLoader = buildLoader;
        this.buildOperationExecutor = buildOperationExecutor;
        this.emitter = emitter;
    }

    @Override
    public void load(final SettingsInternal settings, final GradleInternal gradle) {
        final String buildPath = gradle.getIdentityPath().toString();
        this.buildOperationExecutor.call(new CallableBuildOperation<Void>(){

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName("Load projects").progressDisplayName("Loading projects").details(new LoadProjectsBuildOperationType.Details(){

                    @Override
                    public String getBuildPath() {
                        return buildPath;
                    }
                });
            }

            @Override
            public Void call(BuildOperationContext context) {
                NotifyingBuildLoader.this.buildLoader.load(settings, gradle);
                BuildStructureOperationProject rootProject = BuildStructureOperationProject.from(gradle);
                NotifyingBuildLoader.this.emitter.emitNowForCurrent(new DefaultProjectsIdentifiedProgressDetails(rootProject, buildPath));
                context.setResult(new BuildStructureOperationResult(rootProject, buildPath));
                return null;
            }
        });
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            @Override
            public void run(BuildOperationContext context) {
                gradle.getBuildListenerBroadcaster().projectsLoaded(gradle);
                context.setResult(PROJECTS_LOADED_OP_RESULT);
            }

            @Override
            public BuildOperationDescriptor.Builder description() {
                return BuildOperationDescriptor.displayName(gradle.contextualize("Notify projectsLoaded listeners")).details(new NotifyProjectsLoadedBuildOperationType.Details(){

                    @Override
                    public String getBuildPath() {
                        return buildPath;
                    }
                });
            }
        });
    }

    private static class DefaultProjectsIdentifiedProgressDetails
    implements ProjectsIdentifiedProgressDetails {
        private final String buildPath;
        private final ProjectsIdentifiedProgressDetails.Project rootProject;

        public DefaultProjectsIdentifiedProgressDetails(ProjectsIdentifiedProgressDetails.Project rootProject, String buildPath) {
            this.buildPath = buildPath;
            this.rootProject = rootProject;
        }

        @Override
        public String getBuildPath() {
            return this.buildPath;
        }

        @Override
        public ProjectsIdentifiedProgressDetails.Project getRootProject() {
            return this.rootProject;
        }
    }

    private static class BuildStructureOperationResult
    implements LoadProjectsBuildOperationType.Result {
        private final LoadProjectsBuildOperationType.Result.Project rootProject;
        private final String buildPath;

        public BuildStructureOperationResult(LoadProjectsBuildOperationType.Result.Project rootProject, String buildPath) {
            this.rootProject = rootProject;
            this.buildPath = buildPath;
        }

        @Override
        public LoadProjectsBuildOperationType.Result.Project getRootProject() {
            return this.rootProject;
        }

        @Override
        public String getBuildPath() {
            return this.buildPath;
        }
    }
}

