/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.internal.properties.GradleProperties;
import org.gradle.initialization.GradlePropertiesController;
import org.gradle.initialization.IGradlePropertiesLoader;
import org.gradle.initialization.properties.MutableGradleProperties;
import org.gradle.initialization.properties.ProjectPropertiesLoader;
import org.gradle.initialization.properties.SystemPropertiesInstaller;

public class DefaultGradlePropertiesController
implements GradlePropertiesController {
    private State state = new NotLoaded();
    private final GradleProperties sharedGradleProperties = new SharedGradleProperties();
    private final IGradlePropertiesLoader propertiesLoader;
    private final SystemPropertiesInstaller systemPropertiesInstaller;
    private final ProjectPropertiesLoader projectPropertiesLoader;

    public DefaultGradlePropertiesController(IGradlePropertiesLoader propertiesLoader, SystemPropertiesInstaller systemPropertiesInstaller, ProjectPropertiesLoader projectPropertiesLoader) {
        this.propertiesLoader = propertiesLoader;
        this.systemPropertiesInstaller = systemPropertiesInstaller;
        this.projectPropertiesLoader = projectPropertiesLoader;
    }

    @Override
    public GradleProperties getGradleProperties() {
        return this.sharedGradleProperties;
    }

    @Override
    public void loadGradlePropertiesFrom(File settingsDir, boolean setSystemProperties) {
        this.state = this.state.loadGradlePropertiesFrom(settingsDir, setSystemProperties);
    }

    @Override
    public void unloadGradleProperties() {
        this.state = new NotLoaded();
    }

    public void overrideWith(GradleProperties gradleProperties2) {
        this.state = this.state.overrideWith(gradleProperties2);
    }

    private static class Overridden
    implements State {
        private final GradleProperties gradleProperties;

        public Overridden(GradleProperties gradleProperties2) {
            this.gradleProperties = gradleProperties2;
        }

        @Override
        public GradleProperties gradleProperties() {
            return this.gradleProperties;
        }

        @Override
        public State loadGradlePropertiesFrom(File settingsDir, boolean setSystemProperties) {
            throw new IllegalStateException();
        }

        @Override
        public State overrideWith(GradleProperties gradleProperties2) {
            return new Overridden(gradleProperties2);
        }
    }

    private static class Loaded
    implements State {
        private final GradleProperties gradleProperties;
        private final File propertiesDir;

        public Loaded(MutableGradleProperties gradleProperties2, File propertiesDir) {
            this.gradleProperties = gradleProperties2;
            this.propertiesDir = propertiesDir;
        }

        @Override
        public GradleProperties gradleProperties() {
            return this.gradleProperties;
        }

        @Override
        public State loadGradlePropertiesFrom(File settingsDir, boolean setSystemProperties) {
            if (!this.propertiesDir.equals(settingsDir)) {
                throw new IllegalStateException(String.format("GradleProperties has already been loaded from '%s' and cannot be loaded from '%s'.", this.propertiesDir, settingsDir));
            }
            return this;
        }

        @Override
        public State overrideWith(GradleProperties gradleProperties2) {
            throw new IllegalStateException("GradleProperties has already been loaded and cannot be overridden.");
        }
    }

    private class NotLoaded
    implements State {
        private NotLoaded() {
        }

        @Override
        public GradleProperties gradleProperties() {
            throw new IllegalStateException("GradleProperties has not been loaded yet.");
        }

        @Override
        public State loadGradlePropertiesFrom(File settingsDir, boolean setSystemProperties) {
            MutableGradleProperties loadedProperties = DefaultGradlePropertiesController.this.propertiesLoader.loadGradleProperties(settingsDir);
            if (setSystemProperties) {
                DefaultGradlePropertiesController.this.systemPropertiesInstaller.setSystemPropertiesFrom(loadedProperties);
            }
            Map<String, Object> projectProperties = DefaultGradlePropertiesController.this.projectPropertiesLoader.loadProjectProperties();
            loadedProperties.updateOverrideProperties(projectProperties);
            return new Loaded(loadedProperties, settingsDir);
        }

        @Override
        public State overrideWith(GradleProperties gradleProperties2) {
            return new Overridden(gradleProperties2);
        }
    }

    private static interface State {
        public GradleProperties gradleProperties();

        public State loadGradlePropertiesFrom(File var1, boolean var2);

        public State overrideWith(GradleProperties var1);
    }

    private class SharedGradleProperties
    implements GradleProperties {
        private SharedGradleProperties() {
        }

        @Override
        @Nullable
        public Object find(String propertyName) {
            return this.gradleProperties().find(propertyName);
        }

        @Override
        public Map<String, Object> mergeProperties(Map<String, Object> properties) {
            return this.gradleProperties().mergeProperties(properties);
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.gradleProperties().getProperties();
        }

        private GradleProperties gradleProperties() {
            return DefaultGradlePropertiesController.this.state.gradleProperties();
        }
    }
}

