/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration.project;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.configuration.project.ConfigureProjectBuildOperationType;
import org.gradle.configuration.project.NotifyProjectAfterEvaluatedBuildOperationType;
import org.gradle.configuration.project.NotifyProjectBeforeEvaluatedBuildOperationType;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.operations.BuildOperationCategory;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.util.Path;

public class LifecycleProjectEvaluator
implements ProjectEvaluator {
    private final BuildOperationExecutor buildOperationExecutor;
    private final ProjectEvaluator delegate;
    private final BuildCancellationToken cancellationToken;

    public LifecycleProjectEvaluator(BuildOperationExecutor buildOperationExecutor, ProjectEvaluator delegate, BuildCancellationToken cancellationToken) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
        this.cancellationToken = cancellationToken;
    }

    @Override
    public void evaluate(ProjectInternal project, ProjectStateInternal state) {
        if (state.isUnconfigured()) {
            if (this.cancellationToken.isCancellationRequested()) {
                throw new BuildCancelledException();
            }
            this.buildOperationExecutor.run(new EvaluateProject(project, state));
        }
    }

    private static void addConfigurationFailure(ProjectInternal project, ProjectStateInternal state, Exception e, BuildOperationContext ctx) {
        ProjectConfigurationException exception = LifecycleProjectEvaluator.wrapException(project, e);
        ctx.failed(exception);
        state.failed(exception);
    }

    private static ProjectConfigurationException wrapException(ProjectInternal project, Exception e) {
        return new ProjectConfigurationException(String.format("A problem occurred configuring %s.", project.getDisplayName()), (Throwable)e);
    }

    public static BuildOperationDescriptor.Builder configureProjectBuildOperationBuilderFor(ProjectInternal projectInternal) {
        Path identityPath = projectInternal.getIdentityPath();
        String displayName = "Configure project " + identityPath;
        String progressDisplayName = identityPath.toString();
        if (identityPath.equals(Path.ROOT)) {
            progressDisplayName = "root project";
        }
        return BuildOperationDescriptor.displayName(displayName).metadata(BuildOperationCategory.CONFIGURE_PROJECT).progressDisplayName(progressDisplayName).details(new ConfigureProjectDetails(projectInternal.getProjectPath(), projectInternal.getGradle().getIdentityPath(), projectInternal.getRootDir()));
    }

    private static class NotifyProjectAfterEvaluatedDetails
    implements NotifyProjectAfterEvaluatedBuildOperationType.Details {
        private final Path buildPath;
        private final Path projectPath;

        NotifyProjectAfterEvaluatedDetails(Path projectPath, Path buildPath) {
            this.projectPath = projectPath;
            this.buildPath = buildPath;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath.getPath();
        }

        @Override
        public String getBuildPath() {
            return this.buildPath.getPath();
        }
    }

    private static class NotifyAfterEvaluate
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private NotifyAfterEvaluate(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        @Override
        public void run(BuildOperationContext context) {
            ProjectEvaluationListener nextBatch = this.project.getProjectEvaluationBroadcaster();
            Action<ProjectEvaluationListener> fireAction = new Action<ProjectEvaluationListener>(){

                @Override
                public void execute(ProjectEvaluationListener listener2) {
                    listener2.afterEvaluate(project, state);
                }
            };
            do {
                try {
                    nextBatch = this.project.stepEvaluationListener(nextBatch, fireAction);
                }
                catch (Exception e) {
                    LifecycleProjectEvaluator.addConfigurationFailure(this.project, this.state, e, context);
                    return;
                }
            } while (nextBatch != null);
            context.setResult(NotifyProjectAfterEvaluatedBuildOperationType.RESULT);
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Notify afterEvaluate listeners of " + this.project.getIdentityPath()).details(new NotifyProjectAfterEvaluatedDetails(this.project.getProjectPath(), this.project.getGradle().getIdentityPath()));
        }
    }

    private static class NotifyProjectBeforeEvaluatedDetails
    implements NotifyProjectBeforeEvaluatedBuildOperationType.Details {
        private final Path buildPath;
        private final Path projectPath;

        NotifyProjectBeforeEvaluatedDetails(Path projectPath, Path buildPath) {
            this.projectPath = projectPath;
            this.buildPath = buildPath;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath.getPath();
        }

        @Override
        public String getBuildPath() {
            return this.buildPath.getPath();
        }
    }

    private static class NotifyBeforeEvaluate
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private NotifyBeforeEvaluate(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        @Override
        public void run(BuildOperationContext context) {
            try {
                this.project.getProjectEvaluationBroadcaster().beforeEvaluate(this.project);
                context.setResult(NotifyProjectBeforeEvaluatedBuildOperationType.RESULT);
            }
            catch (Exception e) {
                LifecycleProjectEvaluator.addConfigurationFailure(this.project, this.state, e, context);
            }
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Notify beforeEvaluate listeners of " + this.project.getIdentityPath()).details(new NotifyProjectBeforeEvaluatedDetails(this.project.getProjectPath(), this.project.getGradle().getIdentityPath()));
        }
    }

    private static class ConfigureProjectDetails
    implements ConfigureProjectBuildOperationType.Details {
        private final Path buildPath;
        private final File rootDir;
        private final Path projectPath;

        public ConfigureProjectDetails(Path projectPath, Path buildPath, File rootDir) {
            this.projectPath = projectPath;
            this.buildPath = buildPath;
            this.rootDir = rootDir;
        }

        @Override
        public String getProjectPath() {
            return this.projectPath.getPath();
        }

        @Override
        public String getBuildPath() {
            return this.buildPath.getPath();
        }

        @Override
        public File getRootDir() {
            return this.rootDir;
        }
    }

    private class EvaluateProject
    implements RunnableBuildOperation {
        private final ProjectInternal project;
        private final ProjectStateInternal state;

        private EvaluateProject(ProjectInternal project, ProjectStateInternal state) {
            this.project = project;
            this.state = state;
        }

        @Override
        public void run(BuildOperationContext context) {
            this.project.getOwner().applyToMutableState(p -> {
                try {
                    this.state.toBeforeEvaluate();
                    LifecycleProjectEvaluator.this.buildOperationExecutor.run(new NotifyBeforeEvaluate(this.project, this.state));
                    if (!this.state.hasFailure()) {
                        this.state.toEvaluate();
                        try {
                            LifecycleProjectEvaluator.this.delegate.evaluate(this.project, this.state);
                        }
                        catch (Exception e) {
                            LifecycleProjectEvaluator.addConfigurationFailure(this.project, this.state, e, context);
                        }
                        finally {
                            this.state.toAfterEvaluate();
                            LifecycleProjectEvaluator.this.buildOperationExecutor.run(new NotifyAfterEvaluate(this.project, this.state));
                        }
                    }
                    if (this.state.hasFailure()) {
                        this.state.rethrowFailure();
                    } else {
                        context.setResult(ConfigureProjectBuildOperationType.RESULT);
                    }
                }
                finally {
                    this.state.configured();
                }
            });
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return LifecycleProjectEvaluator.configureProjectBuildOperationBuilderFor(this.project);
        }
    }
}

