/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.controller;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.CacheableEntity;
import org.gradle.caching.internal.DefaultBuildCacheKey;
import org.gradle.caching.internal.NextGenBuildCacheService;
import org.gradle.caching.internal.controller.BuildCacheController;
import org.gradle.caching.internal.controller.CacheManifest;
import org.gradle.caching.internal.controller.NextGenBuildCacheAccess;
import org.gradle.caching.internal.controller.operations.LoadOperationDetails;
import org.gradle.caching.internal.controller.operations.LoadOperationHitResult;
import org.gradle.caching.internal.controller.operations.LoadOperationMissResult;
import org.gradle.caching.internal.controller.operations.PackOperationDetails;
import org.gradle.caching.internal.controller.operations.PackOperationResult;
import org.gradle.caching.internal.controller.operations.StoreOperationDetails;
import org.gradle.caching.internal.controller.operations.StoreOperationResult;
import org.gradle.caching.internal.controller.operations.UnpackOperationDetails;
import org.gradle.caching.internal.controller.operations.UnpackOperationResult;
import org.gradle.caching.internal.controller.service.BuildCacheLoadResult;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.caching.internal.packaging.impl.RelativePathParser;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.file.BufferProvider;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.file.FileMetadata;
import org.gradle.internal.file.FileType;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.file.impl.DefaultFileMetadata;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Preconditions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.io.Closer;
import org.gradle.internal.impldep.com.google.common.io.CountingInputStream;
import org.gradle.internal.impldep.com.google.gson.Gson;
import org.gradle.internal.impldep.com.google.gson.GsonBuilder;
import org.gradle.internal.impldep.com.google.gson.TypeAdapter;
import org.gradle.internal.impldep.com.google.gson.stream.JsonReader;
import org.gradle.internal.impldep.com.google.gson.stream.JsonWriter;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.impldep.org.apache.commons.io.input.UnsynchronizedByteArrayInputStream;
import org.gradle.internal.impldep.org.apache.commons.io.output.NullOutputStream;
import org.gradle.internal.impldep.org.apache.commons.io.output.TeeOutputStream;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.snapshot.DirectorySnapshotBuilder;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.MerkleDirectorySnapshotBuilder;
import org.gradle.internal.snapshot.RegularFileSnapshot;
import org.gradle.internal.snapshot.RelativePathTracker;
import org.gradle.internal.snapshot.SnapshotUtil;
import org.gradle.internal.snapshot.SnapshotVisitResult;
import org.gradle.internal.vfs.FileSystemAccess;
import org.slf4j.Logger;

public class NextGenBuildCacheController
implements BuildCacheController {
    public static final String NEXT_GEN_CACHE_SYSTEM_PROPERTY = "org.gradle.unsafe.cache.ng";
    private final BufferProvider bufferProvider;
    private final BuildOperationExecutor buildOperationExecutor;
    private final NextGenBuildCacheAccess cacheAccess;
    private final FileSystemAccess fileSystemAccess;
    private final String buildInvocationId;
    private final Logger logger;
    private final Deleter deleter;
    private final StringInterner stringInterner;
    private final Gson gson;

    public NextGenBuildCacheController(String buildInvocationId, Logger logger, Deleter deleter, FileSystemAccess fileSystemAccess, BufferProvider bufferProvider, StringInterner stringInterner, BuildOperationExecutor buildOperationExecutor, NextGenBuildCacheAccess cacheAccess) {
        this.buildInvocationId = buildInvocationId;
        this.logger = logger;
        this.deleter = deleter;
        this.fileSystemAccess = fileSystemAccess;
        this.bufferProvider = bufferProvider;
        this.buildOperationExecutor = buildOperationExecutor;
        this.cacheAccess = cacheAccess;
        this.stringInterner = stringInterner;
        this.gson = NextGenBuildCacheController.createGson();
        logger.warn("Creating next-generation build cache controller");
    }

    @VisibleForTesting
    public static Gson createGson() {
        return new GsonBuilder().registerTypeAdapter(Duration.class, (Object)new TypeAdapter<Duration>(){

            public void write(JsonWriter out, Duration value) throws IOException {
                out.value(value.toMillis());
            }

            public Duration read(JsonReader in) throws IOException {
                return Duration.ofMillis(in.nextLong());
            }
        }).registerTypeAdapter(HashCode.class, (Object)new TypeAdapter<HashCode>(){

            public void write(JsonWriter out, HashCode value) throws IOException {
                out.value(value.toString());
            }

            public HashCode read(JsonReader in) throws IOException {
                return HashCode.fromString(in.nextString());
            }
        }).create();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isEmitDebugLogging() {
        return false;
    }

    @Override
    public Optional<BuildCacheLoadResult> load(BuildCacheKey manifestKey, CacheableEntity cacheableEntity) {
        try (final OperationFiringLoadHandlerFactory handlerFactory = new OperationFiringLoadHandlerFactory(manifestKey);){
            AtomicReference manifestRef = new AtomicReference();
            AtomicLong manifestSize = new AtomicLong(-1L);
            this.cacheAccess.load(Collections.singletonMap(manifestKey, null), handlerFactory.create((manifestStream, __) -> {
                CountingInputStream counterStream = new CountingInputStream(manifestStream);
                manifestRef.set((CacheManifest)this.gson.fromJson((Reader)new InputStreamReader((InputStream)counterStream), CacheManifest.class));
                manifestSize.set(counterStream.getCount());
            }));
            final CacheManifest manifest = (CacheManifest)manifestRef.get();
            if (manifest == null) {
                Optional<BuildCacheLoadResult> optional = Optional.empty();
                return optional;
            }
            long totalSize = manifest.getPropertyManifests().values().stream().flatMap(Collection::stream).map(CacheManifest.ManifestEntry::getLength).reduce(manifestSize.get(), Long::sum);
            handlerFactory.ensureUnpackOperationStrated(totalSize);
            final ImmutableSortedMap<String, FileSystemSnapshot> resultingSnapshots = this.loadContent(cacheableEntity, manifest, handlerFactory);
            Optional<BuildCacheLoadResult> optional = Optional.of(new BuildCacheLoadResult(){

                @Override
                public long getArtifactEntryCount() {
                    return handlerFactory.unpackedEntryCount.get();
                }

                @Override
                public OriginMetadata getOriginMetadata() {
                    return manifest.getOriginMetadata();
                }

                @Override
                public ImmutableSortedMap<String, FileSystemSnapshot> getResultingSnapshots() {
                    return resultingSnapshots;
                }
            });
            return optional;
        }
    }

    private ImmutableSortedMap<String, FileSystemSnapshot> loadContent(CacheableEntity cacheableEntity, CacheManifest manifest, OperationFiringLoadHandlerFactory handlerFactory) {
        ImmutableSortedMap.Builder snapshots = ImmutableSortedMap.naturalOrder();
        cacheableEntity.visitOutputTrees((propertyName, type, root) -> {
            this.fileSystemAccess.write(Collections.singleton(root.getAbsolutePath()), () -> {});
            try {
                this.cleanOutputDirectory(type, root);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            ImmutableListMultimap.Builder filesBuilder = ImmutableListMultimap.builder();
            List<CacheManifest.ManifestEntry> manifestEntries = manifest.getPropertyManifests().get(propertyName);
            manifestEntries.forEach(entry -> {
                File file = new File(root, entry.getRelativePath());
                switch (entry.getType()) {
                    case Directory: {
                        file.mkdirs();
                        break;
                    }
                    case RegularFile: {
                        filesBuilder.put((Object)new DefaultBuildCacheKey(entry.getContentHash()), (Object)file);
                        break;
                    }
                    case Missing: {
                        FileUtils.deleteQuietly((File)file);
                    }
                }
            });
            this.cacheAccess.load(filesBuilder.build().asMap(), handlerFactory.create((input, filesForHash) -> {
                try (Closer closer = Closer.create();){
                    OutputStream output = filesForHash.stream().map(file -> {
                        try {
                            return (FileOutputStream)closer.register((Closeable)new FileOutputStream((File)file));
                        }
                        catch (FileNotFoundException e) {
                            throw new UncheckedIOException("Couldn't create " + file.getAbsolutePath(), e);
                        }
                    }).map(OutputStream.class::cast).reduce(TeeOutputStream::new).orElse((OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                    IOUtils.copyLarge((InputStream)input, (OutputStream)output, (byte[])this.bufferProvider.getBuffer());
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(ex);
                }
            }));
            this.createSnapshot(type, root, manifestEntries).ifPresent(snapshot -> {
                snapshots.put((Object)propertyName, snapshot);
                this.fileSystemAccess.record((FileSystemLocationSnapshot)snapshot);
            });
        });
        return snapshots.build();
    }

    @VisibleForTesting
    Optional<FileSystemLocationSnapshot> createSnapshot(TreeType type, File root, List<CacheManifest.ManifestEntry> entries) {
        switch (type) {
            case DIRECTORY: {
                return Optional.of(this.createDirectorySnapshot(root, entries));
            }
            case FILE: {
                if (entries.size() != 1) {
                    throw new IllegalStateException("Expected a single manifest entry, found " + entries.size());
                }
                CacheManifest.ManifestEntry rootEntry = entries.get(0);
                switch (rootEntry.getType()) {
                    case Directory: {
                        throw new IllegalStateException("Directory manifest entry found for a file output");
                    }
                    case RegularFile: {
                        return Optional.of(this.createFileSnapshot(rootEntry, root));
                    }
                    case Missing: {
                        return Optional.empty();
                    }
                }
                throw new AssertionError((Object)("Unknown manifest entry type " + (Object)((Object)rootEntry.getType())));
            }
        }
        throw new AssertionError((Object)("Unknown output type " + (Object)((Object)type)));
    }

    private FileSystemLocationSnapshot createDirectorySnapshot(File root, List<CacheManifest.ManifestEntry> entries) {
        String rootPath = root.getName() + "/";
        RelativePathParser parser = new RelativePathParser(rootPath);
        DirectorySnapshotBuilder builder = MerkleDirectorySnapshotBuilder.noSortingRequired();
        builder.enterDirectory(FileMetadata.AccessType.DIRECT, this.stringInterner.intern(root.getAbsolutePath()), this.stringInterner.intern(root.getName()), DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
        for (CacheManifest.ManifestEntry entry : Iterables.skip(entries, (int)1)) {
            File file = new File(root, entry.getRelativePath());
            boolean isDirectory = entry.getType() == FileType.Directory;
            String relativePath = isDirectory ? rootPath + entry.getRelativePath() + "/" : rootPath + entry.getRelativePath();
            boolean outsideOfRoot = parser.nextPath(relativePath, isDirectory, builder::leaveDirectory);
            if (outsideOfRoot) break;
            switch (entry.getType()) {
                case Directory: {
                    String internedAbsolutePath = this.stringInterner.intern(file.getAbsolutePath());
                    String internedName = this.stringInterner.intern(parser.getName());
                    builder.enterDirectory(FileMetadata.AccessType.DIRECT, internedAbsolutePath, internedName, DirectorySnapshotBuilder.EmptyDirectoryHandlingStrategy.INCLUDE_EMPTY_DIRS);
                    break;
                }
                case RegularFile: {
                    RegularFileSnapshot fileSnapshot = this.createFileSnapshot(entry, file);
                    builder.visitLeafElement(fileSnapshot);
                    break;
                }
            }
        }
        parser.exitToRoot(builder::leaveDirectory);
        builder.leaveDirectory();
        return (FileSystemLocationSnapshot)Preconditions.checkNotNull((Object)builder.getResult());
    }

    private RegularFileSnapshot createFileSnapshot(CacheManifest.ManifestEntry entry, File file) {
        return new RegularFileSnapshot(this.stringInterner.intern(file.getAbsolutePath()), this.stringInterner.intern(file.getName()), entry.getContentHash(), DefaultFileMetadata.file(file.lastModified(), entry.getLength(), FileMetadata.AccessType.DIRECT));
    }

    @Override
    public void store(BuildCacheKey manifestKey, CacheableEntity entity, Map<String, FileSystemSnapshot> snapshots, Duration executionTime) {
        ImmutableMap.Builder propertyManifests = ImmutableMap.builder();
        AtomicLong contentSize = new AtomicLong(0L);
        entity.visitOutputTrees((propertyName, type, root) -> {
            ImmutableList.Builder manifestEntries = ImmutableList.builder();
            FileSystemSnapshot rootSnapshot = (FileSystemSnapshot)snapshots.get(propertyName);
            rootSnapshot.accept(new RelativePathTracker(), (snapshot, relativePath) -> {
                if (relativePath.isRoot()) {
                    NextGenBuildCacheController.assertCorrectType(type, snapshot);
                }
                long size = SnapshotUtil.getLength(snapshot);
                manifestEntries.add((Object)new CacheManifest.ManifestEntry(snapshot.getType(), relativePath.toRelativePath(), snapshot.getHash(), size));
                contentSize.addAndGet(size);
                return SnapshotVisitResult.CONTINUE;
            });
            propertyManifests.put((Object)propertyName, (Object)manifestEntries.build());
        });
        CacheManifest manifest = new CacheManifest(new OriginMetadata(this.buildInvocationId, executionTime), entity.getType().getName(), entity.getIdentity(), (Map<String, List<CacheManifest.ManifestEntry>>)propertyManifests.build());
        String manifestJson = this.gson.toJson((Object)manifest);
        byte[] manifestBytes = manifestJson.getBytes(StandardCharsets.UTF_8);
        long totalUploadSize = contentSize.get() + (long)manifestBytes.length;
        try (OperationFiringStoreHandlerFactory handlerFactory = new OperationFiringStoreHandlerFactory(manifestKey, totalUploadSize);){
            this.storeInner(manifestKey, entity, manifest, manifestBytes, handlerFactory);
        }
    }

    private void storeInner(BuildCacheKey manifestKey, CacheableEntity entity, CacheManifest manifest, final byte[] manifestBytes, OperationFiringStoreHandlerFactory handlerFactory) {
        entity.visitOutputTrees((propertyName, type, root) -> {
            Map manifestIndex = (Map)manifest.getPropertyManifests().get(propertyName).stream().filter(entry -> entry.getType() == FileType.RegularFile).collect(ImmutableMap.toImmutableMap(manifestEntry -> new DefaultBuildCacheKey(manifestEntry.getContentHash()), Function.identity(), (a, b) -> a));
            this.cacheAccess.store(manifestIndex, handlerFactory.create(manifestEntry -> new CountingWriter(handlerFactory.packEntryCount, handlerFactory.totalPackSize, (CacheManifest.ManifestEntry)manifestEntry){
                final /* synthetic */ CacheManifest.ManifestEntry val$manifestEntry;
                {
                    this.val$manifestEntry = manifestEntry;
                    super(entryCount, totalSize);
                }

                @Override
                protected InputStream doOpenStream() throws IOException {
                    return new FileInputStream(new File(root, this.val$manifestEntry.getRelativePath()));
                }

                @Override
                protected void doWriteTo(OutputStream output) throws IOException {
                    try (InputStream input = this.openStream();){
                        IOUtils.copyLarge((InputStream)input, (OutputStream)output, (byte[])NextGenBuildCacheController.this.bufferProvider.getBuffer());
                    }
                }

                @Override
                public long getSize() {
                    return this.val$manifestEntry.getLength();
                }
            }));
        });
        this.cacheAccess.store(Collections.singletonMap(manifestKey, manifest), handlerFactory.create(__ -> new CountingWriter(handlerFactory.packEntryCount, handlerFactory.totalPackSize){

            @Override
            protected InputStream doOpenStream() {
                return new UnsynchronizedByteArrayInputStream(manifestBytes);
            }

            @Override
            protected void doWriteTo(OutputStream output) throws IOException {
                output.write(manifestBytes);
            }

            @Override
            public long getSize() {
                return manifestBytes.length;
            }
        }));
    }

    private static void assertCorrectType(TreeType type, FileSystemLocationSnapshot snapshot) {
        if (snapshot.getType() == FileType.Missing) {
            return;
        }
        switch (type) {
            case DIRECTORY: {
                if (snapshot.getType() == FileType.Directory) break;
                throw new IllegalArgumentException(String.format("Expected '%s' to be a directory", snapshot.getAbsolutePath()));
            }
            case FILE: {
                if (snapshot.getType() == FileType.RegularFile) break;
                throw new IllegalArgumentException(String.format("Expected '%s' to be a file", snapshot.getAbsolutePath()));
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.logger.warn("Closing next-generation build cache controller");
        this.cacheAccess.close();
    }

    private void cleanOutputDirectory(TreeType type, File root) throws IOException {
        switch (type) {
            case DIRECTORY: {
                this.deleter.ensureEmptyDirectory(root);
                break;
            }
            case FILE: {
                if (this.makeDirectory(root.getParentFile()) || !root.exists()) break;
                this.deleter.deleteRecursively(root);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private boolean makeDirectory(File target) throws IOException {
        if (target.isDirectory()) {
            return false;
        }
        if (target.isFile()) {
            this.deleter.delete(target);
        }
        FileUtils.forceMkdir((File)target);
        return true;
    }

    public static boolean isNextGenCachingEnabled() {
        return Boolean.getBoolean(NEXT_GEN_CACHE_SYSTEM_PROPERTY) == Boolean.TRUE;
    }

    private static abstract class CountingWriter
    implements NextGenBuildCacheService.NextGenWriter {
        private final AtomicLong entryCount;
        private final AtomicLong totalSize;

        public CountingWriter(AtomicLong entryCount, AtomicLong totalSize) {
            this.entryCount = entryCount;
            this.totalSize = totalSize;
        }

        @Override
        public final InputStream openStream() throws IOException {
            this.markStored();
            return this.doOpenStream();
        }

        @Override
        public final void writeTo(OutputStream output) throws IOException {
            this.markStored();
            this.doWriteTo(output);
        }

        protected abstract InputStream doOpenStream() throws IOException;

        protected abstract void doWriteTo(OutputStream var1) throws IOException;

        private void markStored() {
            this.entryCount.incrementAndGet();
            this.totalSize.addAndGet(this.getSize());
        }
    }

    private class OperationFiringStoreHandlerFactory
    implements Closeable {
        private final BuildCacheKey manifestKey;
        private final long totalUploadSize;
        private final OnDemandBuildOperationWrapper packBuildOp;
        private final AtomicLong packEntryCount;
        private final AtomicLong totalPackSize;
        private final OnDemandBuildOperationWrapper storeBuildOp;
        private final AtomicBoolean storeEncountered;

        public OperationFiringStoreHandlerFactory(BuildCacheKey manifestKey, long totalUploadSize) {
            this.packBuildOp = new OnDemandBuildOperationWrapper();
            this.packEntryCount = new AtomicLong(0L);
            this.totalPackSize = new AtomicLong(0L);
            this.storeBuildOp = new OnDemandBuildOperationWrapper();
            this.storeEncountered = new AtomicBoolean(false);
            this.manifestKey = manifestKey;
            this.totalUploadSize = totalUploadSize;
            this.packBuildOp.ensureStarted(() -> BuildOperationDescriptor.displayName("Pack build cache entry " + manifestKey).details(new PackOperationDetails(manifestKey)).progressDisplayName("Packing build cache entry"));
        }

        public <T> NextGenBuildCacheAccess.StoreHandler<T> create(final Function<T, NextGenBuildCacheService.NextGenWriter> delegate) {
            return new NextGenBuildCacheAccess.StoreHandler<T>(){

                @Override
                public NextGenBuildCacheService.NextGenWriter createWriter(T payload) {
                    return (NextGenBuildCacheService.NextGenWriter)delegate.apply(payload);
                }

                @Override
                public void ensureStoreOperationStarted(BuildCacheKey key) {
                    OperationFiringStoreHandlerFactory.this.storeBuildOp.ensureStarted(() -> BuildOperationDescriptor.displayName("Store entry " + OperationFiringStoreHandlerFactory.this.manifestKey.getDisplayName() + " in remote build cache").details(new StoreOperationDetails(OperationFiringStoreHandlerFactory.this.manifestKey, OperationFiringStoreHandlerFactory.this.totalUploadSize)).progressDisplayName("Uploading to remote build cache"));
                }

                @Override
                public void recordStoreFinished(BuildCacheKey key, boolean stored) {
                    if (stored) {
                        OperationFiringStoreHandlerFactory.this.storeEncountered.set(true);
                    }
                }

                @Override
                public void recordStoreFailure(BuildCacheKey key, Throwable failure) {
                    OperationFiringStoreHandlerFactory.this.storeBuildOp.fail(failure);
                }

                @Override
                public void recordPackFailure(BuildCacheKey key, Throwable failure) {
                    OperationFiringStoreHandlerFactory.this.packBuildOp.fail(failure);
                }
            };
        }

        @Override
        public void close() {
            this.storeBuildOp.finishIfNecessary(() -> this.storeEncountered.get() ? StoreOperationResult.STORED : StoreOperationResult.NOT_STORED);
            this.packBuildOp.finishIfNecessary(() -> new PackOperationResult(this.packEntryCount.get(), this.totalPackSize.get()));
        }
    }

    private class OperationFiringLoadHandlerFactory
    implements Closeable {
        private final BuildCacheKey manifestKey;
        private final OnDemandBuildOperationWrapper unpackBuildOp;
        private final OnDemandBuildOperationWrapper loadBuildOp;
        private final AtomicLong unpackedEntryCount;
        private final AtomicLong totalUnpackedSize;
        private final AtomicLong totalDownloadedSize;
        private final AtomicBoolean missEncountered;
        private OnDemandBuildOperationWrapper parentOp;

        public OperationFiringLoadHandlerFactory(BuildCacheKey manifestKey) {
            this.unpackBuildOp = new OnDemandBuildOperationWrapper();
            this.loadBuildOp = new OnDemandBuildOperationWrapper();
            this.unpackedEntryCount = new AtomicLong(0L);
            this.totalUnpackedSize = new AtomicLong(0L);
            this.totalDownloadedSize = new AtomicLong(0L);
            this.missEncountered = new AtomicBoolean(false);
            this.manifestKey = manifestKey;
        }

        public <T> NextGenBuildCacheAccess.LoadHandler<T> create(final BiConsumer<InputStream, T> delegate) {
            return new NextGenBuildCacheAccess.LoadHandler<T>(){

                @Override
                public void handle(InputStream input, T payload) {
                    CountingInputStream countingStream = new CountingInputStream(input);
                    delegate.accept(countingStream, payload);
                    OperationFiringLoadHandlerFactory.this.totalUnpackedSize.addAndGet(countingStream.getCount());
                    OperationFiringLoadHandlerFactory.this.unpackedEntryCount.incrementAndGet();
                }

                @Override
                public void ensureLoadOperationStarted(BuildCacheKey key) {
                    OperationFiringLoadHandlerFactory.this.loadBuildOp.ensureStarted(() -> BuildOperationDescriptor.displayName("Load entry " + OperationFiringLoadHandlerFactory.this.manifestKey.getDisplayName() + " from remote build cache").details(new LoadOperationDetails(OperationFiringLoadHandlerFactory.this.manifestKey)).progressDisplayName("Requesting from remote build cache"));
                    if (OperationFiringLoadHandlerFactory.this.parentOp == null) {
                        OperationFiringLoadHandlerFactory.this.parentOp = OperationFiringLoadHandlerFactory.this.loadBuildOp;
                    }
                }

                @Override
                public void recordLoadHit(BuildCacheKey key, long size) {
                    OperationFiringLoadHandlerFactory.this.totalDownloadedSize.addAndGet(size);
                }

                @Override
                public void recordLoadMiss(BuildCacheKey key) {
                    OperationFiringLoadHandlerFactory.this.missEncountered.set(true);
                }

                @Override
                public void recordLoadFailure(BuildCacheKey key, Throwable failure) {
                    OperationFiringLoadHandlerFactory.this.loadBuildOp.fail(failure);
                }

                @Override
                public void recordUnpackFailure(BuildCacheKey key, Throwable failure) {
                    OperationFiringLoadHandlerFactory.this.ensureUnpackOperationStrated(-1L);
                    OperationFiringLoadHandlerFactory.this.unpackBuildOp.fail(failure);
                }
            };
        }

        public void ensureUnpackOperationStrated(long totalSize) {
            this.unpackBuildOp.ensureStarted(() -> BuildOperationDescriptor.displayName("Unpack build cache entry " + this.manifestKey.getHashCode()).details(new UnpackOperationDetails(this.manifestKey, totalSize)).progressDisplayName("Unpacking build cache entry"));
            if (this.parentOp == null) {
                this.parentOp = this.unpackBuildOp;
            }
        }

        @Override
        public void close() {
            if (this.parentOp == this.loadBuildOp) {
                this.finishUnpackIfNecessary();
                this.finishLoadIfNecessary();
            } else {
                this.finishLoadIfNecessary();
                this.finishUnpackIfNecessary();
            }
        }

        private void finishLoadIfNecessary() {
            this.loadBuildOp.finishIfNecessary(() -> this.missEncountered.get() ? LoadOperationMissResult.INSTANCE : new LoadOperationHitResult(this.totalDownloadedSize.get()));
        }

        private void finishUnpackIfNecessary() {
            this.unpackBuildOp.finishIfNecessary(() -> new UnpackOperationResult(this.unpackedEntryCount.get()));
        }
    }

    private class OnDemandBuildOperationWrapper {
        private volatile BuildOperationContext context;
        private final List<Throwable> failures = new CopyOnWriteArrayList<Throwable>();

        private OnDemandBuildOperationWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ensureStarted(Supplier<BuildOperationDescriptor.Builder> describer) {
            if (this.context == null) {
                OnDemandBuildOperationWrapper onDemandBuildOperationWrapper = this;
                synchronized (onDemandBuildOperationWrapper) {
                    if (this.context == null) {
                        this.context = NextGenBuildCacheController.this.buildOperationExecutor.start(describer.get());
                    }
                }
            }
        }

        public void fail(Throwable failure) {
            this.failures.add(failure);
        }

        public void finishIfNecessary(Supplier<Object> result2) {
            if (this.context != null) {
                if (this.failures.isEmpty()) {
                    this.context.setResult(result2.get());
                } else {
                    this.context.failed(this.failures.size() == 1 ? this.failures.get(0) : new DefaultMultiCauseException("Errors encountered while loading entries from remote cache", this.failures));
                }
            }
        }
    }
}

