/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal.filelock;

import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;

public class LockOptionsBuilder
implements LockOptions {
    private FileLockManager.LockMode mode;
    private boolean crossVersion;

    private LockOptionsBuilder(FileLockManager.LockMode mode, boolean crossVersion) {
        this.mode = mode;
        this.crossVersion = crossVersion;
    }

    public static LockOptionsBuilder mode(FileLockManager.LockMode lockMode) {
        return new LockOptionsBuilder(lockMode, false);
    }

    public LockOptionsBuilder useCrossVersionImplementation() {
        this.crossVersion = true;
        return this;
    }

    @Override
    public FileLockManager.LockMode getMode() {
        return this.mode;
    }

    @Override
    public boolean isUseCrossVersionImplementation() {
        return this.crossVersion;
    }

    @Override
    public LockOptions withMode(FileLockManager.LockMode mode) {
        return new LockOptionsBuilder(mode, this.crossVersion);
    }

    public String toString() {
        return (Object)((Object)this.mode) + " (simple=" + this.crossVersion + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LockOptionsBuilder)) {
            return false;
        }
        LockOptionsBuilder that = (LockOptionsBuilder)o;
        if (this.crossVersion != that.crossVersion) {
            return false;
        }
        return this.mode == that.mode;
    }

    public int hashCode() {
        int result2 = this.mode.hashCode();
        result2 = 31 * result2 + (this.crossVersion ? 1 : 0);
        return result2;
    }
}

