/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.internal.project.ProjectHierarchyUtils;
import org.gradle.api.tasks.diagnostics.AbstractProjectBasedReportTask;
import org.gradle.api.tasks.diagnostics.internal.ProjectDetails;
import org.gradle.api.tasks.diagnostics.internal.TextReportRenderer;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.graph.GraphRenderer;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.util.Path;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching")
public abstract class ProjectReportTask
extends AbstractProjectBasedReportTask<ProjectReportModel> {
    private final TextReportRenderer renderer = new TextReportRenderer();

    @Override
    protected TextReportRenderer getRenderer() {
        return this.renderer;
    }

    @Inject
    public BuildStateRegistry getBuildStateRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ProjectReportModel calculateReportModelFor(Project project) {
        return new ProjectReportModel(ProjectDetails.of(project), this.calculateChildrenProjectsFor(project), project == project.getRootProject(), project.absoluteProjectPath("tasks"), project.getRootProject().absoluteProjectPath("projects"), this.calculateIncludedBuildIdentityPaths());
    }

    private List<ProjectReportModel> calculateChildrenProjectsFor(Project project) {
        List<Project> childProjects = CollectionUtils.sort(ProjectHierarchyUtils.getChildProjectsForInternalUse(project));
        ArrayList<ProjectReportModel> children = new ArrayList<ProjectReportModel>(childProjects.size());
        for (Project childProject : childProjects) {
            children.add(this.calculateReportModelFor(childProject));
        }
        return children;
    }

    private List<Path> calculateIncludedBuildIdentityPaths() {
        Collection<? extends IncludedBuildState> includedBuilds = this.getBuildStateRegistry().getIncludedBuilds();
        ArrayList<Path> includedBuildIdentityPaths = new ArrayList<Path>(includedBuilds.size());
        for (IncludedBuildState includedBuildState : includedBuilds) {
            includedBuildIdentityPaths.add(includedBuildState.getIdentityPath());
        }
        return includedBuildIdentityPaths;
    }

    @Override
    protected void generateReportFor(ProjectDetails project, ProjectReportModel model) {
        this.renderProjectTree(model);
        this.renderIncludedBuilds(model);
        this.renderHelp(project, model);
    }

    private void renderProjectTree(ProjectReportModel model) {
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        this.renderProject(model, new GraphRenderer(textOutput), true, textOutput);
        if (model.children.isEmpty()) {
            textOutput.withStyle(StyledTextOutput.Style.Info).text("No sub-projects");
            textOutput.println();
        }
    }

    private void renderProject(ProjectReportModel model, GraphRenderer renderer, boolean lastChild, StyledTextOutput textOutput) {
        renderer.visit(styledTextOutput -> {
            styledTextOutput.text(StringUtils.capitalize((String)model.project.getDisplayName()));
            String projectDescription = model.project.getDescription();
            if (projectDescription != null && !projectDescription.isEmpty()) {
                String description = projectDescription.trim();
                int newlineInDescription = description.indexOf(10);
                if (newlineInDescription > 0) {
                    textOutput.withStyle(StyledTextOutput.Style.Description).text(" - " + description.substring(0, newlineInDescription) + "...");
                } else {
                    textOutput.withStyle(StyledTextOutput.Style.Description).text(" - " + description);
                }
            }
        }, lastChild);
        renderer.startChildren();
        Iterator iterator = model.children.iterator();
        while (iterator.hasNext()) {
            ProjectReportModel child;
            this.renderProject(child, renderer, (child = (ProjectReportModel)iterator.next()) == model.children.get(model.children.size() - 1), textOutput);
        }
        renderer.completeChildren();
    }

    private void renderIncludedBuilds(ProjectReportModel model) {
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        if (model.isRootProject) {
            int index = 0;
            if (!model.includedBuildIdentityPaths.isEmpty()) {
                GraphRenderer renderer = new GraphRenderer(textOutput);
                textOutput.println();
                textOutput.text("Included builds");
                textOutput.println();
                renderer.startChildren();
                for (Path includedBuildIdentityPath : model.includedBuildIdentityPaths) {
                    renderer.visit(text -> textOutput.text("Included build '" + includedBuildIdentityPath + "'"), index + 1 == model.includedBuildIdentityPaths.size());
                    ++index;
                }
                renderer.completeChildren();
            }
        }
    }

    private void renderHelp(ProjectDetails project, ProjectReportModel model) {
        BuildClientMetaData metaData = this.getClientMetaData();
        StyledTextOutput textOutput = this.getRenderer().getTextOutput();
        textOutput.println();
        textOutput.text("To see a list of the tasks of a project, run ");
        metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), "<project-path>:tasks");
        textOutput.println();
        textOutput.text("For example, try running ");
        ProjectReportModel exampleProject = model.children.isEmpty() ? model : (ProjectReportModel)model.children.get(0);
        metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), exampleProject.tasksTaskPath);
        textOutput.println();
        if (!model.isRootProject) {
            textOutput.println();
            textOutput.text("To see a list of all the projects in this build, run ");
            metaData.describeCommand(textOutput.withStyle(StyledTextOutput.Style.UserInput), model.rootProjectProjectsTaskPath);
            textOutput.println();
        }
    }

    @Incubating
    public static final class ProjectReportModel {
        private final ProjectDetails project;
        private final List<ProjectReportModel> children;
        private final boolean isRootProject;
        private final String tasksTaskPath;
        private final String rootProjectProjectsTaskPath;
        private final List<Path> includedBuildIdentityPaths;

        private ProjectReportModel(ProjectDetails project, List<ProjectReportModel> children, boolean isRootProject, String tasksTaskPath, String rootProjectProjectsTaskPath, List<Path> includedBuildIdentityPaths) {
            this.project = project;
            this.children = children;
            this.isRootProject = isRootProject;
            this.tasksTaskPath = tasksTaskPath;
            this.rootProjectProjectsTaskPath = rootProjectProjectsTaskPath;
            this.includedBuildIdentityPaths = includedBuildIdentityPaths;
        }
    }
}

